<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty About Us Widget.
 *
 * @since 1.0
 */
class Quarty_About_Us_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-about-us';
	}

	public function get_title() {
		return esc_html__( 'About Us', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Content', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'quarty-plugin' ),
				'default'     => esc_html__( 'Title', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'quarty-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1'  => __( 'H1', 'quarty-plugin' ),
					'h2' => __( 'H2', 'quarty-plugin' ),
					'h3' => __( 'H3', 'quarty-plugin' ),
					'h4' => __( 'H4', 'quarty-plugin' ),
					'div' => __( 'DIV', 'quarty-plugin' ),
				],
			]
		);

		$this->add_control(
			'description',
			[
				'label'       => esc_html__( 'Description', 'quarty-plugin' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Enter your description', 'quarty-plugin' ),
				'default'     => esc_html__( 'Type your description here', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'layout',
			[
				'label'       => esc_html__( 'Layout', 'quarty-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => '2',
				'options' => [
					'1'  => __( '1 Columns', 'quarty-plugin' ),
					'2' => __( '2 Columns', 'quarty-plugin' ),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_styling',
			[
				'label'     => esc_html__( 'Content', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-section-title' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'     => esc_html__( 'Title Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-section-title',
			]
		);

		$this->add_control(
			'description_color',
			[
				'label'     => esc_html__( 'Description Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-section-description' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'description_typography',
				'label'     => esc_html__( 'Description Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-section-description',
			]
		);
		
		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'description', 'advanced' );

		?>

		<div class="qrt-section">	
			<div class="row">
	          <?php if ( $settings['title'] ) : ?>
	          <div class="<?php if ( $settings['layout'] == '1' ) : ?>col-lg-12<?php else : ?>col-lg-4<?php endif; ?>">
	            <<?php echo esc_attr( $settings['title_tag'] ); ?> class="qrt-section-title">
	            	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
	          			<?php echo wp_kses_post( $settings['title'] ); ?>
	         		</span>
	            </<?php echo esc_attr( $settings['title_tag'] ); ?>>
	          </div>
	          <?php endif; ?>
	          <?php if ( $settings['description'] ) : ?>
	          <div class="<?php if ( $settings['layout'] == '1' ) : ?>col-lg-12<?php else : ?>col-lg-8<?php endif; ?> qrt-section-description">
	            	<div <?php echo $this->get_render_attribute_string( 'description' ); ?>>
	          			<?php echo wp_kses_post( $settings['description'] ); ?>
	         		</div>
	          </div>
	          <?php endif; ?>
	        </div>
	    </div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>
		<#
		view.addInlineEditingAttributes( 'title', 'basic' );
		view.addInlineEditingAttributes( 'description', 'advanced' );
		#>

		<div class="qrt-section">	
			<div class="row">
	          <# if ( settings.title ) { #>
	          <div class="<# if ( settings.layout == '1' ) { #>col-lg-12<# } else { #>col-lg-4<# } #>">
	            <{{{ settings.title_tag }}} class="qrt-section-title">
	            	<span {{{ view.getRenderAttributeString( 'title' ) }}}>
	          			{{{ settings.title }}}
	         		</span>
	            </{{{ settings.title_tag }}}>
	          </div>
	          <# } #>
	          <# if ( settings.description ) { #>
	          <div class="<# if ( settings.layout == '1' ) { #>col-lg-12<# } else { #>col-lg-8<# } #> qrt-section-description">
	            	<div {{{ view.getRenderAttributeString( 'description' ) }}}>
	          			{{{ settings.description }}}
	         		</div>
	          </div>
	          <# } #>
	        </div>
	    </div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_About_Us_Widget() );