<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty CTA Widget.
 *
 * @since 1.0
 */
class Quarty_CTA_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-cta';
	}

	public function get_title() {
		return esc_html__( 'Call to Action', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'title_tab',
			[
				'label' => esc_html__( 'Title', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'quarty-plugin' ),
				'default'     => esc_html__( 'Title', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'button',
			[
				'label'       => esc_html__( 'Button (Text)', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter button text', 'quarty-plugin' ),
				'default'     => esc_html__( 'Button', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'link',
			[
				'label'       => esc_html__( 'Button (URL)', 'quarty-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_styling',
			[
				'label'     => esc_html__( 'Content', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-call-to-action h4' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .qrt-call-to-action h4',
			]
		);

		$this->add_control(
			'btn_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-call-to-action .qrt-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_bg_color',
			[
				'label'     => esc_html__( 'BG Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-call-to-action .qrt-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'btn_typography',
				'selector' => '{{WRAPPER}} .qrt-call-to-action .qrt-btn',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'button', 'none' );

		?>

		<div class="row">
          <div class="col-lg-12">
            <div class="qrt-call-to-action">
              <?php if ( $settings['title'] ) : ?>
              <h4>
              	<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
	          		<?php echo wp_kses_post( $settings['title'] ); ?>
	        	</span>
              </h4>
              <?php endif; ?>
              <?php if ( $settings['link'] ) : ?>
              <a<?php if ( $settings['link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['link']['url'] ); ?>" class="qrt-btn qrt-btn-sm qrt-btn-color qrt-cursor-scale qrt-anima-link">
              	<span <?php echo $this->get_render_attribute_string( 'button' ); ?>>
	          		<?php echo wp_kses_post( $settings['button'] ); ?>
	        	</span>
              </a>
              <?php endif; ?>
            </div>
          </div>
        </div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>
		<#
		view.addInlineEditingAttributes( 'title', 'basic' );
		view.addInlineEditingAttributes( 'button', 'none' );
		#>

		<div class="qrt-section">
			<div class="row">
	          <div class="col-lg-12">
	            <div class="qrt-call-to-action">
	              <# if ( settings.title ) { #>
	              <h4>
	              	<span {{{ view.getRenderAttributeString( 'title' ) }}}>
		          		{{{ settings.title }}}
		         	</span>
	              </h4>
	              <# } #>
	              <# if ( settings.link ) { #>
	              <a<# if ( settings.link ) { if ( settings.link.is_external ) { #> target="_blank"<# } #><# if ( settings.link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.link.url }}}"<# } #> class="qrt-btn qrt-btn-sm qrt-btn-color qrt-cursor-scale qrt-anima-link">
	              	<span {{{ view.getRenderAttributeString( 'button' ) }}}>
		          		{{{ settings.button }}}
		         	</span>
	              </a>
	              <# } #>
	            </div>
	          </div>
	        </div>
	    </div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_CTA_Widget() );