<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty Hero Banner Widget.
 *
 * @since 1.0
 */
class Quarty_Project_Image_Featured_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-project-image';
	}

	public function get_title() {
		return esc_html__( 'Project Image', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'content_tab',
			[
				'label' => esc_html__( 'Image', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image',
			[
				'label'       => esc_html__( 'Image', 'quarty-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter title', 'quarty-plugin' ),
				'default'     => esc_html__( 'Title', 'quarty-plugin' ),
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$theme_lightbox = get_field( 'portfolio_lightbox_disable', 'option' );
		
		?>

		<div class="qrt-section qrt-section-wb">

		<?php if ( $settings['image'] ) :  $image = wp_get_attachment_image_url( $settings['image']['id'], 'quarty_1920xAuto' ); ?>
		<div class="qrt-masonry-grid qrt-grid-masonry qrt-masonry-grid-single">
          <div class="qrt-grid-sizer"></div>
          <div class="qrt-masonry-grid-item qrt-masonry-grid-item-50 qrt-masonry-grid-item-100">
            <div class="qrt-work-item">
            	<a<?php if ( ! $theme_lightbox ) : ?> data-magnific-gallery<?php endif; ?> data-elementor-lightbox-slideshow="gallery" data-no-swup href="<?php echo esc_url( $image ); ?>" class="qrt-cursor-scale qrt-work-cover-frame">
            		<img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                	<div class="qrt-item-zoom qrt-cursor-color"><i class="fas fa-expand"></i></div>
              	</a>
            </div>
          </div>
        </div>
        <?php endif; ?>

    	</div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<div class="qrt-section qrt-section-wb">

		<# if ( settings.image ) { #>
		<div class="qrt-masonry-grid qrt-grid-masonry qrt-masonry-grid-single">
		  <div class="qrt-grid-sizer"></div>
          <div class="qrt-masonry-grid-item qrt-masonry-grid-item-50 qrt-masonry-grid-item-100">
            <div class="qrt-work-item">
            	<a data-magnific-gallery data-elementor-lightbox-slideshow="gallery" data-no-swup href="{{{ settings.image.url }}}" class="qrt-cursor-scale qrt-work-cover-frame">
            		<img src="{{{ settings.image.url }}}" alt="{{{ settings.title }}}">
                	<div class="qrt-item-zoom qrt-cursor-color"><i class="fas fa-expand"></i></div>
              	</a>
            </div>
          </div>
        </div>
        <# } #>

    	</div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_Project_Image_Featured_Widget() );