<?php
/**
 * Skin
**/

if ( function_exists( 'get_field' ) ) {
	/**
	 * Light Version
	 */

	$theme_ui = get_field( 'theme_ui', 'option' );

	if ( $theme_ui ) {
		function quarty_light_stylesheets() {
			wp_enqueue_style( 'quarty-light', get_template_directory_uri() . '/assets/css/light.css', '1.0' );
		}
		add_action( 'wp_enqueue_scripts', 'quarty_light_stylesheets', 10 );
	}
}

function quarty_skin() {
	$theme_ui = get_field( 'theme_ui', 'option' );
	$theme_color = get_field( 'theme_color', 'options' );
	$heading_color = get_field( 'heading_color', 'options' );
	$text_color = get_field( 'text_color', 'options' );
	$menu_font_color = get_field( 'menu_font_color', 'options' );
	
	$heading_font_family = get_field( 'heading_font_family', 'options' );
	$text_font_family = get_field( 'text_font_family', 'options' );
	$menu_font_family = get_field( 'menu_font_family', 'options' );

	$heading_font_size = get_field( 'heading_font_size', 'options' );
	$text_font_size = get_field( 'text_font_size', 'options' );
	$menu_font_size = get_field( 'menu_font_size', 'options' );

	$page_title = get_field( 'page_title' );
?>

<style>
	<?php if ( $heading_color ) : ?>
	/* Heading Color */
	h1,
	h2,
	h3,
	h4,
	h5,
	h6,
	.title--h,
	h1 a,
	h2 a,
	h3 a,
	h4 a,
	h5 a,
	h6 a,
	.title--h a,
	.content-sidebar .widget-title {
		color: <?php echo esc_attr( $heading_color ); ?>;
	}
	<?php endif; ?>

	<?php if ( $heading_font_family ) : ?>
	/* Heading Font Family */
	h1,
	h2,
	h3,
	h4,
	h5,
	h6,
	.title--h,
	h1 a,
	h2 a,
	h3 a,
	h4 a,
	h5 a,
	h6 a,
	.title--h a,
	.content-sidebar .widget-title,
	.content-sidebar h2,
	.woocommerce ul.cart_list li a, 
	.woocommerce ul.product_list_widget li a, 
	ul.cart_list li a, 
	ul.product_list_widget li a,
	.woocommerce-js ul.cart_list li a, 
	.woocommerce-js ul.product_list_widget li a {
		font-family: '<?php echo esc_attr( $heading_font_family['font_name'] ); ?>';
	}
	<?php endif; ?>

	<?php if ( $heading_font_size ) : ?>
	/* Heading Font Size */
	h4,
	.content-sidebar .widget-title {
		font-size: <?php echo esc_attr( $heading_font_size ); ?>px;
	}
	<?php endif; ?>

	<?php if ( $text_color ) : ?>
	/* Text Color */
	body,
	a,
	a:hover,
	blockquote,
	.qrt-table li span,
	.qrt-table li a,
	.single-post-text table th,
	blockquote cite,
	.wp-block-pullquote.is-style-solid-color blockquote,
	.post .single-post-text,
	.content-box,
	.post-comments,
	.qrt-section-title .qrt-el-suptitle.qrt-el-date {
		color: <?php echo esc_attr( $text_color ); ?>;
	}
	.qrt-divider {
		background: <?php echo esc_attr( $text_color ); ?>;
	}
	.qrt-section-title .qrt-el-suptitle.qrt-el-date {
		border-color: <?php echo esc_attr( $text_color ); ?>;
	}
	<?php endif; ?>

	<?php if ( $text_font_family ) : ?>
	/* Text Font Family */
	body {
		font-family: '<?php echo esc_attr( $text_font_family['font_name'] ); ?>';
	}
	<?php endif; ?>

	<?php if ( $text_font_size ) : ?>
	/* Text Font Size */
	body,
	.qrt-post-frame.qrt-sm-post .qrt-post-descr .qrt-post-title,
	table,
	.single-post-text table th,
	.single-post-text table td,
	.wp-caption,
	.wp-caption-text,
	.wp-block-image figcaption,
	.wp-block-video figcaption,
	.wp-block-embed figcaption,
	.comment-respond .title_inner small,
	a.rsswidget,
	.rss-date,
	.widget_rss cite,
	.post .single-post-text,
	.content-box,
	.post-comments,
	.has-avatars .wp-block-latest-comments__comment .wp-block-latest-comments__comment-excerpt,
	.has-avatars .wp-block-latest-comments__comment .wp-block-latest-comments__comment-meta,
	.wp-block-latest-comments__comment,
	pre.wp-block-code,
	pre {
		font-size: <?php echo esc_attr( $text_font_size ); ?>px;
	}
	<?php endif; ?>

	<?php if ( $menu_font_color ) : ?>
	/* Menu Color */
	.qrt-app .qrt-top-bar .qrt-menu,
	.qrt-app .qrt-top-bar .qrt-menu nav ul li a {
		color: <?php echo esc_attr( $menu_font_color ); ?>;
	}
	<?php endif; ?>

	<?php if ( $menu_font_family ) : ?>
	/* Menu Font Family */
	.qrt-app .qrt-top-bar .qrt-menu,
	.qrt-app .qrt-top-bar .qrt-menu nav ul li a {
		font-family: '<?php echo esc_attr( $menu_font_family['font_name'] ); ?>';
	}
	<?php endif; ?>

	<?php if ( $menu_font_size ) : ?>
	/* Menu Font Size */
	.qrt-app .qrt-top-bar .qrt-menu,
	.qrt-app .qrt-top-bar .qrt-menu nav ul li a {
		font-size: <?php echo esc_attr( $menu_font_size ); ?>px;
	}
	<?php endif; ?>

	<?php if ( $theme_color ) : ?>
	/* Theme Color */
	.qrt-divider-2,
	.qrt-btn.qrt-btn-color,
	.qrt-app .qrt-top-bar .qrt-symbol,
	.qrt-app .qrt-top-bar .qrt-menu nav ul li:after,
	.qrt-app .qrt-top-bar .qrt-menu nav ul li ul,
	.qrt-scroll-hint span:after,
	.qrt-slider-pagination .swiper-main-pagination .swiper-pagination-progressbar-fill,
	.qrt-team-member .qrt-team-member-description .qrt-member-more,
	.qrt-price.qrt-popular-price:before,
	.qrt-contact-form .qrt-input.qrt-active+label,
	.qrt-contact-form .qrt-input:focus+label,
	.qrt-post-frame.qrt-popular:before,
	.qrt-post-frame.qrt-lg-post .qrt-post-descr .qrt-work-more,
	.qrt-blog-pagination span.current,
	.page-links span.current,
	.qrt-blog-pagination a:hover,
	.page-links a:hover,
	.qrt-work-item .qrt-work-descr .qrt-work-more,
	.qrt-filter .qrt-work-category.qrt-filter-icon i,
	.qrt-map-frame .qrt-lock.qrt-active,
	.content-sidebar td#today,
	.single-post-text table td#today,
	.comment-form .btn.fill,
	form.post-password-form input[type="submit"],
	.content-sidebar .widget-title:before,
	.sticky:before,
	.wp-block-button a.wp-block-button__link,
	.qrt-map-frame .qrt-lock.qrt-active, 
	.mapboxgl-marker svg g,
	.qrt-buttons .cart-btn .cart-icon .cart-count,
	.woocommerce #respond input#submit, 
	.woocommerce a.button, 
	.woocommerce button.button, 
	.woocommerce input.button,
	.woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-mini-cart__buttons a.button, 
	.woocommerce-mini-cart__buttons button.button, 
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce-js #respond input#submit, 
	.woocommerce-js a.button, 
	.woocommerce-js button.button, 
	.woocommerce-js input.button,
	.woocommerce-js .woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-js .woocommerce-mini-cart__buttons a.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons button.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons input.button,
	.woocommerce .products div.product .button.add_to_cart_button:after,
	.woocommerce-js .products div.product .button.add_to_cart_button:after,
	.woocommerce nav.woocommerce-pagination ul li a:focus, 
	.woocommerce nav.woocommerce-pagination ul li a:hover, 
	.woocommerce nav.woocommerce-pagination ul li span.current,
	.woocommerce-js nav.woocommerce-pagination ul li a:focus, 
	.woocommerce-js nav.woocommerce-pagination ul li a:hover, 
	.woocommerce-js nav.woocommerce-pagination ul li span.current,
	.woocommerce nav.woocommerce-pagination ul li span.current,
	.woocommerce-js nav.woocommerce-pagination ul li span.current,
	.woocommerce div.product .button.single_add_to_cart_button,
	.woocommerce-js div.product .button.single_add_to_cart_button,
	.woocommerce div.product .button.single_add_to_cart_button:after,
	.woocommerce-js div.product .button.single_add_to_cart_button:after,
	.woocommerce #review_form #respond .form-submit .submit,
	.woocommerce-js #review_form #respond .form-submit .submit,
	.woocommerce #respond input#submit:after, 
	.woocommerce a.button:after, 
	.woocommerce button.button:after, 
	.woocommerce input.button:after,
	.woocommerce-js #respond input#submit:after, 
	.woocommerce-js a.button:after, 
	.woocommerce-js button.button:after, 
	.woocommerce-js input.button:after,
	.woocommerce .products .product .button.add_to_cart_button.added,
	.woocommerce-js .products .product .button.add_to_cart_button.added,
	.woocommerce .products .product .button.add_to_cart_button.added,
	.woocommerce-js .products .product .button.add_to_cart_button.added,
	.woocommerce #review_form #respond .form-submit .submit:hover, 
	.woocommerce-js #review_form #respond .form-submit .submit:hover {
		background-color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.qrt-portfolio-pagination span, 
	.qrt-portfolio-pagination a:after,
	blockquote:before,
	.qrt-link.qrt-color-link,
	.qrt-link.qrt-color-link:hover,
	.qrt-app .qrt-left-bar .qrt-social-links .qrt-social-link:hover,
	.qrt-price .qrt-price-body .qrt-price-list ul li:before,
	.qrt-price .qrt-price-body .qrt-price-list ul li del:before,
	.qrt-testimonial .qrt-stars li i,
	.single-post-text p a,
	.comment-text p a,
	.content-sidebar a:hover,
	.error-page__num,
	.post-text-bottom .byline a,
	.woocommerce #respond input#submit, 
	.woocommerce a.button, 
	.woocommerce button.button, 
	.woocommerce input.button,
	.woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-mini-cart__buttons a.button, 
	.woocommerce-mini-cart__buttons button.button, 
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce-js #respond input#submit, 
	.woocommerce-js a.button, 
	.woocommerce-js button.button, 
	.woocommerce-js input.button,
	.woocommerce-js .woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-js .woocommerce-mini-cart__buttons a.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons button.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons input.button,
	.woocommerce .products div.product .button.add_to_cart_button,
	.woocommerce-js .products div.product .button.add_to_cart_button,
	.woocommerce .star-rating span:before,
	.woocommerce-js .star-rating span:before,
	.woocommerce div.product .button.single_add_to_cart_button,
	.woocommerce-js div.product .button.single_add_to_cart_button,
	.woocommerce .cart .button[name="update_cart"],
	.woocommerce-js .cart .button[name="update_cart"],
	#add_payment_method .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-cart .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,
	.woocommerce #respond input#submit.alt, 
	.woocommerce a.button.alt, 
	.woocommerce button.button.alt, 
	.woocommerce input.button.alt,
	.woocommerce-js #respond input#submit.alt, 
	.woocommerce-js a.button.alt, 
	.woocommerce-js button.button.alt, 
	.woocommerce-js input.button.alt,
	.product-categories .current-cat, 
	.product-categories .current-cat a,
	.woocommerce ul.product_list_widget li a.remove:hover, 
	ul.product_list_widget li a.remove:hover,
	.woocommerce-js ul.product_list_widget li a.remove:hover {
		color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.qrt-scroll-hint span,
	.qrt-hint-frame .qrt-scroll-hint span,
	.qrt-timeline .qrt-timeline-item .qrt-timeline-mark,
	.qrt-form-field textarea.qrt-active,
	.qrt-form-field textarea:focus,
	.wp-block-button.is-style-outline a.wp-block-button__link,
	.woocommerce .products div.product .button.add_to_cart_button,
	.woocommerce-js .products div.product .button.add_to_cart_button,
	.woocommerce #review_form #respond .form-submit .submit,
	.woocommerce-js #review_form #respond .form-submit .submit,
	#add_payment_method .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-cart .wc-proceed-to-checkout a.checkout-button, 
	.woocommerce-checkout .wc-proceed-to-checkout a.checkout-button,
	.woocommerce div.product .button.single_add_to_cart_button, 
	.woocommerce-js div.product .button.single_add_to_cart_button,
	.woocommerce #respond input#submit, 
	.woocommerce a.button, 
	.woocommerce button.button, 
	.woocommerce input.button,
	.woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-mini-cart__buttons a.button, 
	.woocommerce-mini-cart__buttons button.button, 
	.woocommerce-mini-cart__buttons input.button,
	.woocommerce-js #respond input#submit, 
	.woocommerce-js a.button, 
	.woocommerce-js button.button, 
	.woocommerce-js input.button,
	.woocommerce-js .woocommerce-mini-cart__buttons #respond input#submit, 
	.woocommerce-js .woocommerce-mini-cart__buttons a.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons button.button, 
	.woocommerce-js .woocommerce-mini-cart__buttons input.button {
		border-color: <?php echo esc_attr( $theme_color ); ?>;
	}
	.qrt-app .qrt-preloader .qrt-preloader-content .qrt-preloader-load svg path:last-child {
		stroke: <?php echo esc_attr( $theme_color ); ?>;
	}
	@media (max-width: 768px) {
		.qrt-app .qrt-top-bar .qrt-menu nav > ul > li.current-menu-item a {
			color: <?php echo esc_attr( $theme_color ); ?>;
		}
	}
	<?php endif; ?>

	<?php if ( $page_title ) : ?>
	.mapboxgl-marker:after {
		content: '<?php echo esc_attr( $page_title ); ?>';
	}
	<?php endif; ?>
</style>

<?php
}
add_action( 'wp_head', 'quarty_skin', 10 );