<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package quarty
 */

get_header();
?>
	
	<?php while ( have_posts() ) : the_post(); ?>
	<div class="qrt-left-content">

	<?php $layout = get_field( 'blog_layout', 'option' ); ?>

	<!-- section title -->
	<div class="qrt-section-title<?php if ( $layout != 1 ) : ?> archive-row-title<?php endif; ?>">
		<!-- row -->
		<div class="row">
			<!-- col -->
	  		<div class="col-lg-12">
				<h1 class="title--h2"><?php the_title(); ?></h1>
	  		</div>
	  		<!-- col end -->
	  	</div>
	  	<!-- row end -->
	</div>
	<!-- section title end -->
	
	<!-- row -->
	<div class="row">
	  <!-- col -->
	  <div class="col-lg-12">
	  	<?php get_template_part( 'template-parts/content', 'page' ); ?>
	  </div>
	  <!-- col end -->
	</div>
    <!-- row end -->

    <?php if ( comments_open() || get_comments_number() ) : ?>
	<!-- row -->
	<div class="row">
	  <!-- col -->
	  <div class="col-lg-12">
	    <?php
		// If comments are open or we have at least one comment, load up the comment template.
		comments_template();
	    ?>
	  </div>
	  <!-- col end -->
	</div>
    <!-- row end -->
    <?php endif; ?>
	
	</div>
	<?php endwhile; ?>

<?php
get_footer();
