<?php

/*
Quarty Shop */

?>

<?php get_header(); ?>

<?php

$sidebar_shop = get_field( 'wooshop_sidebar', 'option' );

if ( ! $sidebar_shop ) {
	$sidebar_shop = 'hide';
}

$parallax_shop = get_field( 'wooshop_parallax', 'option' );

?>

<?php if ( true == $parallax_shop ) : ?>

<?php
	$parallax_shop_img = get_field( 'wooshop_parallax_img', 'option' );
	$parallax_shop_title = get_field( 'wooshop_parallax_title', 'option' );
?>

<div class="qrt-body">
<div class="qrt-banner qrt-animated-zoom">
	<?php if ( $parallax_shop_img ) : $image = wp_get_attachment_image_url( $parallax_shop_img, 'quarty_1920xAuto' ); ?>
	<div class="qrt-image-frame">
    	<img src="<?php echo esc_url( $image ); ?>" alt="">
  	</div>
  	<?php endif; ?>
  	<?php if ( $parallax_shop_title ) : ?>
  	<div class="qrt-overlay">
    	<div class="qrt-banner-title">
      		<h1 class="title--h1 qrt-white qrt-mb-30">
      			<?php echo wp_kses_post( $parallax_shop_title ); ?>
      		</h1>
      		<div class="qrt-divider-2"></div>
    	</div>
  	</div>
  	<?php endif; ?>
</div>
</div>

<?php endif; ?>

<div class="qrt-left-content shop-page<?php if ( ! $parallax_shop ) : ?> header-page<?php endif; ?>" id="card-shop-page">
	<div class="row">
  	<?php if ( 'left' == $sidebar_shop && ! is_product() ) : ?>
  		<div class="col-lg-3">
			<?php if ( is_active_sidebar( 'shop-sidebar' ) ) : ?>
			<div id="sidebar" class="widget-area content-sidebar col__sedebar" role="complementary">
		        <?php dynamic_sidebar( 'shop-sidebar' ); ?>
		    </div>
		    <?php endif; ?>
		</div>
		<div class="col-lg-9">
			<?php woocommerce_breadcrumb(); ?>
			<?php woocommerce_content(); ?>
		</div>
	<?php elseif ( 'right' == $sidebar_shop && ! is_product() ) : ?>
		<div class="col-lg-9">
			<?php woocommerce_breadcrumb(); ?>
			<?php woocommerce_content(); ?>
		</div>
		<div class="col-lg-3">
			<?php if ( is_active_sidebar( 'shop-sidebar' ) ) : ?>
			<div id="sidebar" class="widget-area content-sidebar col__sedebar" role="complementary">
	        	<?php dynamic_sidebar( 'shop-sidebar' ); ?>
	        </div>
	    	<?php endif; ?>
		</div>
	<?php else : ?>
		<div class="col-lg-12">
			<?php woocommerce_breadcrumb(); ?>
			<?php woocommerce_content(); ?>
		</div>
	<?php endif; ?>
	</div>
</div>

<?php get_footer(); ?>