<?php

//  Custom Post Type for flab
function flab_post_types() {
    register_post_type( 'project',
        array(
            'rewrite' => array('slug' => 'projects'),
            'has_archive' => false,
            'public' => true,
            'labels' => array(
                'name' => 'Projects',
                'singular_name' => 'Project',
                'add_new_item' => 'Add New Project',
                'edit_item' => 'Edit Project',
                'all_items' => 'All Projects',
                'view_item' => 'View Project'
            ),
            'menu_icon' => 'dashicons-text-page',
            'supports' => array( 'thumbnail', 'title', 'editor', 'page-attributes', 'post-formats', 'categories' ),
            'taxonomies' => array('custom_tag', 'custom_category')
        )
    );

	register_taxonomy(
	    'Project Category',
	    'project',
	    array(
	        "hierarchical" => true,
	        "label" => "Categories",
	        "singular_label" => "Category",
	        'update_count_callback' => '_update_post_term_count',
	        'query_var' => true,
	        'rewrite'           => array( 'slug' => 'project-category' ),
	        'public' => true,
	        'show_ui' => true,
	        'show_tagcloud' => true,
	        '_builtin' => false,
	        'show_in_nav_menus' => false,
	    )
	);
}
add_action( 'init', 'flab_post_types' );

function flab_create_project_taxonomies() {
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => _x( 'Tags', 'taxonomy general name', 'flab' ),
        'singular_name'     => _x( 'Tag', 'taxonomy singular name', 'flab' ),
        'search_items'      => __( 'Search Tags', 'flab' ),
        'all_items'         => __( 'All Tags', 'flab' ),
        'parent_item'       => __( 'Parent Tag', 'flab' ),
        'parent_item_colon' => __( 'Parent Tag:', 'flab' ),
        'edit_item'         => __( 'Edit Tag', 'flab' ),
        'update_item'       => __( 'Update Tag', 'flab' ),
        'add_new_item'      => __( 'Add New Tag', 'flab' ),
        'new_item_name'     => __( 'New Tag Name', 'flab' ),
        'menu_name'         => __( 'Tags', 'flab' ),
    );
 
    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'tag' ),
    );
 
    register_taxonomy( 'tag', array( 'project' ), $args );
}
// hook into the init action and call create_book_taxonomies when it fires
add_action( 'init', 'flab_create_project_taxonomies', 0 );
