(function($){
	"use strict";
	$(document).ready(function($) {

		/* global Modernizr, PathLoader, classie, google: false */
		/*jshint -W018 */

		/*-------------------------------------------------*/
		/* =  portfolio isotope
		/*-------------------------------------------------*/

		var winDow = $(window);
		// Needed variables
		var $container=$('.iso-call');
		var $filter=$('.filter');

		winDow.trigger('resize');
		$container.isotope({
			filter:'*',
			layoutMode:'masonry',
			animationOptions:{
				duration:750,
				easing:'linear'
			}
		});

		winDow.on('resize', function(){
			var selector = $filter.find('a.active').attr('data-filter');

			$container.isotope({ 
				filter	: selector,
				animationOptions: {
					duration: 750,
					easing	: 'linear',
					queue	: false,
				}
			});
		});
		
		// Isotope Filter 
		$filter.find('a').on('click', function(){
			var selector = $(this).attr('data-filter');

			$container.isotope({ 
				filter	: selector,
				animationOptions: {
					duration: 750,
					easing	: 'linear',
					queue	: false,
				}
			});
		});


		var filterItemA	= $('.filter li a');

			filterItemA.on('click', function(){
				var $this = $(this);
				if ( !$this.hasClass('active')) {
					filterItemA.removeClass('active');
					$this.addClass('active');
				}
			});

		function Resize(){
			winDow.trigger('resize');
			Start();
		}

		function Start(){
			setTimeout(Resize, 500);
		}

		Start();
		
		/* ---------------------------------------------------------------------- */
		/*	menu toggle, sub-menu toggle
		/* ---------------------------------------------------------------------- */

		var menuToggle = $('a.open-menu-toggle'),
			logoToggle = $('div.logo'),
			menuList = $('nav.nav-menu-box'),
			socialLine = $('.social-line');

		menuToggle.on('click', function(event){
			event.preventDefault();
			$(this).toggleClass('active');
			logoToggle.toggleClass('active');
			menuList.toggleClass('active');
			socialLine.toggleClass('active');
		});

		$('.menu-item-has-children > a').on('click', function(event) {
			event.preventDefault();
			var $this = $(this);

			if( !$this.hasClass('opened') ) {

				// $('.menu-item-has-children a.opened').next('ul.sub-menu').slideUp();
				// $('.menu-item-has-children a.opened').removeClass('opened');

				$this.next('ul.sub-menu').slideDown();
				$this.addClass('opened');

			} else {

				$this.next('ul.sub-menu').slideUp();
				$this.removeClass('opened');

			}

		});

		/* ---------------------------------------------------------------------- */
		/*	magnific-popup
		/* ---------------------------------------------------------------------- */

		// Example with multiple objects
		$('.zoom').magnificPopup({
			type: 'image',
			gallery: {
				enabled: true
			}
		});

		/*-------------------------------------------------*/
		/* =  OWL carousell
		/*-------------------------------------------------*/

		var owlWrap = $('.owl-wrapper, .owl-scroller');

		if (owlWrap.length > 0) {

			if (jQuery().owlCarousel) {
				owlWrap.each(function(){

					var carousel= $(this).find('.owl-carousel'),
						dataNum = $(this).find('.owl-carousel').attr('data-num'),
						dataNum2,
						dataNum3;

					if ( dataNum == 1 ) {
						dataNum2 = 1;
						dataNum3 = 1;
					} else if ( dataNum == 2 ) {
						dataNum2 = 1;
						dataNum3 = dataNum - 1;
					} else if (dataNum > 3) {
						dataNum2 = dataNum - 2;
						dataNum3 = dataNum - 3;
					} else {
						dataNum2 = dataNum - 1;
						dataNum3 = dataNum - 2;
					}

					carousel.owlCarousel({
						autoPlay: 10000,
						navigation : true,
						loop: true,
						nav: true,
						responsive:{
					        0:{
					            items:dataNum3
					        },
					        768:{
					            items:dataNum2
					        },            
					        960:{
					            items:dataNum2
					        },
					        1200:{
					            items:dataNum
					        }
					    }
					});

				});
			}
	    }
	    $('.owl-scroller .owl-carousel').on('mousewheel', '.owl-stage', function (e) {
			if (e.deltaY>1) {
				$('.owl-scroller .owl-carousel').trigger('prev.owl');
			} else {
				$('.owl-scroller .owl-carousel').trigger('next.owl');
			}
			e.preventDefault();
		});
		
		/* ---------------------------------------------------------------------- */
		/*	works carousel
		/* ---------------------------------------------------------------------- */

		$(window).on('load', function() {
			var winDowHeight = $(window).outerHeight();
			$('.photo-box .photo-post').height(winDowHeight - 100);
		});
		$(window).on('resize', function() {
			var winDowHeight = $(window).outerHeight();
			$('.photo-box .photo-post').height(winDowHeight - 100);
		});
		

		/*-------------------------------------------------*/
		/* =  filter events
		/*-------------------------------------------------*/

		$('ul.filter-block li a').on('click', function(event){
			event.preventDefault();
			let $this = $(this);
			if( !$this.parent('li').hasClass('active') ) {
				$('ul.filter-block li').removeClass('active');
				$this.parent('li').addClass('active');

				let $categoryNameSelected = $this.attr('data-cat').toLowerCase();

				$('#categoryfilter option').val($categoryNameSelected);
				$('#filter').trigger('submit');

				console.log($categoryNameSelected);
			};
		});

		$('#filter').submit(function(){
			var filter = $('#filter');
			$.ajax({
				url:filter.attr('action'),
				data:filter.serialize(), // form data
				type:filter.attr('method'), // POST
				beforeSend:function(xhr){
					$('.upp-overlay').fadeIn(200);
				},
				success:function(data){
					$('.upp-overlay').fadeOut(200);
					$('#response').html(data); // insert data
				}
			});
			return false;
		});


		/* ---------------------------------------------------------------------- */
		/*	Header animate after scroll
		/* ---------------------------------------------------------------------- */
		
		var docElem = document.documentElement,
			didScroll = false,
			changeHeaderOn = 120;
		window.addEventListener( 'scroll', function() {
			if( !didScroll ) {
				didScroll = true;
				scrollPage();
			}
		}, false );
		
		function scrollPage() {
			var sy = scrollY();
			if ( sy >= changeHeaderOn ) {
				$( 'header' ).addClass('active');
			}
			else {
				$( 'header' ).removeClass('active');
			}
			didScroll = false;
		}
		
		function scrollY() {
			return window.pageYOffset || docElem.scrollTop;
		}

		
		/* ---------------------------------------------------------------------- */
		/*	preloader
		/* ---------------------------------------------------------------------- */

		var support = { animations : Modernizr.cssanimations },
			container = document.getElementById( 'ip-container' ),
			header = container.querySelector( 'div.ip-header' ),
			loader = new PathLoader( document.getElementById( 'ip-loader-circle' ) ),
			animEndEventNames = { 'WebkitAnimation' : 'webkitAnimationEnd', 'OAnimation' : 'oAnimationEnd', 'msAnimation' : 'MSAnimationEnd', 'animation' : 'animationend' },
			// animation end event name
			animEndEventName = animEndEventNames[ Modernizr.prefixed( 'animation' ) ];

		function init() {
			var onEndInitialAnimation = function() {
				if( support.animations ) {
					this.removeEventListener( animEndEventName, onEndInitialAnimation );
				}

				startLoading();
			};

			// disable scrolling
			window.addEventListener( 'scroll', noscroll );

			// initial animation
			classie.add( container, 'loading' );

			if( support.animations ) {
				container.addEventListener( animEndEventName, onEndInitialAnimation );
			}
			else {
				onEndInitialAnimation();
			}
		}

		function startLoading() {
			// simulate loading something..
			var simulationFn = function(instance) {
				var progress = 0,
					interval = setInterval( function() {
						progress = Math.min( progress + Math.random() * 0.1, 1 );

						instance.setProgress( progress );

						// reached the end
						if( progress === 1 ) {
							classie.remove( container, 'loading' );
							classie.add( container, 'loaded' );
							clearInterval( interval );

							var onEndHeaderAnimation = function(ev) {
								if( support.animations ) {
									if( ev.target !== header ) return;
									this.removeEventListener( animEndEventName, onEndHeaderAnimation );
								}

								classie.add( document.body, 'layout-switch' );
								window.removeEventListener( 'scroll', noscroll );
							};

							if( support.animations ) {
								header.addEventListener( animEndEventName, onEndHeaderAnimation );
							}
							else {
								onEndHeaderAnimation();
							}
						}
					}, 80 );
			};

			loader.setProgressFn( simulationFn );
		}
		
		function noscroll() {
			window.scrollTo( 0, 0 );
		}

		init();


	});

})(jQuery);