<?php
/**
 * An example file demonstrating how to add all controls.
 *
 * @package     Kirki
 * @category    Core
 * @author      Aristeides Stathopoulos
 * @copyright   Copyright (c) 2017, Aristeides Stathopoulos
 * @license     http://opensource.org/licenses/https://opensource.org/licenses/MIT
 * @since       3.0.12
 */
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// Do not proceed if Kirki does not exist.
if ( ! class_exists( 'Kirki' ) ) {
	return;
}
/**
 * First of all, add the config.
 *
 * @link https://aristath.github.io/kirki/docs/getting-started/config.html
 */
Kirki::add_config(
	'kirki_demo', array(
		'capability'  => 'edit_theme_options',
		'option_type' => 'theme_mod',
	)
);
/**
 * Add a panel.
 *
 * @link https://aristath.github.io/kirki/docs/getting-started/panels.html
 */
Kirki::add_panel(
	'royarch_options_panel', array(
		'priority'    => 10,
		'title'       => esc_attr__( 'Royarch Options Panel', 'royarch' ),
		'description' => esc_attr__( 'Config Your Theme Options Here.', 'royarch' ),
	)
);
/**
 * Add Sections.
 *
 * We'll be doing things a bit differently here, just to demonstrate an example.
 * We're going to define 1 section per control-type just to keep things clean and separate.
 *
 * @link https://aristath.github.io/kirki/docs/getting-started/sections.html
 */
$sections = array(
	'body'      => array( esc_attr__( 'Main Body Style', 'royarch' ), '' ),
	'colors'	=> array( esc_attr__('Theme Colors', 'royarch'), ''),
	'fonts'	=> array( esc_attr__('Theme Fonts', 'royarch'), ''),
	'page_banner'      => array( esc_attr__( 'Page Banner Style', 'royarch' ), '' ),
	'social'	=> array( esc_attr__('Social Network Links', 'royarch'), ''),
	'footer'	=> array( esc_attr__('Footer Options', 'royarch'), ''),
	'header'	=> array( esc_attr__('Header Options', 'royarch'), ''),
);
foreach ( $sections as $section_id => $section ) {
	$section_args = array(
		'title'       => $section[0],
		'description' => $section[1],
		'panel'       => 'royarch_options_panel',
	);
	if ( isset( $section[2] ) ) {
		$section_args['type'] = $section[2];
	}
	Kirki::add_section( str_replace( '-', '_', $section_id ) . '_section', $section_args );
}
/**
 * A proxy function. Automatically passes-on the config-id.
 *
 * @param array $args The field arguments.
 */
function my_config_kirki_add_field( $args ) {
	Kirki::add_field( 'kirki_demo', $args );
}


// logo max-width
my_config_kirki_add_field(
	array(
		'type'        => 'dimensions',
		'settings'    => 'logo_dimensions',
		'label'       => esc_attr__( 'Logo Dimension Control', 'royarch' ),
		'section'     => 'body_section',
		'default'     => [
			'max-width'  => '180px',
		],
		'choices'     => [
			'labels' => [
				
				'max-width'  => esc_html__( 'Max Width', 'royarch' ),
			],
		],
	)
);

my_config_kirki_add_field(
	array(
		'type'        => 'color',
		'settings'    => 'main_color',
		'label'       => esc_attr__( 'Primary Color 1', 'royarch' ),
		'description' => esc_attr__( 'your Main Color Style 1.', 'royarch' ),
		'section'     => 'colors_section',
		'default'     => '#d92828',
		
	)
);


my_config_kirki_add_field(
	array(
		'type'        => 'typography',
		'settings'    => 'title_typo',
		'label'       => esc_attr__( 'Titles Font Family', 'royarch' ),
		'section'     => 'fonts_section',
		'default'     => array(
			'font-family'    => 'Montserrat',
		),
		'priority'    => 10,
		'output'      => array(
			array(
				'element' => 'h1, h2, h3, h4, h5, h6, body, p, .paragraph',
			),
		),
	)
);

my_config_kirki_add_field(
	array(
		'type'        => 'typography',
		'settings'    => 'quote_typo',
		'label'       => esc_attr__( 'Blockquote Font Family', 'royarch' ),
		'section'     => 'fonts_section',
		'default'     => array(
			'font-family'    => 'Rubik',
		),
		'priority'    => 10,
		'output'      => array(
			array(
				'element' => 'blockquote, blockquote p',
			),
		),
	)
);

/**social switcher**/

my_config_kirki_add_field(
	array(
		'type'        => 'switch',
		'settings'    => 'switch_socials',
		'label'       => esc_html__( 'Enable/Disable Social Icons', 'royarch' ),
		'section'     => 'social_section',
		'default'     => 'off',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'royarch' ),
			'off' => esc_html__( 'Disable', 'royarch' ),
		],
	)
);

/**facebook line**/

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'facebook',
		'label'       => esc_attr__( 'Facebook Url', 'royarch' ),
		'section'     => 'social_section',
	)
);

/**twitter line**/

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'twitter',
		'label'       => esc_attr__( 'Twitter Url', 'royarch' ),
		'section'     => 'social_section',
	)
);

/**linkedin line**/

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'linkedin',
		'label'       => esc_attr__( 'Linkedin Url', 'royarch' ),
		'section'     => 'social_section',
	)
);

/**instagram line**/

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'instagram',
		'label'       => esc_attr__( 'Instagram Url', 'royarch' ),
		'section'     => 'social_section',
	)
);

/**google line**/

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'google',
		'label'       => esc_attr__( 'Google Url', 'royarch' ),
		'section'     => 'social_section',
	)
);

/**youtube line**/

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'youtube',
		'label'       => esc_attr__( 'Youtube Url', 'royarch' ),
		'section'     => 'social_section',
	)
);

/**pinterest line**/

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'pinterest',
		'label'       => esc_attr__( 'Pinterest Url', 'royarch' ),
		'section'     => 'social_section',
	)
);

/**dribble line**/

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'dribble',
		'label'       => esc_attr__( 'Dribble Url', 'royarch' ),
		'section'     => 'social_section',
	)
);

/**github line**/

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'github',
		'label'       => esc_attr__( 'Github Url', 'royarch' ),
		'section'     => 'social_section',
	)
);



my_config_kirki_add_field(
	array(
		'type'        => 'switch',
		'settings'    => 'switch_instagram',
		'label'       => esc_html__( 'Instagram Widget', 'royarch' ),
		'section'     => 'footer_section',
		'default'     => 'Off',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'royarch' ),
			'off' => esc_html__( 'Disable', 'royarch' ),
		],
	)
);

/**social switcher**/

my_config_kirki_add_field(
	array(
		'type'        => 'switch',
		'settings'    => 'switch_info',
		'label'       => esc_html__( 'Enable/Disable Contact Info', 'royarch' ),
		'section'     => 'header_section',
		'default'     => 'off',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'royarch' ),
			'off' => esc_html__( 'Disable', 'royarch' ),
		],
	)
);

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'phone_number',
		'label'       => esc_html__( 'Enter phone number', 'royarch' ),
		'section'     => 'header_section',
		'default'     => esc_html__( '+1 234 5678 90 00', 'royarch' ),
	)
);


my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'email',
		'label'       => esc_html__( 'Enter Email address', 'royarch' ),
		'section'     => 'header_section',
		'default'     => esc_html__( 'royarch@domain.com', 'royarch' ),
	)
);


my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'copyright',
		'label'       => esc_html__( 'Copyright Line Text', 'royarch' ),
		'section'     => 'header_section',
		'default'     => esc_html__( '© 2020 Royarch', 'royarch' ),
	)
);


/**page banner image**/

my_config_kirki_add_field(
	array(
		'type'        => 'image',
		'settings'    => 'image_setting_url',
		'label'       => esc_html__( 'Background Image', 'royarch' ),
		'description' => esc_html__( 'Page Banner Background Image.', 'royarch' ),
		'section'     => 'page_banner_section',
		'default'     => '',
	)
);

/**page banner description **/

my_config_kirki_add_field(
	array(
		'type'        => 'text',
		'settings'    => 'archive_description',
		'label'       => esc_html__( 'Archive description text', 'royarch' ),
		'section'     => 'page_banner_section',
		'default'     => '',
	)
);
