<?php
/**
 * Implements the compatibility for the Elementor plugin in royarch  theme.
 *
 * @package    Royarch - Unikwp
 * @subpackage Royarch 
 * @since      Royarch 1.0
 */


if ( ! function_exists( 'royarch_elementor_active_page_check' ) ) :

	/**
	 * Check whether Elementor plugin is activated and is active on current page or not
	 *
	 * @return bool
	 *
	 * @since royarch 1.0
	 */
	function royarch_Elementor_active_page_check() {
		global $post;

		if ( defined( 'ELEMENTOR_VERSION' ) && get_post_meta( $post->ID, '_elementor_edit_mode', true ) ) {
			return true;
		}

		return false;
	}

endif;

if ( ! function_exists( 'royarch_elementor_widget_render_filter' ) ) :

	/**
	 * Render the default WordPress widget settings, ie, divs
	 *
	 * @param $args the widget id
	 *
	 * @return array register sidebar divs
	 *
	 * @since royarch 1.0
	 */
	function royarch_Elementor_widget_render_filter( $args ) {

		return
			array(
				'before_widget' => '<section class="widget ' . royarch_widget_class_names( $args[ 'widget_id' ] ) . ' clearfix">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="heading2 widget-title">',
				'after_title'   => '</h2>',
			);
	}

endif;

add_filter( 'elementor/widgets/wordpress/widget_args', 'royarch_elementor_widget_render_filter' ); // WPCS: spelling ok.

if ( ! function_exists( 'royarch_widget_class_names' ) ) :

	/**
	 * Render the widget classes for Elementor plugin compatibility
	 *
	 * @param $widgets_id the widgets of the id
	 *
	 * @return mixed the widget classes of the id passed
	 *
	 * @since royarch Custom1.0
	 */
	function royarch_widget_class_names( $widgets_id ) {

		$widgets_id = str_replace( 'wp-widget-', '', $widgets_id );

		$classes = royarch_widgets_classes();

		$return_value = isset( $classes[ $widgets_id ] ) ? $classes[ $widgets_id ] : 'widget_featured_block';

		return $return_value;
	}

endif;


/**
 * Load the royarch Custom Elementor widgets file and registers it
 */
if ( ! function_exists( 'royarch_elementor_widgets_registered' ) ) :

	/**
	 * Load and register the required Elementor widgets file
	 *
	 * @param $widgets_manager
	 *
	 * @since royarch Custom 1.0
	 */
	function royarch_elementor_widgets_registered( $widgets_manager ) {

		// Require the files
		// 1. Block Widgets
		
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/col-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/list-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/single-project.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/single-project2.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/single-project3.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/magic-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/carousel-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/carousel-block2.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/carousel-block3.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/carousel-block4.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/unique-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/home8-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/contact-form-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/about-block1.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/services-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/services-block2.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/services-block3.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/services-block4.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/services-block5.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/services-block6.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/services-block7.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/services-block8.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/services-block9.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/feature-carousel-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/features-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/features-block2.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/team-block.php';
		require ROYARCH_ELEMENTOR_WIDGETS_DIR . '/tab-carousel.php';

		

		// Register the widgets
		// 1. Block Widgets
		
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Col_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_List_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Single_Project() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Single_Project2() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Single_Project3() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Magic_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Carousel_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Carousel_Block2() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Carousel_Block3() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Carousel_Block4() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Unique_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Home8_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Contact_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_About_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Services_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Services_Block2() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Services_Block3() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Services_Block4() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Services_Block5() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Services_Block6() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Services_Block7() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Services_Block8() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Services_Block9() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Feature_Carousel_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Features_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Features_Block2() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Team_Block() );
		$widgets_manager->register_widget_type( new \Elementor\Royarch_Elementor_Global_Widgets_Tab_Block() );
		
		
	}

endif;

add_action( 'elementor/widgets/widgets_registered', 'royarch_elementor_widgets_registered' );

if ( ! function_exists( 'royarch_elementor_category' ) ) :

	/**
	 * Add the Elementor category for use in royarch Custom widgets as seperator
	 *
	 * @since royarch Custom 1.0
	 */
	function royarch_Elementor_category() {

		// Register widget block category for Elementor section
		\Elementor\Plugin::instance()->elements_manager->add_category( 'royarch-widget-blocks', array(
			'title' => esc_html__( 'Royarch Custom Widget Blocks', 'royarch' ),
		), 1 );

		// Register widget grid category for Elementor section
		\Elementor\Plugin::instance()->elements_manager->add_category( 'royarch-widget-grid', array(
			'title' => esc_html__( 'Royarch Custom Widget Grid', 'royarch' ),
		), 1 );

		// Register widget global category for Elementor section
		\Elementor\Plugin::instance()->elements_manager->add_category( 'royarch-widget-global', array(
			'title' => esc_html__( 'Royarch Custom Global Widgets', 'royarch' ),
		), 1 );
	}

endif;

add_action( 'elementor/init', 'royarch_elementor_category' );
