<?php
/**
 * Royarch Elementor Global Widget About_Block.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_About_Block extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_About_Block widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-About-Block';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_About_Block widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Block 1', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_About_Block widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-monument';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_About_Block widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_About_Block widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_About_Block_title_manage',
			array(
				'label' => esc_html__( 'About Block', 'royarch' ),
			)
		);

		$this->add_control(
			'widget_title',
			array(
				'label'       => esc_html__( 'Title:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your title', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_desc',
			array(
				'label'       => esc_html__( 'Description:', 'royarch' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Add your description', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_image',
			array(
				'label'       => esc_html__( 'First Column Image 1', 'royarch' ),
				'type'        => Controls_Manager::MEDIA,
				'placeholder' => esc_html__( 'Add your Image', 'royarch' )
			)
		);

		$this->add_control(
			'widget_image2',
			array(
				'label'       => esc_html__( 'First Column Image 2', 'royarch' ),
				'type'        => Controls_Manager::MEDIA,
				'placeholder' => esc_html__( 'Add your Image', 'royarch' )
			)
		);

		$this->add_control(
			'widget_image3',
			array(
				'label'       => esc_html__( 'Second Column Image', 'royarch' ),
				'type'        => Controls_Manager::MEDIA,
				'placeholder' => esc_html__( 'Add your Image', 'royarch' )
			)
		);
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_About_Block widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
        
        <!-- about-section 
			================================================== -->
		<section class="about-section">

			<div class="container">
				<div class="about-box">
					<div class="row">
						<div class="col-lg-6">
							<div class="images">
								<div class="row">
									<div class="col-md-6">
										<?php if($settings['widget_image']['url']) {?>
											<img src="<?php echo esc_url($settings['widget_image']['url']); ?>" alt>
										<?php } ?>
										<?php if($settings['widget_image2']['url']) {?>
											<img src="<?php echo esc_url($settings['widget_image2']['url']); ?>" alt>
										<?php } ?>
									</div>
									<div class="col-md-6">
										<?php if($settings['widget_image3']['url']) {?>
											<img  class="snd-size" src="<?php echo esc_url($settings['widget_image3']['url']); ?>" alt>
										<?php } ?>
									</div>
								</div>
							</div>
						</div>
						<div class="col-lg-6">
							<div class="about-content">
								<h3><?php echo do_shortcode($settings['widget_title']); ?></h3>
								<?php echo do_shortcode($settings['widget_desc']); ?>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
		<!-- End about-section -->
			
    
    <?php

	}
}
