<?php
/**
 * Royarch Elementor Global Widget Carousel_Block4.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Carousel_Block4 extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Carousel_Block4 widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Carousel-Block4';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Carousel_Block4 widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Carousel Block 4', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Carousel_Block4 widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-arrows-alt-h';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_Carousel_Block4 widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Carousel_Block4 widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_Carousel_Block4_title_manage',
			array(
				'label' => esc_html__( 'Carousel Portfolio Block 4', 'royarch' ),
			)
		);
		
		$this->add_control(
		    'col_number',
		    [
		        'label' => esc_html__( 'Number of Column', 'royarch' ),
                'type' => Controls_Manager::NUMBER,
                'description' => esc_html__('Number of Columns to show', 'royarch'),
                'default' => 3,
				'label_block' => true,
		    ]
        );
        
		$this->add_control(
		    'widget_number',
		    [
		        'label' => esc_html__( 'Posts Number', 'royarch' ),
                'type' => Controls_Manager::NUMBER,
                'description' => esc_html__('Posts number to get from the WP Query (post per page)', 'royarch'),
                'default' => 9,
				'label_block' => true,
		    ]
		);

        $this->add_control(
			'order',
			array(
				'label'       => esc_html__( 'Sort Posts:', 'royarch' ),
				'type'        => Controls_Manager::SELECT,
				'placeholder' => esc_html__( 'Sort Posts by', 'royarch' ),
				'label_block' => true,
				'default' => 'default',
				'options' => array(
					'default'     => esc_html__( 'Default', 'royarch' ),
					'ASC'     => esc_html__( 'ASC', 'royarch' ),
					'DESC' => esc_html__( 'DESC', 'royarch' ),
				),
			)
		);

		$this->add_control(
			'display_type',
			array(
				'label'   => esc_html__( 'Display the Posts from:', 'royarch' ),
				'type'    => Controls_Manager::SELECT,
				'label_block' => true,
				'default' => 'latest',
				'options' => array(
					'latest'     => esc_html__( 'Latest Posts', 'royarch' ),
					'categories' => esc_html__( 'Categories', 'royarch' ),
					'tags' => esc_html__( 'Tags', 'royarch' ),
				),
			)
		);

	    $taxonomy = 'Project Category';

   		$categories = get_terms($taxonomy);

		foreach ($categories as $category) {
	        $category_option[$category->name] = $category->slug;
	    }

		$this->add_control(
			'categories_selected',
			array(
				'label'     => esc_html__( 'Select Category:', 'royarch' ),
				'type'      => Controls_Manager::SELECT,
				'label_block' => true,
				'default' => 'all',
				'options'   => $category_option,
				'condition' => array(
					'display_type' => 'categories',
				),
			)
        );

		$taxonomy2 = 'tag';

   		$tags = get_terms([
          'taxonomy'  => $taxonomy2,
          'hide_empty'    => false
        ]);
	    $tags_option = array();
        $tags_option['all'] = 'all';
        
	    foreach ($tags as $tag) {
	        $tags_option[$tag->name] = $tag->slug;
	    }

		$this->add_control(
			'tags_selected',
			array(
				'label'     => esc_html__( 'Select Tag:', 'royarch' ),
				'type'      => Controls_Manager::SELECT,
				'label_block' => true,
				'default' => 'all',
				'options'   => $tags_option,
				'condition' => array(
					'display_type' => 'tags',
				),
			)
        );
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Carousel_Block4 widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {

        $posts_number        = $this->get_settings( 'widget_number' );
        $col_number        = $this->get_settings( 'col_number' );
		$display_type        = $this->get_settings( 'display_type' );
		$order        = $this->get_settings( 'order' );
		$categories_selected = $this->get_settings( 'categories_selected' );
		$tags_selected = $this->get_settings( 'tags_selected' );
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

        $args = array(
			'posts_per_page'      => $posts_number,
			'post_type'           => 'project',
            'ignore_sticky_posts' => true,
            'paged'               => $paged
        );
        
        if ( $order != 'default' ) {
			$args[ 'order' ] = $order;
		}

		// Display from the category selected
		if ( $display_type == 'categories' && $categories_selected !== 'all' ) {
			$args[ 'tax_query' ] = array(
				array(
					'taxonomy' => 'Project Category',
					'field'    => 'slug',
					'terms'    => $categories_selected,
				),
			);
		}

		// Display from the tag selected
		if ( $display_type == 'tags' && $tags_selected !== 'all' ) {
			$args[ 'tax_query' ] = array(
				array(
					'taxonomy' => 'tag',
					'field'    => 'slug',
					'terms'    => $tags_selected,
				),
			);
		}

		$reverseOrder = 'reverse-order';
	?>



		<!-- scroller-section4
			================================================== -->
		<section class="scroller-section4">

			<div class="scroller-box owl-scroller">
				<div class="owl-carousel owl-theme" data-num="<?php echo esc_attr($col_number); ?>">
					<?php 
	                    $query = new \WP_Query($args);
	                    $i = 1;
	                    if ( $query->have_posts() ) {
	                        while ( $query->have_posts() ) {
	                            $query->the_post();
								$taxonomy = 'Project Category';
								$categories = get_the_terms( $post->ID, 'Project Category' );

	                            ?>

								<div class="item">
									<a href="<?php the_permalink(); ?>" class="scroller-post">
										<div class="num-holder">
											<span><?php echo esc_html_e('0', 'royarch') . esc_html($i); ?></span>
										</div>
										<div class="cont-holder">
											<div class="text-holder">
												<?php
												    if ( ! empty( $categories ) ) { ?>
														<span class="cat-link">
															<?php echo esc_html( $categories[0]->name ); ?>
														</span>
												<?php } ?>
												<h4><?php the_title(); ?></h4>
											</div>
											<?php if ( has_post_thumbnail() ) { ?>
												<img src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" alt>
										    <?php } ?>
										</div>
									</a>
								</div>

	                    	<?php $i++;

	                    	}

	                    }
	                ?>
					
				</div>
			</div>

		</section>
		<!-- End scroller-section4 -->
    
    <?php
    
	}
}

