<?php
/**
 * Royarch Elementor Global Widget Col_Block.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Col_Block extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Col_Block widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Col-Block';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Col_Block widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blog Col Style', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Col_Block widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-medal';
	}

	/**
	 * Retrieve the Col of categories the royarch_Elementor_Global_Widget_Col_Block widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Col_Block widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_col_block_title_manage',
			array(
				'label' => esc_html__( 'Blog Col Style', 'royarch' ),
			)
		);
        
		$this->add_control(
		    'widget_number',
		    [
		        'label' => esc_html__( 'Posts Number', 'royarch' ),
                'type' => Controls_Manager::NUMBER,
                'description' => esc_html__('Posts number to get from the WP Query (post per page)', 'royarch'),
                'default' => 9,
				'label_block' => true,
		    ]
		);
        
		$this->add_control(
		    'widget_col',
		    [
		        'label' => esc_html__( 'Column Number', 'royarch' ),
                'type' => Controls_Manager::NUMBER,
                'description' => esc_html__('1,2,3 is best fit in our theme', 'royarch'),
                'default' => 2,
				'label_block' => true,
		    ]
		);
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Col_Block widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {

        $settings = $this->get_settings_for_display();
        $posts_number = $settings['widget_number'];
        $col_number = $settings['widget_col'];

	?>

		<!-- blog-section 
			================================================== -->
		<section class="blog-section">
			<div class="container">
				<div class="blog-box iso-call col<?php echo esc_attr($col_number); ?>">

					<?php
						$args = array(
							'posts_per_page'      => $posts_number,
							'post_type'           => 'post',
							'ignore_sticky_posts' => true
						);
						$query = new \WP_Query($args);

						if ( $query->have_posts() ) {
							while ( $query->have_posts() ) {
								$query->the_post(); 
								
								get_template_part( 'template-parts/post-layouts/standard-post' );
							}
						} 
					?>
					
				</div>
				<?php

							fabric_paging_navigation($query);

							\wp_reset_postdata();

				?>
			</div>
		</section>
		<!-- End blog-section -->
			
    
    <?php

	}
}
