<?php
/**
 * Royarch Elementor Global Widget Contact_Info_Block.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Contact_Info_Block extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Contact_Info_Block widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Contact-Info-Block';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Contact_Info_Block widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Contact Info Block', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Contact_Info_Block widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-info';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_Contact_Info_Block widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Contact_Info_Block widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_Contact_Info_Block_title_manage',
			array(
				'label' => esc_html__( 'Contact Info Block', 'royarch' ),
			)
		);

		$this->add_control(
			'widget_title',
			array(
				'label'       => esc_html__( 'Section Title:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your custom block title', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_sub',
			array(
				'label'       => esc_html__( 'Section SubTitle:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your custom block subtitle', 'royarch' ),
				'label_block' => true,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Contact Name', 'royarch' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'list_desc', [
				'label' => __( 'Contact Description', 'royarch' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);

		$repeater->add_control(
			'list_icon', [
				'label' => __( 'Icon', 'royarch' ),
				'type' => Controls_Manager::ICONS,
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Contact Info List', 'royarch' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Contact_Info_Block widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings_for_display();?>
        

		<div class="container">
			<div class="contact-form-box">
				<div class="contact-text">
					<h3><?php echo do_shortcode($settings['widget_title']); ?></h3>
					<p><?php echo do_shortcode($settings['widget_description']); ?></p>
					<?php if($settings['widget_image']['url']) {?>
						<img src="<?php echo esc_url($settings['widget_image']['url']); ?>" alt>
					<?php } ?>
				</div>
				<div class="contact-form">
					<?php echo do_shortcode($settings['widget_contact']); ?>
				</div>
			</div>
		</div>
			
    
    <?php

	}
}
