<?php
/**
 * Royarch Elementor Global Widget Feature_Carousel_Block.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Feature_Carousel_Block extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Feature_Carousel_Block widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Feature-Carousel-Block';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Feature_Carousel_Block widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Feature Carousel Block', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Feature_Carousel_Block widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-feather';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_Feature_Carousel_Block widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Feature_Carousel_Block widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_feature_carousel_block_title_manage',
			array(
				'label' => esc_html__( 'Feature Carousel Block', 'royarch' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Feature Title', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_sub', [
				'label' => __( 'Feature Subtitle', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_image', [
				'label' => __( 'Image', 'royarch' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'list_url', [
				'label' => __( 'Feature Link', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Feature List', 'royarch' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);

		$repeater = new Repeater();
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Feature_Carousel_Block widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings_for_display();?>



		<!-- features-carousel-section
			================================================== -->
		<section class="features-carousel-section">

			<div class="container">
				<div class="features-carousel-box owl-wrapper">
					<div class="owl-carousel owl-theme" data-num="1">
						<?php foreach (  $settings['list'] as $item ) { 
						
						?>
						<div class="item">
							<div class="feature-post">
								<div class="image-holder">
									<img src="<?php echo esc_url($item['list_image']['url']); ?>" alt>
								</div>
								<div class="feature-post-content">
									<span><?php echo esc_html($item['list_sub']); ?></span>
									<h3><a href="<?php echo esc_url(do_shortcode($item['list_url'])); ?>"><?php echo esc_html($item['list_title']); ?></a></h3>
								</div>
							</div>
						</div>

                        <?php } ?>
						
					</div>
				</div>
			</div>

		</section>
		<!-- End features-carousel-section -->
    
    <?php

	}
}
