<?php
/**
 * Royarch Elementor Global Widget Features_Block.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Features_Block extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Features_Block widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Features-Block';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Features_Block widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Features Block', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Features_Block widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-feather-alt';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_Features_Block widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Features_Block widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_Features_Block_title_manage',
			array(
				'label' => esc_html__( 'Features Block', 'royarch' ),
			)
		);

		$this->add_control(
			'widget_title',
			array(
				'label'       => esc_html__( 'Title:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your title', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_desc',
			array(
				'label'       => esc_html__( 'Description:', 'royarch' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Add your description', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_link',
			array(
				'label'       => esc_html__( 'Link Text:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your link text here', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_url',
			array(
				'label'       => esc_html__( 'Link Url:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your link url here', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_image',
			array(
				'label'       => esc_html__( 'Image', 'royarch' ),
				'type'        => Controls_Manager::MEDIA,
				'placeholder' => esc_html__( 'Add your Image', 'royarch' )
			)
		);
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Features_Block widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$widgetUrl = do_shortcode($settings['widget_url']);
		?>
        

		<!-- features-section
			================================================== -->
		<section class="features-section">

			<div class="container">
				<div class="features-box">
					<div class="row">
						<div class="col-lg-5">
							<div class="feature-content">
								<h3><?php echo do_shortcode($settings['widget_title']); ?></h3>
								<p><?php echo do_shortcode($settings['widget_desc']); ?></p>
								<a href="<?php echo esc_url($widgetUrl); ?>" class="theme-button"><span><?php echo do_shortcode($settings['widget_link']); ?></span></a>
							</div>
						</div>
						<div class="col-lg-7">
							<div class="image-holder">
								<?php if($settings['widget_image']['url']) {?>
									<img src="<?php echo esc_url($settings['widget_image']['url']); ?>" alt>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
		<!-- End features-section -->
			
    
    <?php

	}
}
