<?php
/**
 * Royarch Elementor Global Widget Features_Block2.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Features_Block2 extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Features_Block2 widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Features-Block2';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Features_Block2 widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Features Block 2', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Features_Block2 widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-feather-alt';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_Features_Block2 widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Features_Block2 widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_Features_Block2_title_manage',
			array(
				'label' => esc_html__( 'Features Block 2', 'royarch' ),
			)
		);

		$this->add_control(
			'widget_title',
			array(
				'label'       => esc_html__( 'Title:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your title', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_sub',
			array(
				'label'       => esc_html__( 'Subtitle:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your subtitle', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_desc',
			array(
				'label'       => esc_html__( 'Description:', 'royarch' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Add your description', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_image',
			array(
				'label'       => esc_html__( 'Image 1', 'royarch' ),
				'type'        => Controls_Manager::MEDIA,
				'placeholder' => esc_html__( 'Add your Image', 'royarch' )
			)
		);

		$this->add_control(
			'widget_image_desc',
			array(
				'label'       => esc_html__( 'Image hover text:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your Image description on hover', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_image_link',
			array(
				'label'       => esc_html__( 'Link URL:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your Image description Link Url', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_image2',
			array(
				'label'       => esc_html__( 'Image 2', 'royarch' ),
				'type'        => Controls_Manager::MEDIA,
				'placeholder' => esc_html__( 'Add your Image', 'royarch' )
			)
		);

		$this->add_control(
			'widget_image2_desc',
			array(
				'label'       => esc_html__( 'Image 2 hover text:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your Image description on hover', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_image2_link',
			array(
				'label'       => esc_html__( 'Link URL:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your Image description Link Url', 'royarch' ),
				'label_block' => true,
			)
		);
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Features_Block2 widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
        
        <!-- features-section2
			================================================== -->
		<section class="features-section2">

			<div class="container">
				<div class="features-box2">
					<div class="row">
						<div class="col-lg-6">
							<div class="images-box">
								<div class="row">
									<div class="col-md-6">
										<div class="image-holder">
											<?php if($settings['widget_image']['url']) {?>
												<img src="<?php echo esc_url($settings['widget_image']['url']); ?>" alt>
											<?php } ?>
											<a href="<?php echo esc_url(do_shortcode($settings['widget_image_link'])); ?>"><?php echo do_shortcode($settings['widget_image_desc']); ?></a>
										</div>
									</div>
									<div class="col-md-6">
										<div class="image-holder">
											<?php if($settings['widget_image']['url']) {?>
												<img src="<?php echo esc_url($settings['widget_image2']['url']); ?>" alt>
											<?php } ?>
											<a href="<?php echo esc_url(do_shortcode($settings['widget_image2_link'])); ?>"><?php echo do_shortcode($settings['widget_image2_desc']); ?></a>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-lg-6">
							<div class="feature-content">
								<span><?php echo do_shortcode($settings['widget_sub']); ?></span>
								<h3><?php echo do_shortcode($settings['widget_title']); ?></h3>
								<p><?php echo do_shortcode($settings['widget_desc']); ?></p>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
		<!-- End features-section -->
			
    
    <?php

	}
}
