<?php
/**
 * Royarch Elementor Global Widget Services_Block4.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Services_Block4 extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Services_Block4 widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Services-Block4';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Services_Block4 widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Services Block 4', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Services_Block4 widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-cogs';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_Services_Block4 widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Services_Block4 widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_services_block4_title_manage',
			array(
				'label' => esc_html__( 'Services Block 4', 'royarch' ),
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Services Name', 'royarch' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'list_desc', [
				'label' => __( 'Services Description', 'royarch' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);

		$repeater->add_control(
			'list_icon', [
				'label' => __( 'Icon', 'royarch' ),
				'type' => Controls_Manager::ICONS,
			]
		);

		$repeater->add_control(
			'list_image', [
				'label' => __( 'Image', 'royarch' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'list_url', [
				'label' => __( 'Services Link URL', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Services List', 'royarch' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);

		$repeater = new Repeater();
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Services_Block4 widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings_for_display();?>

		<!-- services-section4
			================================================== -->
		<section class="services-section4">
			<div class="services-box4">
				<?php foreach (  $settings['list'] as $item ) { 
					
					?>
					<div class="services-post4">
						<img src="<?php echo esc_attr($item['list_image']['url']); ?>" alt>
						<div class="serv-content">
							<a href="<?php echo esc_url(do_shortcode($item['list_url'])); ?>">
							<?php
							if (strpos($item['list_icon']['value'],'fa-') !== false) {
								Icons_Manager::render_icon( $item['list_icon'], [ 'aria-hidden' => 'true' ] );
							} elseif (strpos($item['list_icon']['value'],'material-icons-outlined') !== false) {
								?>
								<span class="<?php echo esc_attr($item['list_icon']['value']); ?>">
								<?php 
									echo esc_html(str_replace( 'material-icons-outlined md-', '', $item['list_icon']['value']  ));
								?>
								</span>
								<?php
							} else { 
								?>
								<span class="<?php echo esc_attr($item['list_icon']['value']); ?>">
								<?php 
									echo esc_html(str_replace( 'material-icons md-', '', $item['list_icon']['value']  ));
								?>
								</span>
								<?php 
							}
							?>
							</a>
							<h4><?php echo esc_html($item['list_title']); ?></h4>
							<p><?php echo esc_html($item['list_desc']); ?> </p>
						</div>
					</div>

                <?php } ?>
			</div>

		</section>
		<!-- End services-section4 -->
    
    <?php

	}
}
