<?php
/**
 * Royarch Elementor Global Widget Services_Block6.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Services_Block6 extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Services_Block6 widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Services-Block6';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Services_Block6 widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Services Block 6', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Services_Block6 widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-cogs';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_Services_Block6 widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Services_Block6 widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_services_block6_title_manage',
			array(
				'label' => esc_html__( 'Services Block 6', 'royarch' ),
			)
		);

		$this->add_control(
			'widget_title',
			array(
				'label'       => esc_html__( 'Block Title:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your title', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_sub',
			array(
				'label'       => esc_html__( 'Block Subtitle:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your subtitle', 'royarch' ),
				'label_block' => true,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Services Name', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_desc', [
				'label' => __( 'Services Description', 'royarch' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);

		$repeater->add_control(
			'list_icon', [
				'label' => __( 'Icon', 'royarch' ),
				'type' => Controls_Manager::ICONS,
			]
		);

		$repeater->add_control(
			'list_url', [
				'label' => __( 'Services Link URL', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Services List', 'royarch' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);

		$repeater = new Repeater();

		$this->add_control(
			'widget_link',
			array(
				'label'       => esc_html__( 'Link Text:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your link text here', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_url',
			array(
				'label'       => esc_html__( 'Link Url:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your link url here', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_image',
			array(
				'label'       => esc_html__( 'Image', 'royarch' ),
				'type'        => Controls_Manager::MEDIA,
				'placeholder' => esc_html__( 'Add your Image', 'royarch' )
			)
		);
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Services_Block6 widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings_for_display();
		$widgetUrl = do_shortcode($settings['widget_url']);
        ?>


		<!-- services-section6 
			================================================== -->
		<section class="services-section6">

			<div class="container">
				<div class="services-box6">
					<div class="row">
						<div class="col-lg-6">
							<div class="title-box">
								<span><?php echo do_shortcode($settings['widget_sub']); ?></span>
								<h2><?php echo do_shortcode($settings['widget_title']); ?></h2>
							</div>

							<?php foreach (  $settings['list'] as $item ) { ?>
							<div class="services-post6">
								<a href="<?php echo esc_url(do_shortcode($item['list_url'])); ?>" class="icon">
									<?php
									if (strpos($item['list_icon']['value'],'fa-') !== false) {
										Icons_Manager::render_icon( $item['list_icon'], [ 'aria-hidden' => 'true' ] );
									} elseif (strpos($item['list_icon']['value'],'material-icons-outlined') !== false) {
										?>
										<span class="<?php echo esc_attr($item['list_icon']['value']); ?>">
										<?php 
											echo esc_html(str_replace( 'material-icons-outlined md-', '', $item['list_icon']['value']  ));
										?>
										</span>
										<?php
									} else { 
										?>
										<span class="<?php echo esc_attr($item['list_icon']['value']); ?>">
										<?php 
											echo esc_html(str_replace( 'material-icons md-', '', $item['list_icon']['value']  ));
										?>
										</span>
										<?php 
									}
									?>
								</a>
								<div class="serv-content">
									<h4><?php echo esc_html($item['list_title']); ?></h4>
									<p><?php echo esc_html($item['list_desc']); ?></p>
								</div>
							</div>
                        	<?php } ?>

						</div>
						<div class="col-lg-6">
							<div class="image-holder">
								<?php if($settings['widget_image']['url']) {?>
									<img src="<?php echo esc_url($settings['widget_image']['url']); ?>" alt>
								<?php } ?>
								<a class="serv-link" href="<?php echo esc_url($widgetUrl); ?>">
									<?php echo do_shortcode($settings['widget_link']); ?>
									<i class="fas fa-long-arrow-alt-right"></i>
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>

		</section>
		<!-- End services-section6 -->
    
    <?php

	}
}
