<?php
/**
 * Royarch Elementor Global Widget Single_Project.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Single_Project extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Single_Project widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Single-Project';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Single_Project widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Single Project 1', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Single_Project widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-box-open';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_Single_Project widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Single_Project widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_single_project_title_manage',
			array(
				'label' => esc_html__( 'Single Project Block', 'royarch' ),
			)
		);

		$this->add_control(
			'widget_title',
			array(
				'label'       => esc_html__( 'Project SubTitle:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your title', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_desc',
			array(
				'label'       => esc_html__( 'Project Description:', 'royarch' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Add your description', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_image',
			array(
				'label'       => esc_html__( 'Project Main Image:', 'royarch' ),
				'type'        => Controls_Manager::MEDIA,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'List Name', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_desc', [
				'label' => __( 'List Description', 'royarch' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Project List Data', 'royarch' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);

		$repeater = new Repeater();

		$this->add_control(
			'widget_gallery',
			array(
				'label'       => esc_html__( 'Add Gallery Images:', 'royarch' ),
				'type'        => Controls_Manager::GALLERY,
			)
		);
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Single_Project widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>


		<!-- single-project-section 
			================================================== -->
		<section class="single-project-section">

			<div class="container">
				<div class="single-project-content">
					<div class="row">
						<div class="col-md-6">
							<div class="project-content">
								<h2><?php echo do_shortcode($settings['widget_title']); ?></h2>
								<ul class="project-data-list">
									<?php foreach (  $settings['list'] as $item ) { ?>

										<li>
											<span class="data-name">
												<?php echo esc_html($item['list_title']); ?>
											</span>
											<span class="data-text">
												<?php echo esc_html($item['list_desc']); ?>
											</span>
										</li>

									<?php } ?>
								</ul>
								<?php echo do_shortcode($settings['widget_desc']); ?>
							</div>
						</div>
						<div class="col-md-6">
							<div class="feature-image">
								<?php if($settings['widget_image']['url']) {?>
									<img src="<?php echo esc_url($settings['widget_image']['url']); ?>" alt>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
				<ul class="gallery-list">
					<?php
						foreach ( $settings['widget_gallery'] as $image ) { ?>
						<li>
							<a href="<?php echo esc_url($image['url']); ?>" class="zoom">
								<img src="<?php echo esc_url($image['url']); ?>"
									alt="<?php echo esc_attr($image['id']); ?>">
							</a>
						</li>
					<?php } ?>
				</ul>
			</div>

		</section>
		<!-- End single-project-section -->
    
    <?php

	}
}
