<?php
/**
 * Royarch Elementor Global Widget Tab_Block.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Tab_Block extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Tab_Block widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Tab-Block';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Tab_Block widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Tab Carousel Block', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Tab_Block widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-plus-square';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_Tab_Block widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Tab_Block widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_Tab_block_title_manage',
			array(
				'label' => esc_html__( 'Tab Block', 'royarch' ),
			)
		);

		$this->add_control(
			'widget_title',
			array(
				'label'       => esc_html__( 'Block Title:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your title', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_sub',
			array(
				'label'       => esc_html__( 'Block Subtitle:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your subtitle', 'royarch' ),
				'label_block' => true,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Tab Name', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'list_desc', [
				'label' => __( 'Tab Description', 'royarch' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);

		$repeater->add_control(
			'list_image', [
				'label' => __( 'Tab Image', 'royarch' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'list_id', [
				'label' => __( 'Tab Id', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'You have to make it unique for each tab (ex: tab1, tab2)', 'royarch' ),
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Tab List', 'royarch' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);
        
		$this->end_controls_section();

		// Widget title section
		$this->start_controls_section(
			'section_collapse_block_title_manage',
			array(
				'label' => esc_html__( 'Collapse Block', 'royarch' ),
			)
		);

		$repeater2 = new Repeater();

		$repeater2->add_control(
			'list2_title', [
				'label' => __( 'Collapse Name', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater2->add_control(
			'list2_desc', [
				'label' => __( 'Collapse Description', 'royarch' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);

		$repeater2->add_control(
			'list2_icon', [
				'label' => __( 'Icon', 'royarch' ),
				'type' => Controls_Manager::ICONS,
			]
		);

		$repeater2->add_control(
			'list2_id', [
				'label' => __( 'Collapse Id', 'royarch' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'You have to make it unique for each tab (ex: one, two ...)', 'royarch' ),
			]
		);

		$this->add_control(
			'list2',
			[
				'label' => __( 'Collapse List', 'royarch' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater2->get_controls(),
				'title_field' => '{{{ list2_title }}}',
			]
		);
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Tab_Block widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings_for_display();
		$widgetUrl = do_shortcode($settings['widget_url']);
		$i = 0;
        ?>

		<!-- tabs-collapse-section 
			================================================== -->
		<section class="tabs-collapse-section">

			<div class="container">
				<div class="title-box">
					<span><?php echo do_shortcode($settings['widget_sub']); ?></span>
					<h2><?php echo do_shortcode($settings['widget_title']); ?></h2>
				</div>
				<div class="tabs-collapse">
					<div class="row">
						<div class="col-lg-6">
							<ul class="nav nav-tabs" id="myTab" role="tablist">
								<?php foreach (  $settings['list'] as $item ) { ?>
								<li class="nav-item" role="presentation">
									<button class="nav-link <?php if($i == 0) {esc_attr_e('active','royarch');}?>" id="<?php echo esc_attr($item['list_id']); ?>-tab" data-bs-toggle="tab" data-bs-target="#<?php echo esc_attr($item['list_id']); ?>" type="button" role="tab" aria-controls="<?php echo esc_attr($item['list_id']); ?>" aria-selected="<?php if($i == 0) {esc_attr_e('true','royarch');} else {esc_attr_e('false','royarch');}?>">
										<?php echo esc_html($item['list_title']); ?>
									</button>
								</li>
                        		<?php $i++; } ?>
							</ul>
							<?php $i = 0; ?>
							<div class="tab-content" id="myTabContent">
								<?php foreach (  $settings['list'] as $item ) { ?>
								<div class="tab-pane fade <?php if($i == 0) {esc_attr_e('show active','royarch');}?>" id="<?php echo esc_attr($item['list_id']); ?>" role="tabpanel" aria-labelledby="<?php echo esc_attr($item['list_id']); ?>-tab">
									<div class="row">
										<div class="col-lg-4">
											<img src="<?php echo esc_url($item['list_image']['url']); ?>" alt>
										</div>
										<div class="col-lg-8">
											<p><?php echo esc_html($item['list_desc']); ?></p>
										</div>
									</div>
								</div>
                        		<?php $i++; } ?>
							</div>
							<?php $i = 0; ?>
						</div>
						<div class="col-lg-6">
							<div class="accordion" id="accordionExample">

								<?php foreach (  $settings['list2'] as $item ) { ?>
								<div class="accordion-item">
									<h2 class="accordion-header" id="heading<?php echo esc_attr($item['list2_id']); ?>">
										<button class="accordion-button <?php if($i !== 0) {esc_attr_e('collapsed','royarch');}?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo esc_attr($item['list2_id']); ?>" aria-expanded="true" aria-controls="collapse<?php echo esc_attr($item['list2_id']); ?>">
											<?php Icons_Manager::render_icon( $item['list2_icon'] ); ?>
											<span><?php echo esc_html($item['list2_title']); ?></span>
										</button>
									</h2>
									<div id="collapse<?php echo esc_attr($item['list2_id']); ?>" class="accordion-collapse collapse <?php if($i == 0) {esc_attr_e('show','royarch');}?>" aria-labelledby="heading<?php echo esc_attr($item['list2_id']); ?>" data-bs-parent="#accordionExample">
										<div class="accordion-body">
											<p><?php echo esc_html($item['list2_desc']); ?></p>
										</div>
									</div>
								</div>
                        		<?php $i++; } ?>
							</div>
						</div>
						
					</div>
				</div>
			</div>

		</section>
		<!-- End tabs-collapse-section -->
    
    <?php

	}
}
