<?php
/**
 * Royarch Elementor Global Widget Team_Block.
 *
 * @package    Royarch - Unikwp
 * @subpackage royarch
 * @since      Royarch 1.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	return; // Exit if it is accessed directly
}

class Royarch_Elementor_Global_Widgets_Team_Block extends Widget_Base {

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Team_Block widget name.
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'Royarch-Global-Widgets-Team-Block';
	}

	/**
	 * Retrieve Royarch_Elementor_Global_Widgets_Team_Block widget Title.
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team Block', 'royarch' );
	}

	/**
	 * Retrieve royarch_Elementor_Global_Widget_Team_Block widget icon.
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-user-friends';
	}

	/**
	 * Retrieve the list of categories the royarch_Elementor_Global_Widget_Team_Block widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'royarch-widget-blocks' );
	}
	
	/**
	 * Register royarch_Elementor_Global_Widget_Team_Block widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		// Widget title section
		$this->start_controls_section(
			'section_Team_Block_title_manage',
			array(
				'label' => esc_html__( 'Team Block', 'royarch' ),
			)
		);

		$this->add_control(
			'widget_title',
			array(
				'label'       => esc_html__( 'Block Title:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your title', 'royarch' ),
				'label_block' => true,
			)
		);

		$this->add_control(
			'widget_sub',
			array(
				'label'       => esc_html__( 'Block Subtitle:', 'royarch' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your subtitle', 'royarch' ),
				'label_block' => true,
			)
		);
		
		$this->add_control(
		    'widget_number',
		    [
		        'label' => esc_html__( 'Columns Number', 'royarch' ),
                'type' => Controls_Manager::NUMBER,
                'description' => esc_html__('Should be 2,3 or 4 to fit in theme style', 'royarch'),
                'default' => 4,
		    ]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Team Member Name', 'royarch' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'list_pos', [
				'label' => __( 'Position', 'royarch' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'list_image', [
				'label' => __( 'Image', 'royarch' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$repeater->add_control(
			'list_fb', [
				'label' => __( 'Facebook Link', 'royarch' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'list_twitter', [
				'label' => __( 'Twitter Link', 'royarch' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'list_pinterest', [
				'label' => __( 'Pinterest Link', 'royarch' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'list_linkedin', [
				'label' => __( 'Linkedin Link', 'royarch' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Team List', 'royarch' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);

		$repeater = new Repeater();
        
		$this->end_controls_section();

	}

	/**
	 * Render Royarch_Elementor_Global_Widgets_Team_Block widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings_for_display();?>
        
        <!-- team-section 
			================================================== -->
		<section class="team-section">
            <div class="container">
				<div class="title-box">
					<span><?php echo do_shortcode($settings['widget_sub']); ?></span>
					<h2><?php echo do_shortcode($settings['widget_title']); ?></h2>
				</div>
                <div class="team-box">
                    <div class="row">
                        <?php foreach (  $settings['list'] as $item ) { 
							$colNumber = 12/do_shortcode($settings['widget_number']);
							
							?>
                            <div class="col-md-<?php echo esc_attr($colNumber) ?>">
                            	<div class="team-post">
									<img src="<?php echo esc_url($item['list_image']['url']); ?>" alt>
									<div class="hover-team">
										<ul class="social-team">
											<?php if($item['list_fb']) {?>
                                                <li><a href="<?php echo esc_url($item['list_fb']); ?>"><i class="fab fa-facebook-f"></i></a></li>
                                            <?php } ?>
                                            <?php if($item['list_twitter']) {?>
                                                <li><a href="<?php echo esc_url($item['list_twitter']); ?>"><i class="fab fa-twitter"></i></a></li>
                                            <?php } ?>
                                            <?php if($item['list_pinterest']) {?>
                                                <li><a href="<?php echo esc_url($item['list_pinterest']); ?>"><i class="fab fa-instagram"></i></a></li>
                                            <?php } ?>
                                            <?php if($item['list_linkedin']) {?>
                                                <li><a href="<?php echo esc_url($item['list_linkedin']); ?>"><i class="fab fa-linkedin-in"></i></a></li>
                                            <?php } ?>
										</ul>
										<h3><?php echo esc_html($item['list_title']); ?></h3>
										<span><?php echo esc_html($item['list_pos']); ?></span>
									</div>
								</div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
		</section>
        <!-- End team section -->
    
    <?php

	}
}
