<?php


$cmb = new_cmb2_box( array(
    'id'            => 'page_options',
    'title'         => esc_html__( 'Page Settings', 'royarch' ),
    'object_types'  => array( 'page' ), // Post type
    'context'       => 'normal',
    'priority'      => 'high',
    'show_names'    => true, // Show field names on the left
) );

$cmb->add_field(
    array(
            'name'     => esc_html__( 'Banner Title', 'royarch' ),
            'desc'     => esc_html__( 'Page Banner Title', 'royarch' ),
            'id'       => $prefix . 'banner_title',
            'type'     => 'text',
            'on_front' => false,
        )
);

$cmb->add_field(
    array(
            'name'     => esc_html__( 'Banner SubTitle', 'royarch' ),
            'desc'     => esc_html__( 'Page Banner SubTittle', 'royarch' ),
            'id'       => $prefix . 'banner_subtitle',
            'type'     => 'text',
            'on_front' => false,
        )
);

$cmb->add_field(
    array(
        'name'     => esc_html__( 'Hide Contact Info', 'royarch' ),
        'id'       => $prefix . 'contact_info_hide',
        'type' => 'checkbox',
    )
);

$cmb->add_field(
    array(
        'name'     => esc_html__( 'Hide Page Banner', 'royarch' ),
        'id'       => $prefix . 'banner_hide',
        'type' => 'checkbox',
    )
);

$cmb->add_field(
    array(
        'name'     => esc_html__( 'Hide Go Top Arrow', 'royarch' ),
        'id'       => $prefix . 'arrow_hide',
        'type' => 'checkbox',
    )
);

$cmb->add_field(
    array(
        'name'     => esc_html__( 'Hide Footer', 'royarch' ),
        'id'       => $prefix . 'footer_hide',
        'type' => 'checkbox',
    )
);





