<?php

/**
 * Royarch
 *
 * Unikwp - Besim Dauti
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

define( 'ROYARCH_PARENT_DIR', get_template_directory() );
define( 'ROYARCH_CHILD_DIR', get_stylesheet_directory() );
define( 'ROYARCH_INCLUDES_DIR', ROYARCH_PARENT_DIR . '/framework' );
define( 'ROYARCH_CSS_DIR', ROYARCH_PARENT_DIR . '/assets/css' );
define( 'ROYARCH_JS_DIR', ROYARCH_PARENT_DIR . '/assets/js' );
define( 'ROYARCH_LANGUAGES_DIR', ROYARCH_PARENT_DIR . '/languages' );
define( 'ROYARCH_ELEMENTOR_DIR', ROYARCH_INCLUDES_DIR . '/elementor' );
define( 'ROYARCH_ELEMENTOR_WIDGETS_DIR', ROYARCH_ELEMENTOR_DIR . '/widgets' );

/**
 * Define URL Location Constants
 */
define( 'ROYARCH_PARENT_URL', get_template_directory_uri() );
define( 'ROYARCH_CHILD_URL', get_stylesheet_directory_uri() );
define( 'ROYARCH_INCLUDES_URL', ROYARCH_PARENT_URL . '/framework' );
define( 'ROYARCH_CSS_URL', ROYARCH_PARENT_URL . '/assets/css' );
define( 'ROYARCH_JS_URL', ROYARCH_PARENT_URL . '/assets/js' );
define( 'ROYARCH_LANGUAGES_URL', ROYARCH_PARENT_URL . '/languages' );
define( 'ROYARCH_ELEMENTOR_URL', ROYARCH_INCLUDES_URL . '/elementor' );
define( 'ROYARCH_ELEMENTOR_WIDGETS_URL', ROYARCH_ELEMENTOR_URL . '/widgets' );

require_once ROYARCH_INCLUDES_DIR . '/metabox/meta-box.php';
require_once ROYARCH_INCLUDES_DIR . '/customize.php';


/** Add the Elementor compatibility file */
if ( defined( 'ELEMENTOR_VERSION' ) ) {
    require_once( ROYARCH_ELEMENTOR_DIR . '/elementor-script.php' );
}

// Register Elementor Locations
function royarch_register_elementor_locations( $elementor_theme_manager ) {
	$elementor_theme_manager->register_all_core_location();
};
add_action( 'elementor/theme/register_locations', 'royarch_register_elementor_locations' );


require_once get_template_directory() . '/includes/royarch-after-setup.php';
require_once get_template_directory() . '/includes/royarch-widgets.php';
require_once get_template_directory() . '/includes/royarch-scripts.php';
require_once get_template_directory() . '/includes/royarch-lazyload.php';
require_once get_template_directory() . '/includes/other-functions.php';
require_once get_template_directory() . '/includes/fonts-style-action.php';
require_once get_template_directory() . '/includes/royarch-comments.php';
require_once get_template_directory() . '/includes/royarch-required-plugins.php';
