<!doctype html>

<html <?php language_attributes(); ?>>
<head>

	<meta charset="<?php bloginfo('charset'); ?>">

	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<?php wp_head(); ?>

</head>
<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>

<div id="ip-container" class="ip-container">
	<!-- initial loader -->
	<div class="ip-header">

		<?php $custom_logo = get_post_meta($wp_query->get_queried_object_id(), '_royarch_custom_logo', true) ?>
        <?php 
            $custom_logo_id = get_theme_mod( 'custom_logo' );
        ?>
        
        <p class="ip-logo">
            <?php if($custom_logo!=''){ ?>
                <img src="<?php echo esc_url($custom_logo); ?>" alt="<?php bloginfo('name'); ?>">
            <?php }elseif($custom_logo_id!=''){ ?>
                <?php $image = wp_get_attachment_image_src( $custom_logo_id , 'full' ); ?>
                <img src="<?php echo esc_url($image[0]); ?>" alt="<?php bloginfo('name'); ?>" />
            <?php }else{  ?>
                <?php bloginfo('name'); ?>
            <?php } ?>
        </p>

		<div class="ip-loader">
			<svg class="ip-inner" width="100px" height="100px" viewBox="0 0 80 80">
				<path class="ip-loader-circlebg" d="M40,10C57.351,10,71,23.649,71,40.5S57.351,71,40.5,71 S10,57.351,10,40.5S23.649,10,40.5,10z"/>
				<path id="ip-loader-circle" class="ip-loader-circle" d="M40,10C57.351,10,71,23.649,71,40.5S57.351,71,40.5,71 S10,57.351,10,40.5S23.649,10,40.5,10z"/>
			</svg>
		</div>

	</div>

	<!-- Container -->
	<div id="container">

	<?php
	
	get_template_part( 'template-parts/header/header' ); ?>

	