<?php 


/**
 * Display custom color CSS.
 */
function royarch_colors_css_wrap() {
  global  $wp_query;
  $main_color = get_theme_mod( 'main_color','#d92828');
  $logo_dimensions = get_theme_mod('logo_dimensions');
?>

<style type="text/css" id="custom-theme-colors">
 <?php 
  $css="
    header .header-line a.open-menu-toggle,
    header .header-line div.social-line ul.social-list li a:hover,
    header .nav-menu-box ul.navigation-menu-list > li > a span:after,
    a.button-one:before,
    a.theme-button:before,
    section.error-section span,
    section.error-section a:hover,
    .not-found-title a:hover,
    ul.meta-list li a i,
    section.filter-section ul.filter li a.active:before,
    .contact-form-box #contact-form button:hover,
    .contact-form-box #contact-form input[type=submit]:hover,
    section.features-carousel-section .feature-post .feature-post-content span:before,
    .features-section2 .feature-content span:after,
    section.architecture-section .architecture-box .architecture-post .hover-box .cat-link:before,
    section.scroller-section2 .scroller-post .hover-box .cat-link:before,
    section.scroller-section3 .owl-carousel .owl-nav button,
    section.scroller-section3 .owl-carousel .owl-nav button:hover,
    section.scroller-section4 a.scroller-post .cont-holder span.cat-link:before,
    section.slider-section.fullscreen-style .tp-caption.NotGeneric-SubTitle span:before,
    section.slider-section.fullscreen-style .tp-caption.NotGeneric-SubTitle a:hover,
    section.slider-section.fullscreen-style .tp-bullets .tp-bullet.selected,
    section.slider-section .tp-bannertimer,
    section.slider-section .tp-caption.NotGeneric-SubTitle span,
    section.slider-section .tparrows:hover,
    #rev_slider_41_1_wrapper .tparrows,
    #rev_slider_6_1_wrapper .gyges.tp-bullets .tp-bullet.selected,
    .layer-stroke-before:before,
    .FoodCarousel-CloseButton,
    section.team-section .team-post .hover-team ul.social-team li a:hover,
    section.team-section .team-post .hover-team h3:before,
    section.team-section .team-post .hover-team h3:after,
    section.tabs-collapse-section .nav-tabs li button:hover,
    section.tabs-collapse-section .accordion-button:not(.collapsed) i,
    .sidebar .sidebar-widget > h4:after, .sidebar .sidebar-widget > h3:after,
    .sidebar .sidebar-widget.widget_categories ul li a span, .sidebar .sidebar-widget.widget_archive ul li a span,
    .sidebar .sidebar-widget.widget_categories ul li:before, .sidebar .sidebar-widget.widget_archive ul li:before,
    .sidebar .sidebar-widget .tagcloud a:hover,
    .sidebar .sidebar-widget .popular-widget ul li .side-content span:before,
    section.single-post-section .post-content p span.dropcap,
    section.single-post-section .post-content .author-box:before,
    .comments-box ul.comments-list li .comment-box .image-holder:before,
    .comments-box ul.comments-list li .comment-box .image-holder:after,
    .comments-box ul.comments-list li .comment-box a.reply:hover,
    .comments-box ul.comments-list li .comment-box a.comment-reply-link:hover,
    #comment-form input[type=submit]:hover,
    #respond input[type=submit]:hover,
    .hover-feature h2,
    section.services-section .services-box .services-post:hover i,
    section.services-section2 .services-box2 .services-post2:hover span,
    section.services-section2 .services-box2 .services-post2:hover i,
    section.services-section4 .services-box4 .services-post4:hover span,
    section.services-section4 .services-box4 .services-post4:hover i,
    section.services-section5 .services-box5 .services-post5:hover span,
    section.services-section5 .services-box5 .services-post5:hover i,
    section.services-section6 .services-box6 .services-post6:hover div.icon,
    section.services-section6 .image-holder a.serv-link:hover,
    section.services-section7 .services-box7 a.services-post7:hover:before,
    section.services-section8 .services-post8:hover .serv-cont a,
    section.services-section9 .services-box9 .services-post9:hover div.icon,
    a.go-top,
    .royarch_loadmore,
    .royarch_loadmore:hover,
    .mc4wp-form-fields input[type='submit'],
    .lang-item.current-lang a,
    .single-post-box ul.wp-block-archives li a:before,
    .single-post-box ul.wp-block-latest-posts li a:before,
    .wp-block-search button[type='submit'],
    .post-password-form input[type='submit'],
    p.post-nav-links span.current,
    table td#today,
    table.wp-calendar-table thead th {
      background-color: $main_color;
    }
    .ip-header .ip-loader svg path.ip-loader-circle {
      stroke: $main_color;
    }
    ul.pagination-list li a.current, ul.pagination-list li span.current,
    ul.page-numbers li a.current,
    ul.page-numbers li span.current {
      border-bottom: 5px solid $main_color;
    }
    .portfolio-post figure.hover2 figcaption > a {
      border: 5px solid $main_color;
    }
    .sidebar .sidebar-widget form#searchform input[type=text] {
      border-left: 3px solid $main_color;
    }
    section.single-post-section .post-content blockquote {
      border-left: 5px solid $main_color;
    }
    .bypostauthor .image-holder {
      border: 2px solid $main_color;
    }
    table.wp-calendar-table thead th {
      border-top: 1px solid $main_color;
    }
    table.wp-calendar-table thead th:first-child {
      border-left: 1px solid $main_color;
    }
    table.wp-calendar-table thead th:last-child {
      border-right: 1px solid $main_color;
    }
  "; 
  if($logo_dimensions){
    $css .="
      .navbar-brand img,
      .mobile-menu .logo-brand img {
        max-width: ".$logo_dimensions['max-width'].";
      }
    ";
  }
  echo do_shortcode($css);
?>
</style>
<?php }
add_action( 'wp_head', 'royarch_colors_css_wrap' );

/*
Register Fonts
*/


if ( ! function_exists( 'royarch_get_google_fonts_url' ) ) {
  /**
   * Load/Get Google Fonts Url
   */
  function royarch_google_fonts_url( $fonts ) {
    $font_url = '';

    $font_url = add_query_arg( 'family', urlencode( $fonts ), "//fonts.googleapis.com/css" );

    return $font_url;
  }
}

/**
 * Enqueue google fonts
 */
function royarch_enqueue_google_fonts() {
  $body_google_fonts = 'Montserrat:100,200,300,400,500,600,700';
  $secondary_google_fonts = 'Rubik:300,400,600,700';

  wp_enqueue_style( 'royarch-font-Montserrat', royarch_google_fonts_url( $body_google_fonts ), array(), '1.0.0' );
  wp_enqueue_style( 'royarch-font-Rubik', royarch_google_fonts_url( $secondary_google_fonts ), array(), '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'royarch_enqueue_google_fonts', 10000 );



