<?php 

$elementor_page_active = null;

if ( defined( 'ELEMENTOR_VERSION' ) ) {
    $elementor_page_active = \Elementor\Plugin::$instance->db->is_built_with_elementor(get_the_ID());
}

$image = get_theme_mod( 'image_setting_url', '' );
$title = get_post_meta($wp_query->get_queried_object_id(), "_royarch_banner_title", true);
$subtitle = get_post_meta($wp_query->get_queried_object_id(), "_royarch_banner_subtitle", true);
$hidePageBanner = get_post_meta($wp_query->get_queried_object_id(), "_royarch_banner_hide", true);

get_header();

if ( !$hidePageBanner ) : ?>
            
    <!-- page-banner-section 
        ================================================== -->
    <section class="page-banner-section">
        <div class="container">
            <?php if($title) { ?>
                <h1>
                    <?php echo esc_html($title); ?>
                </h1>
            <?php } else {?>
                <h1><?php the_title(); ?></h1>
            <?php }

            if($subtitle) { ?>
                <p>
                    <?php echo esc_html($subtitle); ?>
                </p>

            <?php } ?>
        </div>
        <?php if ( $image ){ ?>
            <div class="image-holder">
                <img src="<?php echo esc_url( $image ); ?>" alt>
            </div>
        <?php } ?>
    </section>
    <!-- End page-banner section --> 

<?php endif;

if($elementor_page_active) {

    the_content();

} else {

    while ( have_posts() ) : the_post(); ?>

    <div class="static-page">
        <div class="container">
            <?php
                the_content();
                wp_link_pages();
            ?>
            <?php if ( comments_open() || get_comments_number() ) {  ?>
                <?php comments_template(); ?>   
            <?php } ?>
            
        </div>
    </div>

    <?php endwhile;

}

get_footer();

?>