<?php 

$facebook = get_theme_mod('facebook');
$twitter = get_theme_mod('twitter');
$linkedin = get_theme_mod('linkedin');
$instagram = get_theme_mod('instagram');
$google = get_theme_mod('google');
$youtube = get_theme_mod('youtube');
$pinterest = get_theme_mod('pinterest');
$dribble = get_theme_mod('dribble');
$github = get_theme_mod('github');
$hideContactInfo = get_post_meta($wp_query->get_queried_object_id(), "_royarch_contact_info_hide", true);

?>

    <!-- Header
            ================================================== -->
        <header class="clearfix">

            <div class="logo">
                <?php $custom_logo = get_post_meta($wp_query->get_queried_object_id(), '_royarch_custom_logo', true) ?>

                <?php 
                    $custom_logo_id = get_theme_mod( 'custom_logo' );
                ?>
                <a href="<?php echo esc_url(home_url('/')); ?>" title="<?php bloginfo('name'); ?>">
                    <?php if($custom_logo!=''){ ?>
                        <img src="<?php echo esc_url($custom_logo); ?>" alt="<?php bloginfo('name'); ?>">
                    <?php }elseif($custom_logo_id!=''){ ?>
                        <?php $image = wp_get_attachment_image_src( $custom_logo_id , 'full' ); ?>
                        <img src="<?php echo esc_url($image[0]); ?>" alt="<?php bloginfo('name'); ?>" />
                    <?php }else{  ?>
                        <?php bloginfo('name'); ?>
                    <?php } ?>
                </a>
            </div>

            <div class="header-line">
                <a class="open-menu-toggle" href="#">
                    <span></span>
                    <span></span>
                    <span></span>
                </a>
                <div class="social-line">
                <?php if ( true == get_theme_mod( 'switch_socials' ) ) : ?>
                    <ul class="social-list">
                        <?php
                            if ($linkedin != '') { ?>
                                <li><a href="<?php echo esc_url($linkedin); ?>"><i class="fab fa-linkedin-in"></i></a></li>
                            <?php }

                            if ($twitter != '') { ?>
                                <li><a href="<?php echo esc_url($twitter); ?>"><i class="fab fa-twitter-square"></i></a></li>
                            <?php }

                            if ($facebook != '') { ?>
                                <li><a href="<?php echo esc_url($facebook); ?>"><i class="fab fa-facebook-square"></i></a></li>
                            <?php }

                            if ($instagram != '') { ?>
                                <li><a href="<?php echo esc_url($instagram); ?>"><i class="fab fa-instagram"></i></a></li>
                            <?php } 

                            if ($google != '') { ?>
                                <li><a href="<?php echo esc_url($google); ?>">
                                    <i class="fab fa-google-plus-g"></i>
                                </a></li>
                            <?php } 
                
                            if ($youtube != '') { ?>
                                <li><a href="<?php echo esc_url($youtube); ?>">
                                    <i class="fab fa-youtube"></i>
                                </a></li>
                            <?php } 
                
                            if ($pinterest != '') { ?>
                                <li><a href="<?php echo esc_url($pinterest); ?>">
                                    <i class="fab fa-pinterest-p"></i>
                                </a></li>
                            <?php } 
                
                            if ($dribble != '') { ?>
                                <li><a href="<?php echo esc_url($dribble); ?>">
                                    <i class="fab fa-dribbble"></i>
                                </a></li>
                            <?php } 
                
                            if ($github != '') { ?>
                                <li><a href="<?php echo esc_url($github); ?>">
                                    <i class="fab fa-github"></i>
                                </a></li>
                            <?php } 
                        ?>
                    </ul>
                <?php endif; ?>
                </div>
                <div class="copyright-line">
                    <p>
                        <?php 
                            $copyright = get_theme_mod('copyright');
                            if ($copyright != '') {
                                echo esc_html($copyright);
                            } else {
                                esc_html_e('© Royarch 2021', 'royarch');
                            }
                        ?>
                    </p>
                </div>
            </div>

            <nav class="nav-menu-box">
                <?php
                    wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'menu'            => '',
                        'container'       => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'link_before' => '<span><em>',     
                        'link_after'  => '</em></span>',
                        'menu_class' => 'navigation-menu-list',
                        'depth'           => 0
                    ));
                ?>
            </nav>

        </header>
        <!-- End Header -->

        <div id="content">
            <?php if ( true == get_theme_mod( 'switch_info' ) ) : ?>
            <?php if ( !$hideContactInfo ) : ?>
            <div class="info-box">
                <p>
                    <i class="fa fa-phone-square"></i>
                    <?php 
                        $phone_number = get_theme_mod('phone_number');
                        if ($phone_number != '') {
                            echo esc_html($phone_number);
                        }
                    ?>
                    <span class="divider-line"></span>

                    <i class="fa fa-envelope-square"></i>
                    <?php 
                        $email_address = get_theme_mod('email');
                        if ($email_address != '') {
                            echo esc_html($email_address);
                        }
                    ?>
                </p>
            </div>
            <?php endif;
            endif;
