<?php 

    $image = get_theme_mod( 'image_setting_url', '' );
    $archiveDesc = get_theme_mod( 'archive_description', '' ); 
        
?>

            
        <!-- page-banner-section 
            ================================================== -->
        <section class="page-banner-section">
            <div class="container">
                <h1>
                    <?php the_title(); ?>
                </h1>
                <p><?php echo esc_html($archiveDesc); ?></p>
                
            </div>
            <?php if ( $image ){ ?>
                <div class="image-holder">
                    <img src="<?php echo esc_url( $image ); ?>" alt>
                </div>
            <?php } ?>
        </section>
        <!-- End page-banner section -->



        <!-- single-post-section 
			================================================== -->
        <section class="single-post-section <?php post_class(); ?>">
            <div class="container">
                <div class="row">
                    <?php if(is_active_sidebar('sidebar')){ ?>
                        <div class="col-lg-8">
                    <?php }else{ ?>
                        <div class="col-lg-12 no-sidebar">
                    <?php } ?>
                        <div class="post-content">
                                
                            <div class="post-thumbnail">
                                <?php the_post_thumbnail(); ?>
                            </div>

                            <ul class="meta-list">
                                <?php
                                    $categories = get_the_category();
                                    if ( ! empty( $categories ) ) { ?>
                                        <li>
                                            <a href="<?php echo esc_url( get_category_link( $categories[0]->term_id ) )?>">
                                                <i class="far fa-folder-open"></i>
                                                <?php echo esc_html( $categories[0]->name ); ?>
                                            </a>
                                        </li>
                                    <?php }
                                ?>
                                <li>
                                    <a href="#">
                                        <i class="far fa-clock"></i>
                                        <?php echo get_the_date(); ?>
                                    </a>
                                </li>
                            </ul>

                            <div class="post-content-txt">
                                <?php 
                                    the_content(); 
                                    wp_link_pages();
                                ?>
                            </div>

                            <?php
                                $tags = get_the_tags();
                                if ( $tags ) : ?>

                                <div class="tags-list">
                                    <ul class="post-tags">
                                        <li><span class="tags-title"><?php esc_html_e('Tags:', 'royarch'); ?></span></li>
                                        <?php
                                        foreach ( $tags as $tag ) : ?>
                                            <li><a href="<?php echo esc_url( get_tag_link( $tag->term_id ) ); ?>" title="<?php echo esc_attr( $tag->name ); ?>"><?php echo esc_html( $tag->name ); ?></a></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                                

                            <?php
                                $user_info = get_userdata(1);
						        if (!empty (get_the_author_meta( 'description' ))) { ?>
                                    <div class="author-box">
                                        <div class="image-holder">
                                            <?php echo get_avatar( get_the_author_meta( 'ID' ), 140 ); ?>
                                        </div>
                                        <div class="author-content">
                                            <h4>
                                                <?php esc_html_e('About author', 'royarch'); ?>
                                            </h4>
                                            <p><?php the_author_meta('description'); ?></p>
                                        </div>
                                    </div>
                                <?php }
                            ?>
                            
                            <?php if ( comments_open() || get_comments_number() ) {  ?>
                                <?php comments_template(); ?>
                            <?php } ?>

                        </div>
                    </div>
                    <?php if(is_active_sidebar('sidebar')){ ?>
                        <div class="col-lg-4">
                            
                            <?php get_sidebar(); ?>

                        </div>
                    <?php } ?>
                </div>
            </div>
		</section>
		<!-- End single section -->