<?php 

if( !defined( 'ABSPATH' ) ) exit();

if( !class_exists( 'OVA_Apartments_custom_post_type' ) ) {

	class OVA_Apartments_custom_post_type{

		public function __construct(){
			add_action( 'init', array( $this, 'ova_register_cpt' ) );	
		}
		
		function ova_register_cpt() {

			$labels = array(
				'name'                  => _x( 'Apartments', 'Post Type General Name', 'ova-framework' ),
				'singular_name'         => _x( 'Apartment', 'Post Type Singular Name', 'ova-framework' ),
				'menu_name'             => __( 'Apartment', 'ova-framework' ),
				'name_admin_bar'        => __( 'Apartment', 'ova-framework' ),
				'archives'              => __( 'Item Archives', 'ova-framework' ),
				'attributes'            => __( 'Item Attributes', 'ova-framework' ),
				'parent_item_colon'     => __( 'Parent Item:', 'ova-framework' ),
				'all_items'             => __( 'All Apartments', 'ova-framework' ),
				'add_new_item'          => __( 'Add New Apartment', 'ova-framework' ),
				'add_new'               => __( 'Add New', 'ova-framework' ),
				'new_item'              => __( 'New Item', 'ova-framework' ),
				'edit_item'             => __( 'Edit Apartment', 'ova-framework' ),
				'view_item'             => __( 'View Item', 'ova-framework' ),
				'view_items'            => __( 'View Items', 'ova-framework' ),
				'search_items'          => __( 'Search Item', 'ova-framework' ),
				'not_found'             => __( 'Not found', 'ova-framework' ),
				'not_found_in_trash'    => __( 'Not found in Trash', 'ova-framework' ),
			);

			$args = array(
				'description'         => __( 'Post Type Description', 'ova-framework' ),
				'labels'              => $labels,
				'supports'            => array( 'title','excerpt', 'editor', 'comments', 'thumbnail' ),
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'menu_position'       => 5,
				'query_var'           => true,
				'has_archive'         => true,
				'exclude_from_search' => true,
				'publicly_queryable'  => true,
				'rewrite'             => array( 'slug' => _x( 'ova_apartments', 'URL slug', 'ova-framework' ) ),
				'capability_type'     => 'post',
				'menu_icon'           => 'dashicons-building'
			);

			register_post_type( 'ova_apartments', $args );


			$labels_cat = array(
				'name'                       => _x( 'Categories Apartment', 'Post Category General Name', 'ova-framework' ),
				'singular_name'              => _x( 'Category', 'Post Category Singular Name', 'ova-framework' ),
				'menu_name'                  => __( 'Categories', 'ova-framework' ),
				'all_items'                  => __( 'All Categoies', 'ova-framework' ),
				'parent_item'                => __( 'Parent Item', 'ova-framework' ),
				'parent_item_colon'          => __( 'Parent Item:', 'ova-framework' ),
				'new_item_name'              => __( 'New Item Name', 'ova-framework' ),
				'add_new_item'               => __( 'Add New Category', 'ova-framework' ),
				'add_new'                    => __( 'Add New Category', 'ova-framework' ),
				'edit_item'                  => __( 'Edit Category', 'ova-framework' ),
				'view_item'                  => __( 'View Item', 'ova-framework' ),
				'separate_items_with_commas' => __( 'Separate items with commas', 'ova-framework' ),
				'add_or_remove_items'        => __( 'Add or remove items', 'ova-framework' ),
				'choose_from_most_used'      => __( 'Choose from the most used', 'ova-framework' ),
				'popular_items'              => __( 'Popular Items', 'ova-framework' ),
				'search_items'               => __( 'Search Items', 'ova-framework' ),
				'not_found'                  => __( 'Not Found', 'ova-framework' ),
				'no_terms'                   => __( 'No items', 'ova-framework' ),
				'items_list'                 => __( 'Items list', 'ova-framework' ),
				'items_list_navigation'      => __( 'Items list navigation', 'ova-framework' ),

			);
			$args_cat = array(
				'labels'            => $labels_cat,
				'hierarchical'      => true,
				'publicly_queryable' => true,
				'public'            => true,
				'show_ui'           => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud'     => false,
				'rewrite'            => array(
					'slug'       => _x( 'cat_apartments','Type Slug', 'ova-framework' ),
					'with_front' => false,
					'feeds'      => true,
				),
			);
			register_taxonomy( 'cat_apartments', array( 'ova_apartments' ), $args_cat );


		}
	}


	new OVA_Apartments_custom_post_type();
}