<?php
/*
Plugin Name: Barta Core
Plugin URI: https://www.radiustheme.com
Description: Barta Core Plugin for Barta Theme
Version: 2.0.2
Author: RadiusTheme
Author URI: https://www.radiustheme.com
*/

if (! defined('ABSPATH')) {
    exit;
}

define('BARTA_CORE_UPDATE_1', true);

if (! defined('BARTA_CORE')) {
    define('BARTA_CORE', ( WP_DEBUG ) ? time() : '1.0');
    define('BARTA_CORE_THEME_PREFIX', 'barta');
    define('BARTA_CORE_THEME_PREFIX_VAR', 'barta');
    define('BARTA_CORE_CPT_PREFIX', 'barta');
}

if (class_exists('ReduxFrameworkPlugin')) {
    $blog_star_rating = get_option('barta')['blog_star_rating'];
}

class Barta_Core
{

    public $plugin  = 'barta-core';
    public $action  = 'barta_theme_init';
    public $blog_star_rating = null;

    public function __construct($blog_star_rating)
    {
        $prefix = BARTA_CORE_THEME_PREFIX_VAR;
        $this->$blog_star_rating = $blog_star_rating;
        add_action('plugins_loaded', array( $this, 'demo_importer' ), 15);
        add_action('plugins_loaded', array( $this, 'load_textdomain' ), 16);
        add_action('after_setup_theme', array( $this, 'post_meta' ), 15);
        add_action('after_setup_theme', array( $this, 'elementor_widgets' ));

        // Redux Flash permalink after options changed
        add_action("redux/options/{$prefix}/saved", array( $this, 'flush_redux_saved' ), 10, 2);
        add_action("redux/options/{$prefix}/section/reset", array( $this, 'flush_redux_reset' ));
        add_action("redux/options/{$prefix}/reset", array( $this, 'flush_redux_reset' ));
        add_action('init', array( $this, 'rewrite_flush_check' ));
        add_action('redux/loaded', array( $this, 'barta_remove_demo'));

        //$get_theme_options = get_option('barta');
        if ( $this->$blog_star_rating == 1  ) {
            /*For star rating sysytem*/
            add_action('wp_enqueue_scripts', array( $this ,'barta_rating_css_enqueue_script'));
            add_action('comment_form_top', array( $this , 'barta_change_comment_form_defaults' ));
            add_action('comment_post', array( $this , 'barta_save_comment_meta_data' ));
        }
        require_once 'module/rt-post-share.php';
        require_once 'module/rt-post-length.php';
        require_once 'module/rt-post-views.php';

        /*Optimizer*/
        require_once 'optimization/__init__.php';

        /*widget*/
        require_once 'widgets/widget-settings.php';
        require_once 'widgets/rt-widget-fields.php';
        require_once 'widgets/rt-recent-post-widget.php';
        require_once 'widgets/rt-news-box.php';
        require_once 'widgets/rt-news-tab.php';
        require_once 'widgets/address-widget.php';
        require_once 'widgets/social-widget.php';
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
    */
    public function barta_remove_demo()
    {
        // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
        if (class_exists('ReduxFrameworkPlugin')) {
            remove_filter('plugin_row_meta', array(
                ReduxFrameworkPlugin::instance(),
                'plugin_metalinks'
                ), null, 2);

            // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
            remove_action('admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ));
        }
    }

    public function demo_importer()
    {
        require_once 'demo-importer.php';
    }
    public function load_textdomain()
    {
        load_plugin_textdomain($this->plugin, false, dirname(plugin_basename(__FILE__)) . '/languages');
    }
    public function post_meta()
    {
        if (!did_action($this->action) || ! defined('RT_FRAMEWORK_VERSION')) {
            return;
        }
        require_once 'post-meta.php';
    }
    public function elementor_widgets()
    {
        if (did_action($this->action) && did_action('elementor/loaded')) {
            require_once 'elementor/init.php';
        }
    }
    public function get_base_url()
    {

        $file = dirname(dirname(__FILE__));

        // Get correct URL and path to wp-content
        $content_url = untrailingslashit(dirname(dirname(get_stylesheet_directory_uri())));
        $content_dir = untrailingslashit(WP_CONTENT_DIR);

        // Fix path on Windows
        $file = wp_normalize_path($file);
        $content_dir = wp_normalize_path($content_dir);

        $url = str_replace($content_dir, $content_url, $file);

        return $url;
    }

    // Flush rewrites
    public function flush_redux_saved($saved_options, $changed_options)
    {
        if (empty($changed_options)) {
            return;
        }
        $prefix = BARTA_CORE_THEME_PREFIX_VAR;
        $flush  = false;

        if ($flush) {
            update_option("{$prefix}_rewrite_flash", true);
        }
    }

    public function flush_redux_reset()
    {
        $prefix = BARTA_CORE_THEME_PREFIX_VAR;
        update_option("{$prefix}_rewrite_flash", true);
    }

    public function rewrite_flush_check()
    {
        $prefix = BARTA_CORE_THEME_PREFIX_VAR;
        if (get_option("{$prefix}_rewrite_flash") == true) {
            flush_rewrite_rules();
            update_option("{$prefix}_rewrite_flash", false);
        }
    }


    public function barta_change_comment_form_defaults()
    {
        global $check;
        global $wpdb;

        /* get rating value from database */
        $ratingValues = $wpdb->get_results("SELECT meta_value FROM ".$wpdb->prefix."commentmeta WHERE meta_key = 'rating'");

        echo '
			<fieldset class="rating">
				<input type="radio" id="star5" name="rating" value="5" /><label class = "full" for="star5" title="Awesome - 5 stars"></label>
				<input type="radio" id="star4" name="rating" value="4" /><label class = "full" for="star4" title="Pretty good - 4 stars"></label>
				<input type="radio" id="star3" name="rating" value="3" /><label class = "full" for="star3" title="Avarage - 3 stars"></label>
				<input type="radio" id="star2" name="rating" value="2" /><label class = "full" for="star2" title="Need Improvment - 2 stars"></label>
				<input type="radio" id="star1" name="rating" value="1" /><label class = "full" for="star1" title="Bad - 1 star"></label>
			</fieldset>
			';
    }
    public function barta_rating_css_enqueue_script()
    {
        wp_enqueue_style('rating-css', plugin_dir_url(__FILE__) . 'assets/css/rating.css');
        wp_enqueue_script('jquery-ui-sortable');
        wp_enqueue_script('core-js', plugin_dir_url(__FILE__) . 'assets/js/core-js.js', array( 'jquery' ), 1.0, true);
        wp_enqueue_script('snap.svg-min', plugin_dir_url(__FILE__) . 'assets/js/snap.svg-min.js', array( 'jquery' ), 1.0, true);
        wp_enqueue_script('barta-hovers', plugin_dir_url(__FILE__) . 'assets/js/hovers.js', array( 'jquery' ), 1.0, true);
    }

    /* save comment meta data */
    public function barta_save_comment_meta_data($comment_id)
    {
        $rating =  (empty($_POST['rating'])) ? false : $_POST['rating'];
        add_comment_meta($comment_id, 'barta_rating', $rating);
    }
}

new Barta_Core( $blog_star_rating ?? null );
