<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use BartaTheme;
use BartaTheme_Helper;

use \WP_Query;

$thumb_size = 'barta-size2';

if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}
?>
<div class="gallery-default <?php echo esc_attr( $template ); ?> zoom-gallery">
	<div class="row">
	<?php if ( $data['has_sec_title'] == 'yes' ) { ?>
		<div class="col-12 mb-25p">
			<div class="rt-news-box-title-holder <?php echo esc_attr( $data['title_style'] ); ?>">
				<h2 class="el-rt-news-box-title <?php echo esc_attr( $data['title_style'] ); ?>"><?php echo esc_html( $data['title'] ); ?><span class="titleinner"></span></h2>
			</div>
		</div>
	<?php } ?>
		
	<?php
		/*query process*/
		// category
		$category = $data['cat_multi_grid'];
		// number
		$number_of_post = $data['number_of_post'];
		// sort
		$post_sorting = $data['post_sorting'];
		// order
		$post_ordering = $data['post_ordering'];
		// Title Limit
		$title_limit = $data['post_title_length'];
		
		$args = array(
			'cat' => $category,
			'post_status' => 'publish',
			'order' => $post_ordering,
			'posts_per_page' => $number_of_post,
			'paged'          => $paged,
		);
			
		if ( $post_sorting == 'view' ) {
			$args['orderby']  = 'meta_value_num';
			$args['meta_key'] = 'barta_views';
		} else {
			$args['orderby'] = $post_sorting;
		}
		
		$query = new WP_Query( $args );
		
		$temp = BartaTheme_Helper::wp_set_temp_query( $query );
		
		if ( $query->have_posts() ) { 
			while ( $query->have_posts() ) {
			$query->the_post();
			$news_title = wp_trim_words(get_the_title(), $title_limit, '');
			$news_comment_num = number_format_i18n( get_comments_number() );
		?>
			<div class="col-lg-4 col-md-6 col-sm-6 col-12">
				<div class="gallery-item">
					<?php if ( $data['show_post_thumb'] == 'yes' ) { ?>
					<div class="gallery-item-img  img-overlay-hover">
						<a href="<?php the_permalink(); ?>">
							<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( $thumb_size, ['class' => 'img-fluid mb-10 width-100'] );
								} else {
									if ( $data['show_no_preview_img'] == 'yes') {
									
										if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
											echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size );
										} else {
											echo '<img class="width-100 wp-post-image" src="' . BartaTheme_Helper::get_img( 'noimage-598x487.jpg' ) . '" alt="'.get_the_title().'">';
										}
									}
								}
							?>
						</a>
						<a href="<?php echo wp_get_attachment_url( get_post_thumbnail_id() ); ?>" class="ne-zoom img-popup-icon" title="<?php echo get_the_title(); ?>">
							<i class="fa fa-plus" aria-hidden="true"></i>
						</a>
						
						<?php if ( $data['cat_display'] == 'yes' ) { echo barta_sel_category_prepare( $category ); } ?>
						<?php  ?>
					</div>
					<?php } ?>
					<div class="post-meta-dark">
						<ul>
							<?php if ( $data['post_author'] == 'yes') { ?>
								<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link(); ?></li>
							<?php } ?>
							<?php if ( $data['post_date'] == 'yes' ) { ?>
								<li><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo $formatted_post_date; ?></li>
							<?php } ?>
							<?php if ( $data['post_comment'] == 'yes' ) { ?>
								<li><span><i class="fa fa-comment-o" aria-hidden="true"></i></span><a href="<?php echo get_comments_link( get_the_ID() ); ?>"> <?php echo esc_html( $news_comment_num );?></a></li>
							<?php } ?>
						</ul>
					</div>
					<?php if ( $data['post_title'] == 'yes') { ?>
					<h3 class="title-semibold-dark">
						<a href="<?php the_permalink(); ?>"><?php echo esc_html( $news_title ); ?></a>
					</h3>
					<?php } ?>
				</div>
			</div>
			<?php } ?>	
				<?php if ( $data['pagination_display'] == 'yes' ) { ?>
					<div class="mt20 col-sm-12 col-xs-12 pagination-wrapper"><?php BartaTheme_Helper::pagination(); ?></div>
				<?php } ?>
		<?php } else { ?>
			<div class="col-lg-12 col-sm-12 col-12"><?php esc_html_e( 'No Post/News Found', 'barta-core' ); ?></div>
		<?php } ?>
	<?php BartaTheme_Helper::wp_reset_temp_query( $temp ); ?>
	</div>
</div>