<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use BartaTheme;
use BartaTheme_Helper;
use \WP_Query;

if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}

// build up the array
foreach ( $data['category_list'] as $cat ) {
	$cats[] = array(
		'cat_single_tab' => $cat['cat_single_tab'],
	);
}
?>

<div class="tab-default <?php echo esc_attr( $template ); ?> <?php echo esc_attr( $data['small_item_style'] ); ?>">
	<div class="mb-20-r rtin-tab-container">
		<?php if ( $data['has_sec_title'] == 'yes' ) { ?>
			<div class="topic-border color-cinnabar">
				<div class="mb-25p">
					<div class="rt-news-box-title-holder <?php echo esc_attr( $data['title_style'] ); ?>">
						<h2 class="el-rt-news-box-title <?php echo esc_attr( $data['title_style'] ); ?>"><?php echo esc_html( $data['title'] ); ?><span class="titleinner"></span></h2>
						<div class="barta-tab-cat" data-settings='<?php echo json_encode( $data ); ?>' data-template="<?php echo esc_attr( $template ); ?>">
						<ul>
							<?php
							if ( !empty( $cats ) ) {
							//category
								$count_cat=1;
								foreach ( $cats as $cat ) {
								if ( $cat['cat_single_tab'] != 0 ) {
							?>
							<li <?php if ( $count_cat==1 ) { ?>class="active"<?php } ?>><span data-tab-cat="<?php echo esc_attr( $cat['cat_single_tab'] ); ?>" data-post-num="<?php echo esc_attr( $data['number_of_post'] ); ?>" data-sorting="<?php echo esc_attr( $data['post_sorting'] ); ?>" data-ordering="<?php echo esc_attr( $data['post_ordering'] ); ?>" data-title-length="<?php echo esc_attr( $data['post_title_length'] ); ?>"><?php echo esc_attr( get_cat_name( $cat['cat_single_tab'] ) ); ?></span></li>
							<?php $count_cat++; } } ?>
							
							<li><div class="more-link" ><a href="<?php echo get_category_link( $cats[0]['cat_single_tab'] ); ?>"><?php esc_html_e( 'More' , 'barta-core'); ?><i class="fa fa-angle-right" aria-hidden="true"></i></a></div></li>
							
							<?php  } ?>
						</ul>
						</div>
					</div>
				</div>
			</div>
		<?php } ?>

		<div class="rt-tab-news-holder">
			<?php
			if ( !empty ( $cats[0]['cat_single_tab'] ) ) {
				$category = $cats[0]['cat_single_tab'];			
			} else {
				$category = 1;
			}
			// number
			$number_of_post = $data['number_of_post'];
			$number_of_post_offset = $data['number_of_post_offset'];
			$p_ids = array();
			
			// build up the array
			foreach ( $data['posts_not_in'] as $p_idsn ) {
				$p_ids[] = $p_idsn['post_not_in'];
			}

			// sort
			$post_sorting = $data['post_sorting'];
			// order
			$post_ordering = $data['post_ordering'];
			// Title Limit
			$title_limit = $data['post_title_length'];
			// Content Limit
			$content_limit = $data['post_excerpt_length'];
			
			$args = array(
				'cat' => $category,
				'post_status' => 'publish',
				'order' => $post_ordering,
				'posts_per_page' => $number_of_post,
				'paged'          => $paged,
				'offset' 	 	 => $number_of_post_offset,
				'post__not_in'   => $p_ids
			);				
			if ( $post_sorting == 'view' ) {
				$args['orderby']  = 'meta_value_num';
				$args['meta_key'] = 'barta_views';
			} else {
				$args['orderby'] = $post_sorting;
			}
			$query = new WP_Query( $args ); ?>
			
			<div class="blockHalf2">
			<?php include( plugin_dir_path( __DIR__ ) . '/query/query-rt-tab-5.php' ); ?>
			</div>
			<div class="loading"></div>
		</div>
	</div>
</div>