<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;
 
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Base;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_News_Gallery extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT News Gallery', 'barta-core' );
		$this->rt_base = 'rt-news-gallery';
		parent::__construct( $data, $args );
	}
	
	private function rt_load_scripts(){
		wp_enqueue_style(  'magnific-popup' );
		wp_enqueue_script( 'magnific-popup' );
	}
	
	public function rt_fields(){
		
		$terms  = get_terms( array( 'taxonomy' => 'category', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'All Categories', 'barta-core' ) );

		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}		
		
		$fields = array(		
			
			/*News Box Style*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'News Gallery Style', 'barta-core' ),
			),
			/*Gallery style option*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout_gallery',
				'label'   => __( 'Gallery Layout Style', 'barta-core' ),
				'options' => array(
					/*Gallery Layout*/
					'gallery1' => __( 'Gallery Layout 1' , 'barta-core' ),
					'gallery2' => __( 'Gallery Layout 2' , 'barta-core' ),
				),
				'default' => 'gallery1',
			),
			/*box title*/
			array(
				'label'			=> esc_html__( 'Show Title', 'barta-core' ),
				'type'  		=> Controls_Manager::SWITCHER,
				'id'			=> 'has_sec_title',
				'label_on'		=> esc_html__( 'Show', 'barta-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'barta-core' ),
				'return_value'	=> 'yes',
				'default'		=> 'yes',				
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => __( 'Section Title', 'barta-core' ),
				'default' => 'News',
				'condition' => array( 'has_sec_title' => array( 'yes' ) ),
			),			
			/*Title Style Option*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'title_style',
				'label'   => __( 'Section Title Style', 'barta-core' ),
				'options' => array(
					'style_1' => __( 'Style 1' , 'barta-core' ),
					'style_2' => __( 'style 2', 'barta-core' ),
				),
				'default' => 'style_2',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Section Title Color', 'barta-core' ),
				'default' => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .el-rt-news-box-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_bg_color',
				'label'   => __( 'Section Title Background Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array( 
					'{{WRAPPER}} .el-rt-news-box-title.style_2' => 'background: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_2 .titleinner' => 'border-top-color: {{VALUE}}',
					'{{WRAPPER}} .rt-news-box-title-holder' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1 .titleinner' => 'border-top-color: {{VALUE}}',									
				),
			),
			/*category select( Grid Multi )*/
			array(
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'cat_multi_grid',
				'label'     => __( 'Categories', 'barta-core' ),
				'options'   => $category_dropdown,
				'multiple'  => true,
				'default'   => '0',
			),
			/*category display option - switch*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'cat_display',
				'label'       => __( 'Category Name Display', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Number of post - With dependancy*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_of_post',
				'label'   => __( 'Number of Post', 'barta-core' ),
				'default' => '9',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color',
				'label'   => __( 'News Title Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array( 
					'{{WRAPPER}} .gallery-default h3.title-semibold-dark a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color_hover',
				'label'   => __( 'News Title Hover Color', 'barta-core' ),
				'default' => '#E53935',
				'selectors' => array( 
					'{{WRAPPER}} .gallery-default h3.title-semibold-dark a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .gallery-default .post-meta-dark ul li a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_date_color',
				'label'   => __( 'News Date Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array( 
					'{{WRAPPER}} .gallery-default .post-meta-dark' => 'color: {{VALUE}}',
					'{{WRAPPER}} .gallery-default .post-meta-dark ul li a' => 'color: {{VALUE}}',
				),
			),
			/*Featured Item title Style*/
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'      => 'grid_item_title_typo',
				'label'   => __( 'Item title Style', 'barta-core' ),
				'selector' => '{{WRAPPER}} .gallery-default h3',
			),
			array(
				'mode' => 'section_end',
			),
			/*Common Post Display & Query Options*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_query',
				'label'   => __( 'Common Post Display & Query Options', 'barta-core' ),
			),
			/*Post Sorting*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_sorting',
				'label'   => __( 'Post Sorting', 'barta-core' ),
				'options' => array(
					'recent' 		=> __( 'Recent Post', 'barta-core' ),
					'rand' 			=> __( 'Random Post', 'barta-core' ),
					'modified' 		=> __( 'Last Modified Post', 'barta-core' ),
					'comment_count' => __( 'Most commented Post', 'barta-core' ),
					'view' 			=> __( 'Most viewed Post', 'barta-core' ),
				),
				'default' => 'recent',
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_ordering',
				'label'   => __( 'Post Ordering', 'barta-core' ),
				'options' => array(
					'DESC'	=> __( 'Desecending', 'barta-core' ),
					'ASC'	=> __( 'Ascending', 'barta-core' ),
				),
				'default' => 'DESC',
			),
			/*Pagination - with dependancy*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'pagination_display',
				'label'       => __( 'Pagination Display', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'no',
			),
			/*Post Title Length*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_title_length',
				'label'   => __( 'Post Title Length e.g: 10', 'barta-core' ),
				'default' => '10',
			),
			array(				
				'id'  	=> 'hr',
				'type'	=> Controls_Manager::DIVIDER,				
				'style' => 'thick',
			),
			/*Display Post Title*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_title',
				'label'       => __( 'Display Post Title', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Display Post Date*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_date',
				'label'       => __( 'Display Post Date', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Display Post Autor*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_author',
				'label'       => __( 'Display Author Name', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),	
			/*Display Post Comment*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_comment',
				'label'       => __( 'Display Comment Number', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Hide Thumbnail*/			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_post_thumb',
				'label'       => __( 'Display Post Thumbnail', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			
			/*Show No Preview image*/			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_no_preview_img',
				'label'       => __( 'Show No Preview Image', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),			
			array(
				'mode' => 'section_end',
			),
			
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
			
			
			$this->rt_load_scripts();			
			
			switch ( $data['layout_gallery'] ) {
				case 'gallery2':
				$template = 'rt-news-gallery-2';
				break;
				default:
				$template = 'rt-news-gallery-1';
				break;
			}

		return $this->rt_template( $template, $data );
	}
}