<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\Barta_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Base;
if ( ! defined( 'ABSPATH' ) ) exit;

class RT_News_List extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT News List', 'barta-core' );
		$this->rt_base = 'rt-news-list';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		
		$terms  = get_terms( array( 'taxonomy' => 'category', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'All Categories', 'barta-core' ) );

		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}		
		
		$fields = array(
		
			/*News Box Style*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'News List Style', 'barta-core' ),
			),
			/*List style option*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout_list',
				'label'   => __( 'List Layout Style', 'barta-core' ),
				'options' => array(					
					'list1' => __( '01. 1 col, Small Image', 'barta-core' ),
					'list2' => __( '02. 1 col, Big Image ( Blog style 2 )', 'barta-core' ),
					'list3' => __( '03. 1 col, Left Image', 'barta-core' ),
				),
				'default' => 'list1',
			),
			/*box title*/
			array(
				'label'			=> esc_html__( 'Show Title', 'barta-core' ),
				'type'  		=> Controls_Manager::SWITCHER,
				'id'			=> 'has_sec_title',
				'label_on'		=> esc_html__( 'Show', 'barta-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'barta-core' ),
				'return_value'	=> 'yes',
				'default'		=> 'yes',				
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => __( 'Title', 'barta-core' ),
				'default' => 'News',
				'condition' => array( 'has_sec_title' => array( 'yes' ) ),
			),			
			/*Title Style Option*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'title_style',
				'label'   => __( 'Title Style', 'barta-core' ),
				'options' => array(
					'style_1' => __( 'Style 1' , 'barta-core' ),
					'style_2' => __( 'style 2', 'barta-core' ),
				),
				'default' => 'style_2',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => __( 'Title Color', 'barta-core' ),
				'default' => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .el-rt-news-box-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_bg_color',
				'label'   => __( 'Title Background Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array(
					'{{WRAPPER}} .el-rt-news-box-title.style_2' => 'background: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_2 .titleinner' => 'border-top-color: {{VALUE}}',
					'{{WRAPPER}} .rt-news-box-title-holder' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .el-rt-news-box-title.style_1 .titleinner' => 'border-top-color: {{VALUE}}',
				),
			),

			/*single or Multi category display option - switch*/
			array (
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat_num',
				'label'   => __( 'single Category or<br>Multiple category Select', 'barta-core' ),
				'options' => array(
					'multi' 	=> __( 'Multiple Category', 'barta-core' ),
					'single'	=> __( 'Single Category', 'barta-core' ),					
				),
				'default' => 'multi',
			),
			/*category select( Box Single )*/
			array (
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'cat_single_list',
				'label'     => __( 'Categories', 'barta-core' ),
				'options'   => $category_dropdown,
				'default'   => '0',
				'multiple'  => false,
				'condition' => array( 'cat_num' => array( 'single' ) ),
			),						
			/*category select( box Multi )*/
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'category_list',
				'label'   => __( 'Add as many Categories as you want', 'barta-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::SELECT2,
						'name'    => 'cat_multi_list',
						'label'   => __( 'Categories', 'barta-core' ),
						'options' => $category_dropdown,
						'multiple'=> false,
						'default' => '1',
					),
				),
				'condition' => array( 'cat_num' => array( 'multi' ) ),
			),
			/*Featured Item title Style*/ 
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'      => 'list_item_title_typo',
				'label'   => __( 'Item Title Style', 'barta-core' ),
				'selector' => '{{WRAPPER}} .list-default h3',
			),
			/*category display option - switch*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'cat_display',
				'label'       => __( 'Category Name Display', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Number of post - With dependancy*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_of_post',
				'label'   => __( 'Number of Post', 'barta-core' ),
				'default' => '4',				
			),
			
			/*version 1.3*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_of_post_offset',
				'label'   => __( 'Number of Post Offset', 'barta-core' ),
				'default' => '0',
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'posts_not_in',
				'label'   => __( 'Enter Post ID that will not display', 'barta-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::NUMBER,
						'name'    => 'post_not_in',
						'label'   => __( 'Post ID', 'barta-core' ),
						'default' => '0',
					),
				),
			),			
			/*Box Style Option*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'small_item_style',
				'label'   => __( 'Small Item Style', 'barta-core' ),
				'options' => array(
					'general' => __( 'General' , 'barta-core' ),
					'boxed' => __( 'Boxed', 'barta-core' ),
				),
				'default' => 'general',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'small_item_background',
				'label'   => __( 'Small Item Background Color', 'barta-core' ),
				'default' => false,
				'selectors' => array( 
					'{{WRAPPER}} .list-default.boxed .media' => 'background: {{VALUE}}',
				),
				'condition' => array( 'small_item_style' => array( 'boxed' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color',
				'label'   => __( 'News Title Color', 'barta-core' ),
				'default' => '#111111',
				'selectors' => array( 
					'{{WRAPPER}} .list-default h3.title-medium-dark a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color_hover',
				'label'   => __( 'News Title Hover Color', 'barta-core' ),
				'default' => '#E53935',
				'selectors' => array( 
					'{{WRAPPER}} .list-default h3.title-medium-dark a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .list-default .post-meta-dark ul li a:hover' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_date_color',
				'label'   => __( 'News Meta Color', 'barta-core' ),
				'default' => '#ffffff',
				'selectors' => array( 
					'{{WRAPPER}} .list-default .post-meta-dark' => 'color: {{VALUE}}',
				),
			),
			
			array(
				'mode' => 'section_end',
			),
			/*Common Post Display & Query Options*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_query',
				'label'   => __( 'Common Post Display & Query Options', 'barta-core' ),
			),
			/*Post Sorting*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_sorting',
				'label'   => __( 'Post Sorting', 'barta-core' ),
				'options' => array(
					'recent' 		=> __( 'Recent Post', 'barta-core' ),
					'rand' 			=> __( 'Random Post', 'barta-core' ),
					'modified' 		=> __( 'Last Modified Post', 'barta-core' ),
					'comment_count' => __( 'Most commented Post', 'barta-core' ),
					'view' 			=> __( 'Most viewed Post', 'barta-core' ),
				),
				'default' => 'recent',
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_ordering',
				'label'   => __( 'Post Ordering', 'barta-core' ),
				'options' => array(
					'DESC'	=> __( 'Desecending', 'barta-core' ),
					'ASC'	=> __( 'Ascending', 'barta-core' ),
				),
				'default' => 'DESC',
			),
			/*Pagination - with dependancy*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'pagination_display',
				'label'       => __( 'Pagination Display', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'no',
				'condition' => array( 'cat_num' => array( 'single' ) ),
			),
			/*Post Title Length*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_title_length',
				'label'   => __( 'Post Title Length<br>(blank means no limit)', 'barta-core' ),
				'default' => '6',
			),
			/*Post Excerpt Lenght*/
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'post_excerpt_length',
				'label'   => __( 'Post Excerpt Length <br>(blank means no limit)', 'barta-core' ),
				'default' => '10',
			),
			/*Display Post Autor*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'display_content',
				'label'       => __( 'Display Content', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
				'condition' => array( 'layout_list' => array( 'list1', 'list3' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_content_color',
				'label'   => __( 'News Content Color', 'barta-core' ),
				'default' => '#121212',
				'selectors' => array( 
					'{{WRAPPER}} .list-default .rt-list-content' => 'color: {{VALUE}}',
				),
				'condition' => array( 'display_content' => array( 'yes' ) ),
			),
			array(				
				'id'  	=> 'hr',
				'type'	=> Controls_Manager::DIVIDER,				
				'style' => 'thick',
			),
			/*Display Post Date*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_date',
				'label'       => __( 'Display Post Date', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),	

			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_readmore',
				'label'       => __( 'Display Read more', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
			),	

			/*Display Post Date Format*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_date_format',
				'label'   => __( 'Post Date Format', 'barta-core' ),
				'options' => array(
					'global' 		=> __( 'Wordpress Setting Format', 'barta-core' ),
					'custom' 		=> __( 'Customized', 'barta-core' ),
				),
				'default' => 'global',
			),
			/*Display Post Comment*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_comment',
				'label'       => __( 'Show Comments Number', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			/*Display Post Autor*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_author',
				'label'       => __( 'Show Author Name', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),			
			/*Hide Thumbnail*/			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_post_thumb',
				'label'       => __( 'Display Post Thumbnail', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),
			
			/*Show No Preview image*/			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'show_no_preview_img',
				'label'       => __( 'Show No Preview Image', 'barta-core' ),
				'label_on'    => __( 'On', 'barta-core' ),
				'label_off'   => __( 'Off', 'barta-core' ),
				'default'     => 'yes',
			),			
			array(
				'mode' => 'section_end',
			),
			
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

			switch ( $data['layout_list'] ) {
				case 'list3':
				$template = 'rt-news-list-3';
				break;
				case 'list2':
				$template = 'rt-news-list-2';
				break;
				default:
				$template = 'rt-news-list-1';
				break;
			}

		return $this->rt_template( $template, $data );
	}
}