<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$barta_theme_data = wp_get_theme();
if ( version_compare( PHP_VERSION, '5.5', '>=' ) ) {
	
	$action  = 'barta_theme_init';
	do_action( $action );
	
	define( 'BARTA_VERSION', ( WP_DEBUG ) ? time() : $barta_theme_data->get( 'Version' ) );
	define( 'BARTA_AUTHOR_URI', $barta_theme_data->get( 'AuthorURI' ) );
	define( 'BARTA_PREFIX', 'barta' );

	// DIR
	define( 'BARTA_BASE_DIR',    get_template_directory(). '/' );
	define( 'BARTA_INC_DIR',     BARTA_BASE_DIR . 'inc/' );
	define( 'BARTA_VIEW_DIR',    BARTA_INC_DIR . 'views/' );
	define( 'BARTA_LIB_DIR',     BARTA_BASE_DIR . 'lib/' );
	define( 'BARTA_WID_DIR',     BARTA_INC_DIR . 'widgets/' );
	define( 'BARTA_PLUGINS_DIR', BARTA_INC_DIR . 'plugins/' );
	define( 'BARTA_MODULES_DIR', BARTA_INC_DIR . 'modules/' );
	define( 'BARTA_ASSETS_DIR',  BARTA_BASE_DIR . 'assets/' );
	define( 'BARTA_CSS_DIR',     BARTA_ASSETS_DIR . 'css/' );
	define( 'BARTA_JS_DIR',      BARTA_ASSETS_DIR . 'js/' );

	// URL
	define( 'BARTA_BASE_URL',    get_template_directory_uri(). '/' );
	define( 'BARTA_ASSETS_URL',  BARTA_BASE_URL . 'assets/' );
	define( 'BARTA_CSS_URL',     BARTA_ASSETS_URL . 'css/' );
	define( 'BARTA_AUTORTL_URL', BARTA_ASSETS_URL . 'css-auto-rtl/' ); //@rtl
	define( 'BARTA_JS_URL',      BARTA_ASSETS_URL . 'js/' );
	define( 'BARTA_IMG_URL',     BARTA_ASSETS_URL . 'img/' );
	define( 'BARTA_LIB_URL',     BARTA_BASE_URL . 'lib/' );

	//Other Plugins active or not
	define( 'BARTA_BBPRESS_IS_ACTIVE',     class_exists( 'bbPress' ) );
	
	if ( ! function_exists( 'redux_options_translation' ) ) {

		function redux_options_translation() {
			load_theme_textdomain( 'barta', BARTA_BASE_DIR . 'languages' );
		}
		
		redux_options_translation();
		
	}
	
	// Includes	
	require_once BARTA_INC_DIR . 'helper-functions.php';
	require_once BARTA_INC_DIR . 'redux-config.php';
	require_once BARTA_INC_DIR . 'barta.php';	
	require_once BARTA_INC_DIR . 'general.php';
	require_once BARTA_INC_DIR . 'scripts.php';
	require_once BARTA_INC_DIR . 'template-vars.php';
	require_once BARTA_INC_DIR . 'sidebar-generator.php';

	// Includes Modules	
	require_once BARTA_MODULES_DIR . 'rt-post-ticker.php';
	require_once BARTA_MODULES_DIR . 'rt-post-related.php';	
	require_once BARTA_MODULES_DIR . 'rt-breadcrumbs.php';
	require_once BARTA_MODULES_DIR . 'rt-ad-management.php';	

	// WooCommerce
	if ( class_exists( 'WooCommerce' ) ) {
		require_once BARTA_INC_DIR . 'woo-functions.php';
		require_once BARTA_INC_DIR . 'woo-hooks.php';
	}

	require_once BARTA_INC_DIR . 'search-widget.php'; // override default

	// TGM Plugin Activation
	require_once BARTA_LIB_DIR . 'class-tgm-plugin-activation.php';
	require_once BARTA_INC_DIR . 'tgm-config.php';
	
	// Widgets fallback
	if ( class_exists ( 'Barta_Core' ) && !defined( 'BARTA_CORE_UPDATE_1' ) ) {
		add_action( 'admin_notices', 'barta_widgets_fallback_notice' );
	}

	function barta_widgets_fallback_notice() {
		$notice = '<div class="error"><p>' . sprintf( __( "Please update plugin <b><i>Barta Core</b></i> to the latest version otherwise some functionalities will not work properly. You can update it from <a href='%s'>here</a>", 'barta' ), menu_page_url( 'barta-install-plugins', false ) ) . '</p></div>';
		echo wp_kses_post( $notice );
	}	

} else {
	
	add_action( 'admin_notices', 'phpfail_notice' );
	add_action( 'template_include', array( $this, 'fallback_template' ), 99 );

	function phpfail_notice() {
		$theme_data = wp_get_theme( 'barta' );
		$theme_name = $theme_data->get( 'Name' );
		$msg = sprintf( esc_html__( 'Error: Your current PHP version is %1$s. You need at least PHP version 5.3+ for theme "%2$s" to work. Please ask your hosting provider to upgrade your PHP version into 5.5+', 'barta' ), PHP_VERSION, $theme_name );
		echo '<div class="error"><p>' . $msg . '</p></div>';
	}

	function fallback_template( $template ) {
		$template = locate_template( array( 'fallback.php' ) );
		return $template;
	}
}

add_editor_style( 'style-editor.css' );