<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


//ticker start
function barta_news_ticker() {

	$option_cats = BartaTheme::$options['ticker_cat'];

	if ( !empty($option_cats) ) { 	
		$post_number = BartaTheme::$options['ticker_post_number'];
	?>
	<ul id="rt-js-news" class="js-hidden">
	<?php
		
		$no_duplicate_post = array();	

		foreach ( $option_cats as $category ) {
		
		$args = array(
			'cat' => $category,
			'post_type' => 'post',
			'posts_per_page' => $post_number,
			'post__not_in' => $no_duplicate_post
		);
		
		$the_query = new WP_Query( $args );
		
		while ( $the_query->have_posts() ) {

		$the_query->the_post();
		
		$no_duplicate_post[] = get_the_ID();
	?>
		<li class="news-item"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
	<?php }
	wp_reset_postdata();
	} ?>
	</ul>
<?php } else { ?>	
	<ul id="rt-js-news" class="js-hidden">
		<li><?php esc_html_e('Please enable News ticker from the theme option Panel to display Post' , 'barta'); ?></li>
	</ul>
<?php } }