<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( ! class_exists( 'Redux' ) ) {
    return;
}

$opt_name = 'barta';

$theme = wp_get_theme();
$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'disable_tracking' => true,
    'display_name'         => $theme->get( 'Name' ),
    // Name that appears at the top of your panel
    'display_version'      => $theme->get( 'Version' ),
    // Version that appears at the top of your panel
    'menu_type'            => 'submenu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__( 'Barta Options', 'barta' ),
	
    'page_title'           => esc_html__( 'Barta Options', 'barta' ),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    //'google_api_key'       => 'AIzaSyC2GwbfJvi-WnYpScCPBGIUyFZF97LI0xs',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => true,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,   // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-menu',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => false,
    'forced_dev_mode_off'  => false,
    // Show the time the page took to load, etc
    'update_notice'        => false,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,    // Disable the save warning when a user changes a field

    // OPTIONAL -> Give you extra features
    'page_priority'        => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => 'themes.php',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'barta-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => true,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
);

Redux::setArgs( $opt_name, $args );

// Fields
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'General', 'barta' ),
    'id'               => 'general_section',
    'heading'          => '',
    'icon'             => 'el el-network',
    'fields' => array(
        array(
            'id'       => 'primary_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Primary Color', 'barta' ),
            'subtitle' => esc_html__( 'Theme Default: #e53935', 'barta' ),
            'default'  => '#e53935',
        ),
        array(
            'id'       => 'container_width',
            'type'     => 'select',
            'title'    => esc_html__( 'Container width( Bootstrap Grid )', 'barta'), 
            'subtitle' => esc_html__( 'Bootstrap Grid Container Width size for site.', 'barta' ),
            'options'  => array(
                '1350' => esc_html__( '1350px', 'barta' ),
                '1240' => esc_html__( '1240px', 'barta' ),
                '1140' => esc_html__( '1140px', 'barta' ),
            ),
            'default'  => '1240',
        ),
        array(
            'id'       => 'preloader',
            'type'     => 'switch',
            'title'    => esc_html__( 'Preloader', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),
        array(
            'id'       => 'preloader_image',
            'type'     => 'media',
            'title'    => esc_html__( 'Preloader Image', 'barta' ),
            'subtitle' => esc_html__( 'Please upload your choice of preloader image. Transparent GIF format is recommended', 'barta' ),
            'default'  => array(
                'url'=> BARTA_IMG_URL . 'preloader.gif'
            ),
            'required' => array( 'preloader', 'equals', true )
        ),
        array(
            'id'       => 'back_to_top',
            'type'     => 'switch',
            'title'    => esc_html__( 'Back to Top Arrow', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'display_no_preview_image',
            'type'     => 'switch',
            'title'    => esc_html__( 'Display No Preview Image on Blog/Archive', 'barta' ),
			'off'      => esc_html__( 'Disabled', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'default'  => 'off',
        ),
        array(
            'id'       => 'display_no_prev_img_related_post',
            'type'     => 'switch',
            'title'    => esc_html__( 'Display No Preview Image on Related Post', 'barta' ),
			'off'      => esc_html__( 'Disabled', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'default'  => 'off',
        ),
        array(
            'id'       => 'no_preview_image',
            'type'     => 'media',
            'title'    => esc_html__( 'Alternative Preview Image', 'barta' ),
            'subtitle' => esc_html__( 'This image will be used as preview image in some archive pages if no featured image exists', 'barta' ),
            'default'  => array(
                'url'=> BARTA_IMG_URL . 'noimage.jpg'
            ),
			'required' => array( 'display_no_preview_image', 'equals', true )
        ),
        array(
            'id'       => 'active_lazyload',
            'type'     => 'switch',
            'title'    => esc_html__( 'Active/deactive Lazyload', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
			'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),				
        array(
            'id'       => 'show_search_bar',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Search Bar', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
			'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),		
    )
) 
);

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Contact & Socials', 'barta' ),
    'id'               => 'socials_section',
    'heading'          => '',
    'desc'             => esc_html__( 'In case you want to hide any field, keep that field empty', 'barta' ),
    'icon'             => 'el el-twitter',
    'fields' => array(
        array(
            'id'       => 'phone',
            'type'     => 'text',
            'title'    => esc_html__( 'Phone', 'barta' ),
            'default'  => '',
        ),
        array(
            'id'       => 'email',
            'type'     => 'text',
            'title'    => esc_html__( 'Email', 'barta' ),
            'validate' => 'email',
            'default'  => '',
        ),
        array(
            'id'       => 'city',
            'type'     => 'text',
            'title'    => esc_html__( 'City', 'barta' ),
            'validate' => 'city',
            'default'  => '',
        ),
        array(
            'id'       => 'address',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Address', 'barta' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_facebook',
            'type'     => 'text',
            'title'    => esc_html__( 'Facebook', 'barta' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_twitter',
            'type'     => 'text',
            'title'    => esc_html__( 'Twitter', 'barta' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_gplus',
            'type'     => 'text',
            'title'    => esc_html__( 'Google Plus', 'barta' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_linkedin',
            'type'     => 'text',
            'title'    => esc_html__( 'Linkedin', 'barta' ),
            'default'  => ''
        ),
        array(
            'id'       => 'social_youtube',
            'type'     => 'text',
            'title'    => esc_html__( 'Youtube', 'barta' ),
            'default'  => '',
        ),
        array(
            'id'       => 'social_pinterest',
            'type'     => 'text',
            'title'    => esc_html__( 'Pinterest', 'barta' ),
            'default'  => ''
        ),
        array(
            'id'       => 'social_instagram',
            'type'     => 'text',
            'title'    => esc_html__( 'Instagram', 'barta' ),
            'default'  => ''
        ),
        array(
            'id'       => 'social_skype',
            'type'     => 'text',
            'title'    => esc_html__( 'Skype', 'barta' ),
            'default'  => ''
        ),
        array(
            'id'       => 'social_rss',
            'type'     => 'text',
            'title'    => esc_html__( 'RSS', 'barta' ),
            'default'  => '',
        ),
    )            
    ) );

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Header', 'barta' ),
    'id'               => 'header_section',
    'heading'          => '',
    'icon'             => 'el el-caret-up',
    'fields' => array(
        array(
            'id'       => 'logo',
            'type'     => 'media',
            'title'    => esc_html__( 'Main Logo', 'barta' ),
            'default'  => array(
                'url'=> BARTA_IMG_URL . 'logo.png'
            ),
            'subtitle' => esc_html__( 'Logo height less than 90px is recommended', 'barta' ),
        ),
        array(
            'id'       => 'logo_light',
            'type'     => 'media',
            'title'    => esc_html__( 'Light Logo', 'barta' ),
            'default'  => array(
                'url'=> BARTA_IMG_URL . 'logo2.png'
            ),
            'subtitle' => esc_html__( 'Used when Transparent Header is enabled. Logo height less than 90px is recommended', 'barta' ),
        ),
        array(
            'id'       => 'logo_width',
            'type'     => 'select',
            'title'    => esc_html__( 'Logo Area Width', 'barta'), 
            'subtitle' => esc_html__( 'Width is defined by the number of bootstrap columns. Please note, navigation menu width will be decreased with the increase of logo width', 'barta' ),
            'options'  => array(
                '1' => esc_html__( '1 Column', 'barta' ),
                '2' => esc_html__( '2 Column', 'barta' ),
                '3' => esc_html__( '3 Column', 'barta' ),
                '4' => esc_html__( '4 Column', 'barta' ),
            ),
            'default'  => '2',
        ),
        array(
            'id'       => 'sticky_menu',
            'type'     => 'switch',
            'title'    => esc_html__( 'Sticky Header', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
            'subtitle' => esc_html__( 'Show header when scroll down', 'barta' ),
        ),
        array(
            'id'       => 'tr_header',
            'type'     => 'switch',
            'title'    => esc_html__( 'Transparent Header', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
            'subtitle' => esc_html__( 'You have to enable Banner or Slider in page to make it work properly. You can override this settings in individual pages', 'barta' ),
        ),
        array(
            'id'       => 'top_bar',
            'type'     => 'switch',
            'title'    => esc_html__( 'Top Bar', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
            'subtitle' => esc_html__( 'You can override this settings in individual pages', 'barta' ),
        ),
        array(
            'id'       => 'top_bar_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Top Bar Text Color', 'barta' ),
            'default'  => '#444444',
        ),
        array(
            'id'       => 'top_bar_color_tr',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Transparent Top Bar Text Color', 'barta' ),
            'subtitle' => esc_html__( 'Applied when Transparent Header is enabled', 'barta' ),
            'default'  => '#efefef',
        ),
        array(
            'id'       => 'top_bar_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Top Bar Background Color', 'barta' ),
            'default'  => '#f8f8f8',
        ),
        array(
            'id'       => 'top_bar_style',
            'type'     => 'image_select',
            'title'    => esc_html__( 'Top Bar Layout', 'barta' ),
            'default'  => '1',
            'options' => array(
                '1' => array(
                    'title' => '<b>'. esc_html__( 'Layout 1', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'top1.png',
                ),
                '2' => array(
                    'title' => '<b>'. esc_html__( 'Layout 2', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'top2.png',
                ),
                '3' => array(
                    'title' => '<b>'. esc_html__( 'Layout 3', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'top3.png',
                ),
                '4' => array(
                    'title' => '<b>'. esc_html__( 'Layout 4', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'top4.png',
                )
            ),
            'subtitle' => esc_html__( 'You can override this settings in individual pages', 'barta' ),
        ),
        array( 
            'id'       => 'header_style',
            'type'     => 'image_select',
            'title'    => esc_html__( 'Header Layout', 'barta' ),
            'default'  => '1',
            'options' => array(
                '1' => array(
                    'title' => '<b>'. esc_html__( 'Layout 1', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'header-1.jpg',
                ),
                '2' => array(
                    'title' => '<b>'. esc_html__( 'Layout 2', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'header-2.jpg',
                ),
                '3' => array(
                    'title' => '<b>'. esc_html__( 'Layout 3', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'header-3.jpg',
                ),
                '4' => array(
                    'title' => '<b>'. esc_html__( 'Layout 4', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'header-4.jpg',
                ),
                '5' => array(
                    'title' => '<b>'. esc_html__( 'Layout 5', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'header-5.jpg',
                ),
                '6' => array(
                    'title' => '<b>'. esc_html__( 'Layout 6', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'header-6.jpg',
                ),
            ),
            'subtitle' => esc_html__( 'You can override this settings in individual pages', 'barta' ),
        ),
		//header 2
        array(
            'id'       => 'header_ad_type',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Advertisement in the header style 2', 'barta' ),
            'options'  => array(
				'adimage'  => esc_html__( 'Advertisement Image/Bannr', 'barta' ),
                'adrotate' => esc_html__( 'Adrotate Ad', 'barta' ),
                'adcode'   => esc_html__( 'Advertisement Code', 'barta' ),                
            ),
            'default' => 'adimage',
			
			'required' => array ( array( 'header_style', 'equals', '2' ) ),
        ),
        array(
            'id'       => 'header_ad_adrotate',
            'type'     => 'text',
            'title'    => esc_html__( 'Insert the adrotate shortcode', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-2', 'barta' ),
			'required' => array( 'header_ad_type', 'equals', 'adrotate' )
        ),
        array(
            'id'       => 'header_ad_code',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Insert the Ad Code here', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-2', 'barta' ),
			'required' => array( 'header_ad_type', 'equals', 'adcode' )
        ),
        array(
            'id'       => 'header_ad_image',
            'type'     => 'media',
            'default'  => array(
                'url'=> BARTA_IMG_URL . 'header_ad.jpg'
            ),			
            'title'    => esc_html__( 'Insert the Ad Code here', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-2', 'barta' ),
			'required' => array( 'header_ad_type', 'equals', 'adimage' )
        ),
        array(
            'id'       => 'header_adimage_link',
            'type'     => 'text',
            'title'    => esc_html__( 'Insert the Image Ad Anchor Link/URL', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-2', 'barta' ),
			'required' => array( 'header_ad_type', 'equals', 'adimage' )			
        ),		
        array(
            'id'       => 'header_ad_link_type_2',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Open Advertisement Tab', 'barta' ),
            'options'  => array(
				'blank'  => esc_html__( 'Open in new tab', 'barta' ),
                'same' => esc_html__( 'Open in Same tab', 'barta' ),
            ),
            'default' => 'blank',			
			'required' => array( 'header_ad_type', 'equals', 'adimage' )
        ),
		//header 4
        array(
            'id'       => 'header_ad_type_4',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Advertisement in the header style 4', 'barta' ),
            'options'  => array(
				'adimage'  => esc_html__( 'Advertisement Image/Bannr', 'barta' ),
                'adrotate' => esc_html__( 'Adrotate Ad', 'barta' ),
                'adcode'   => esc_html__( 'Advertisement Code', 'barta' ),                
            ),
            'default' => 'adimage',
			
			'required' => array ( array( 'header_style', 'equals', '4' ) ),
        ),
        array(
            'id'       => 'header_ad_adrotate_4',
            'type'     => 'text',
            'title'    => esc_html__( 'Insert the adrotate shortcode', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-4', 'barta' ),
			'required' => array( 'header_ad_type_4', 'equals', 'adrotate' )
        ),
        array(
            'id'       => 'header_ad_code_4',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Insert the Ad Code here', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-4', 'barta' ),
			'required' => array( 'header_ad_type_4', 'equals', 'adcode' )
        ),
        array(
            'id'       => 'header_ad_image_4',
            'type'     => 'media',
            'default'  => array(
                'url'=> BARTA_IMG_URL . 'header_ad.jpg'
            ),			
            'title'    => esc_html__( 'Insert the Ad Code here', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-4', 'barta' ),
			'required' => array( 'header_ad_type_4', 'equals', 'adimage' )
        ),
        array(
            'id'       => 'header_adimage_link_4',
            'type'     => 'text',
            'title'    => esc_html__( 'Insert the Image Ad Anchor Link/URL', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-4', 'barta' ),
			'required' => array( 'header_ad_type_4', 'equals', 'adimage' )
			
        ),					
        array(
            'id'       => 'header_ad_link_type_4',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Open Advertisement Tab', 'barta' ),
            'options'  => array(
				'blank'  => esc_html__( 'Open in new tab', 'barta' ),
                'same' => esc_html__( 'Open in Same tab', 'barta' ),
            ),
            'default' => 'blank',
			'required' => array( 'header_ad_type_4', 'equals', 'adimage' )
        ),
		//header 5
        array(
            'id'       => 'header_ad_type_5',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Advertisement in the header style 5', 'barta' ),
            'options'  => array(
				'adimage'  => esc_html__( 'Advertisement Image/Bannr', 'barta' ),
                'adrotate' => esc_html__( 'Adrotate Ad', 'barta' ),
                'adcode'   => esc_html__( 'Advertisement Code', 'barta' ),                
            ),
            'default' => 'adimage',
			
			'required' => array ( array( 'header_style', 'equals', '5' ) ),
        ),
        array(
            'id'       => 'header_ad_adrotate_5',
            'type'     => 'text',
            'title'    => esc_html__( 'Insert the adrotate shortcode', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-5', 'barta' ),
			'required' => array( 'header_ad_type_5', 'equals', 'adrotate' )
        ),
        array(
            'id'       => 'header_ad_code_5',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Insert the Ad Code here', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-5', 'barta' ),
			'required' => array( 'header_ad_type_5', 'equals', 'adcode' )
        ),
        array(
            'id'       => 'header_ad_image_5',
            'type'     => 'media',
            'default'  => array(
                'url'=> BARTA_IMG_URL . 'header_ad.jpg'
            ),			
            'title'    => esc_html__( 'Insert the Ad Code here', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-5', 'barta' ),
			'required' => array( 'header_ad_type_5', 'equals', 'adimage' )
        ),
        array(
            'id'       => 'header_adimage_link_5',
            'type'     => 'text',
            'title'    => esc_html__( 'Insert the Image Ad Anchor Link/URL', 'barta' ),
            'subtitle' => esc_html__( 'Only used in Header Layout-5', 'barta' ),
			'required' => array( 'header_ad_type_5', 'equals', 'adimage' )
			
        ),					
        array(
            'id'       => 'header_ad_link_type_5',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Open Advertisement Tab', 'barta' ),
            'options'  => array(
				'blank'  => esc_html__( 'Open in new tab', 'barta' ),
                'same' => esc_html__( 'Open in Same tab', 'barta' ),
            ),
            'default' => 'blank',			
			'required' => array( 'header_ad_type_5', 'equals', 'adimage' )
        ),		
        array(
            'id'       => 'show_in_mobile_5',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show header advertisement in the Mobile view', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
			'required' => array ( array( 'header_style', 'equals', '5' ) ),
        ), 		
        array(
            'id'       => 'show_in_mobile_4',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show header advertisement in the Mobile view', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
			'required' => array ( array( 'header_style', 'equals', '4' ) ),
        ), 		
        array(
            'id'       => 'show_in_mobile_2',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show header advertisement in the Mobile view', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
			'required' => array ( array( 'header_style', 'equals', '2' ) ),
        ), 
		
        array(
            'id'       => 'search_icon',
            'type'     => 'switch',
            'title'    => esc_html__( 'Search Icon', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'cart_icon',
            'type'     => 'switch',
            'title'    => esc_html__( 'Cart Icon', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
        ),		
		
    )            
) 
);

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Main Menu', 'barta' ),
    'id'               => 'menu_section',
    'heading'          => '',
    'icon'             => 'el el-book',
    'fields' => array(
        array(
            'id'       => 'section-mainmenu',
            'type'     => 'section',
            'title'    => esc_html__( 'Main Menu Items', 'barta' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'menu_typo',
            'type'     => 'typography',
            'title'    => esc_html__( 'Menu Font', 'barta' ),
            'google'   => true,
            'subsets'   => false,
            'text-align' => false,
            'color'   => false,
            'text-transform' => true,
            'default'     => array(
                'font-family' 	 => 'Roboto',
                'google'      	 => true,
                'font-size'   	 => '15px',
                'font-weight' 	 => '500',
                'line-height' 	 => '16px',
                'text-transform' => 'uppercase',
            ),
        ),
        array(
            'id'       => 'menu_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Menu Color', 'barta' ),
            'default'  => '#111111',
        ),
		/*menu background color for header style 6,7,8 */
        array(
            'id'       => 'menu_bgcolor_6',
            'type'     => 'color',
            'title'    => esc_html__('Menu Background Color', 'barta'), 
            'validate' => 'color',
            'transparent' => false,
            'default' => '#e53935',
			'required' => array( 
				array('header_style','equals','6')
			)
        ),
        array(
            'id'       => 'menu_color_tr',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Transparent Menu Color', 'barta' ),
            'subtitle' => esc_html__( 'Applied when Transparent Header is enabled', 'barta' ),
            'default'  => '#fff',
        ),
        array(
            'id'       => 'menu_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Menu Hover Color', 'barta' ),
            'default'  => '#e53935',
        ),
        array(
            'id'       => 'section-submenu',
            'type'     => 'section',
            'title'    => esc_html__( 'Sub Menu Items', 'barta' ),
            'indent'   => true,
        ), 
        array(
            'id'       => 'submenu_typo',
            'type'     => 'typography',
            'title'    => esc_html__( 'Submenu Font', 'barta' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'color'   => false,
            'text-transform' => true,
            'default'     => array(
                'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '15px',
                'font-weight' => '400',
                'line-height' => '21px',
                'text-transform' => 'inherit',
            ),
        ),
        array(
            'id'       => 'submenu_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Submenu Color', 'barta' ),
            'default'  => '#ffffff',
        ), 
        array(
            'id'       => 'submenu_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Submenu Background Color', 'barta' ),
            'default'  => '#e53935',
        ),  
        array(
            'id'       => 'submenu_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Submenu Hover Color', 'barta' ),
            'default'  => '#ffffff',
        ), 
        array(
            'id'       => 'submenu_hover_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Submenu Hover Background Color', 'barta' ),
            'default'  => '#111111',
        ),
        array(
            'id'       => 'section-resmenu',
            'type'     => 'section',
            'title'    => esc_html__( 'Mobile Menu', 'barta' ),
            'indent'   => true,
        ), 
        array(
            'id'       => 'resmenu_width',
            'type'     => 'slider',
            'title'    => esc_html__( 'Screen width in which mobile menu activated', 'barta' ),
            'subtitle' => esc_html__( 'Recommended value is: 992', 'barta' ),
            'default'  => 992,
            'min'      => 0,
            'step'     => 1,
            'max'      => 2000,
        ),
        array(
            'id'       => 'resmenu_typo',
            'type'     => 'typography',
            'title'    => esc_html__( 'Mobile Menu Font', 'barta' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'color'   => false,
            'text-transform' => true,
            'default'     => array(
				'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '14px',
                'font-weight' => '500',
                'line-height' => '21px',
                'text-transform' => 'uppercase',				
            ),
        ),
    )
) 
);

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Banner', 'barta' ),
    'id'               => 'banner_section',
    'heading'          => '',
    'icon'             => 'el el-picture',
    'fields' => array(
        array(
            'id'       => 'banner_heading_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Banner Heading Color', 'barta' ),
            'default'  => '#ffffff',
        ),
        array(
            'id'       => 'breadcrumb_active',
            'type'     => 'switch',
            'title'    => esc_html__( 'Enable Breadcrumb', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
        ),
		array(
			'id'       => 'breadcrumbs_delimiter',
			'type'     => 'text',
			'title'    => esc_html__( 'Breadcrumbs Delimiter', 'barta' ),
			'default'  => ' - ',
		),
        array(
            'id'       => 'breadcrumb_hide_mobile',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show/Hide Breadcrumb in mobile', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),
        array(
            'id'       => 'breadcrumb_link_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Breadcrumb Link Color', 'barta' ),
            'default'  => '#ffffff',
        ),
        array(
            'id'       => 'breadcrumb_link_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Breadcrumb Link Hover Color', 'barta' ),
            'default'  => '#e53935',
        ),
        array(
            'id'       => 'breadcrumb_active_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Active Breadcrumb Color', 'barta' ),
            'default'  => '#ffffff',
        ),
        array(
            'id'       => 'breadcrumb_seperator_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Breadcrumb Seperator Color', 'barta' ),
            'default'  => '#ffffff',
        ),
        array(
            'id'       => 'banner_bg_opacity',
            'type'     => 'text',
            'title'    => esc_html__( 'Banner Background Overlay opacity', 'barta' ),
            'default'  => '0.8',
        ),
        array(
            'id'       => 'banner_info_date',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show/Hide Banner Info Date', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),
        array(
            'id'       => 'banner_info_update',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show/Hide Banner Info Last Update', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),
    )
) 
);

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'News Ticker', 'barta' ),
    'id'               => 'ticker_section',
    'heading'          => '',
    'icon'             => 'el el-flag',
    'fields' => array(
        array(
            'id'       => 'ticker_enable',
            'type'     => 'switch',
            'title'    => esc_html__( 'Display Ticker', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),
		array(
			'id'       => 'ticker_title_text',
			'type'     => 'text',
			'title'    => esc_html__( 'News Ticker title', 'barta' ),
			'default'  => 'Top Stories',
		),		
        array(
            'id'       => 'ticker_title_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Ticker Title Bgcolor', 'barta' ),
			'default'  => '',
        ),
		array(
			'id'       => 'ticker_delay',
			'type'     => 'text',
			'title'    => esc_html__( 'Ticker Delay', 'barta' ),
			'default'  => '2000',
		),
		array(
			'id'       => 'ticker_speed',
			'type'     => 'text',
			'title'    => esc_html__( 'Ticker speed', 'barta' ),
			'default'  => '.10',
		),
        array(
            'id'       => 'ticker_style',
            'type'     => 'select',
            'title'    => esc_html__( 'Ticker Style', 'barta' ),
            'options'  => array(
                'reveal' => 'Reveal',
                'fade' => 'Fade',
            ),
            'default'  => 'reveal',
        ),
        array(
            'id'       => 'ticker_direction',
            'type'     => 'select',
            'title'    => esc_html__( 'Ticker Direction', 'barta' ),
            'options'  => array(
                'ltr' => 'Left To Right',
                'rtl' => 'Right To Left',
            ),
            'default'  => '',
        ),
        array(
            'id'       => 'ticker_control',
            'type'     => 'switch',
            'title'    => esc_html__( 'Display Ticker Control', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
        ),
		array(
		    'id'=>'ticker_cat',
            'type' => 'select',
			'multi'  => true,
            'data' => 'terms',
            'args' => array('taxonomies'=>'category', 'args'=>array()),
            'title' => esc_html__('Post cat', 'barta'), 
            'subtitle' => esc_html__('Please choose product category/categories', 'barta'),
            'desc' => esc_html__('Please Select the category/categories ( Multiple Select )', 'barta'),
			'default'  => '1',
        ),
		array(
			'id'       => 'ticker_post_number',
			'type'     => 'text',
			'title'    => esc_html__( 'Number of Ticker', 'barta' ),
			'default'  => '5',
			'desc' => esc_html__('Post to display from each selected categories', 'barta'),
		),
		
    )
) 
);

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Reading Progress Bar', 'barta' ),
    'id'               => 'scroll_indicator_section',
    'heading'          => '',
    'icon'             => 'el el-flag',
    'fields' => array(
        array(
            'id'       => 'scroll_indicator_enable',
            'type'     => 'switch',
            'title'    => esc_html__( 'Reading Progress Bar', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),
        array(
            'id'       => 'scroll_indicator_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Reading Progress Bar Background Color', 'barta' ),
			'default'  => '#000',
        ),
        array(
            'id'       => 'scroll_indicator_active_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Reading Progress Bar Active Bgcolor', 'barta' ),
			'default'  => '#e53935',
        ),
		array(
			'id'       => 'scroll_indicator_height',
			'type'     => 'text',
			'title'    => esc_html__( 'Height of the Progress Bar', 'barta' ),
			'default'  => '4',
			'desc' => esc_html__('Height of the Progress Bar', 'barta'),
		),
        array(
            'id'       => 'scroll_indicator_position',
            'type'     => 'select',
            'title'    => esc_html__( 'Reading Progress Bar Position', 'barta' ),
            'options'  => array(
                'top' => esc_html__( 'Top', 'barta' ),
                'below' => esc_html__( 'Below', 'barta' ),
            ),
            'default'  => 'top',
        ),		
    )            
) 
);

/*advertisement*/
function barta_redux_advertisement_fields( $prefix, $title, $subtitle = '' ){
    return array(
        array(
            'id'       =>  $prefix. '_sec',
            'type'     => 'section',
            'title'    => $title,
            'subtitle' => $subtitle,
            'indent'   => true,
        ),
        array(
            'id'       => $prefix. '_activate',
            'type'     => 'switch',
            'title'    => esc_html__( 'Activate Ad', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),
        array(
            'id'       => $prefix. '_type',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Ad Type', 'barta' ),
            'options'  => array(
                'image'  => esc_html__( 'Image Link', 'barta' ),
                'code'   => esc_html__( 'Custom Code', 'barta' ),
            ),
            'default' => 'image',
            'required' => array(  $prefix. '_activate', 'equals', true )
        ),
        array(
            'id'       => $prefix. '_image',
            'type'     => 'media',
            'title'    => esc_html__( 'Image', 'barta' ),
            'default'  => '',
            'required' => array(  $prefix. '_type', 'equals', 'image' )
        ),
        array(
            'id'       => $prefix. '_url',
            'type'     => 'text',
            'title'    => esc_html__( 'Link', 'barta' ),
            'default'  => '',
            'required' => array(  $prefix. '_type', 'equals', 'image' )
        ),
        array(
            'id'       => $prefix. '_newtab',
            'type'     => 'switch',
            'title'    => esc_html__( 'Open Link in New Tab', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
            'required' => array(  $prefix. '_type', 'equals', 'image' )
        ),
        array(
            'id'       => $prefix. '_nofollow',
            'type'     => 'switch',
            'title'    => esc_html__( 'Nofollow', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
            'subtitle' => esc_html__( 'Make Link Nofollow', 'barta' ),
            'required' => array(  $prefix. '_type', 'equals', 'image' )
        ),
        array(
            'id'       => $prefix. '_code',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Custom Code', 'barta' ),
            'default'  => '',
            'subtitle' => esc_html__( 'Supports: Shortcode, Adsense, Text, HTML, Scripts', 'barta' ),
            'required' => array(  $prefix. '_type', 'equals', 'code' )
        ),
    );
}


Redux::setSection( $opt_name,
    array(
        'title' => esc_html__( 'Advertisements', 'barta' ),
        'id'    => 'ad_settings_section',
        'icon'  => 'el el-speaker',
    )
);

// Single Post
$field1 = barta_redux_advertisement_fields( 'ad_post_header', esc_html__( 'Header Top', 'barta') );
$field2 = barta_redux_advertisement_fields( 'ad_post_header_below', esc_html__( 'Header Below', 'barta') );
$field4 = barta_redux_advertisement_fields( 'ad_post_footer', esc_html__( 'Footer', 'barta') );
$field5 = barta_redux_advertisement_fields( 'ad_post_before_content', esc_html__( 'Before Post Contents', 'barta') );
$field6 = barta_redux_advertisement_fields( 'ad_post_after_content', esc_html__( 'After Post Contents', 'barta') );

$fields = array_merge( $field1, $field2, $field4, $field5, $field6 );
Redux::setSection( $opt_name,
    array(
        'title'   => esc_html__( 'Single Post', 'barta' ),
        'id'      => 'ad_settings_post_section',
        'heading' => '',
        'subsection' => true,
        'fields'  => $fields
    )
);

// Page
$field1 = barta_redux_advertisement_fields( 'ad_page_header', esc_html__( 'Header', 'barta') );
$field2 = barta_redux_advertisement_fields( 'ad_page_header_below', esc_html__( 'Header Below', 'barta') );
$field4 = barta_redux_advertisement_fields( 'ad_page_footer', esc_html__( 'Footer', 'barta') );
$field5 = barta_redux_advertisement_fields( 'ad_page_before_content', esc_html__( 'Before Page Contents', 'barta') );
$field6 = barta_redux_advertisement_fields( 'ad_page_after_content', esc_html__( 'After Page Contents', 'barta') );

$fields = array_merge( $field1, $field2, $field4, $field5, $field6 );
Redux::setSection( $opt_name,
    array(
        'title'   => esc_html__( 'Page', 'barta' ),
        'id'      => 'ad_settings_page_section',
        'heading' => '',
        'subsection' => true,
        'fields'  => $fields
    )
);


// Blog/Archive
$field1 = barta_redux_advertisement_fields( 'ad_blog_header', esc_html__( 'Header', 'barta') );
$field2 = barta_redux_advertisement_fields( 'ad_blog_header_below', esc_html__( 'Header Below', 'barta') );
$field3 = barta_redux_advertisement_fields( 'ad_blog_footer', esc_html__( 'Footer', 'barta') );

$fields = array_merge( $field1, $field2, $field3 );
Redux::setSection( $opt_name,
    array(
        'title'   => esc_html__( 'Blog/Archive', 'barta' ),
        'id'      => 'ad_settings_blog_section',
        'heading' => '',
        'subsection' => true,
        'fields'  => $fields
    )
);

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Footer', 'barta' ),
    'id'               => 'footer_section',
    'heading'          => '',
    'icon'             => 'el el-caret-down',
    'fields' => array(
		/*main footer part*/
        array(
            'id'       => 'section-footer-area',
            'type'     => 'section',
            'title'    => esc_html__( 'Footer Area', 'barta' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'footer_area',
            'type'     => 'switch',
            'title'    => esc_html__( 'Display Footer Area', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'footer_column',
            'type'     => 'select',
            'title'    => esc_html__( 'Number of Columns', 'barta' ),
            'options'  => array(
                '1' => '1 Column',
                '2' => '2 Columns',
                '3' => '3 Columns',
                '4' => '4 Columns',
            ),
            'default'  => '3',
            'required' => array( 'footer_area', 'equals', true )
        ),
        array(
            'id'       => 'footer_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Footer Background Color', 'barta' ),
            'default'  => '#000000',
            'required' => array( 'footer_area', 'equals', true ),
        ),
        array(
            'id'       => 'footer_title_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Footer Title Text Color', 'barta' ),
            'default'  => '#ffffff',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Footer Body Text Color', 'barta' ),
            'default'  => '#c4c4c4',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_link_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Footer Body Link Color', 'barta' ),
            'default'  => '#c4c4c4',
            'required' => array( 'footer_area', 'equals', true )
        ), 
        array(
            'id'       => 'footer_link_hover_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Footer Body Link Hover Color', 'barta' ),
            'default'  => '#e53935',
            'required' => array( 'footer_area', 'equals', true )
        ),		
        array(
            'id'       => 'footer_logo_light',
            'type'     => 'media',
            'title'    => esc_html__( 'Footer Logo', 'barta' ),
            'default'  => array(
                'url'=> BARTA_IMG_URL . 'logo2.png'
            ),
            'subtitle' => esc_html__( 'Logo height less than 90px is recommended', 'barta' ),
        ),
        array(
            'id'       => 'section-copyright-area',
            'type'     => 'section',
            'title'    => esc_html__( 'Copyright Area', 'barta' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'copyright_area',
            'type'     => 'switch',
            'title'    => esc_html__( 'Display Copyright Area', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'copyright_bgcolor',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Copyright Background Color', 'barta' ),
            'default'  => '#000000',
            'required' => array( 'copyright_area', 'equals', true )
        ),
        array(
            'id'       => 'copyright_color',
            'type'     => 'color',
            'transparent' => false,
            'title'    => esc_html__( 'Copyright Text Color', 'barta' ),
            'default'  => '#dddddd',
            'required' => array( 'copyright_area', 'equals', true )
        ),
        array(
            'id'       => 'copyright_text',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Copyright Text', 'barta' ),
            'default'  => '&copy; Copyright Barta 2020. Designed and Developed by <a rel="nofollow" target="_blank" href="#">RadiusTheme</a>',
            'required' => array( 'copyright_area', 'equals', true )
        ),
    )
) );

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Typography', 'barta' ),
    'id'               => 'typo_section',
    'icon'             => 'el el-text-width',
    'fields' => array(
        array(
            'id'       => 'typo_body',
            'type'     => 'typography',
            'title'    => esc_html__( 'Body', 'barta' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '15px',
                'font-weight' => '400',
                'line-height' => '24px',
            ),
        ),
        array(
            'id'       => 'typo_h1',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h1', 'barta' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '36px',
                'font-weight' => '500',
                'line-height'   => '40px',
            ),
        ),
        array(
            'id'       => 'typo_h2',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h2', 'barta' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '28px',
                'font-weight' => '500',
                'line-height' => '34px',
            ),
        ),
        array(
            'id'       => 'typo_h3',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h3', 'barta' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '22px',
                'font-weight' => '500',
                'line-height' => '28px',
            ),
        ),
        array(
            'id'       => 'typo_h4',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h4', 'barta' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '18px',
                'font-weight' => '500',
                'line-height' => '26px',
            ),
        ),
        array(
            'id'       => 'typo_h5',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h5', 'barta' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '16px',
                'font-weight' => '500',
                'line-height' => '24px',
            ),
        ),
        array(
            'id'       => 'typo_h6',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header h6', 'barta' ),
            'google'   => true,
            'subsets'   => false,
            'text-align'   => false,
            'font-weight'   => false,
            'color'   => false,
            'default'     => array(
                'font-family' => 'Roboto',
                'google'      => true,
                'font-size'   => '14px',
                'font-weight' => '500',
                'line-height' => '22px',
            ),
        ),
    )
) );

// Generate Common post type fields 
function barta_redux_post_type_fields( $prefix ){
    return array(
        array(
            'id'       => $prefix. '_layout',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Layout', 'barta' ),
            'options'  => array(
                'left-sidebar'  => esc_html__( 'Left Sidebar', 'barta' ),
                'full-width'    => esc_html__( 'Full Width', 'barta' ),
                'right-sidebar' => esc_html__( 'Right Sidebar', 'barta' ),
            ),
            'default' => 'right-sidebar'
        ),		
        array(
            'id'       => $prefix. '_sidebar',
            'type'     => 'select',
            'title'    => __( 'Custom Sidebar', 'barta' ),
            'options'  => BartaTheme_Helper::custom_sidebar_fields(),
            'default'  => 'sidebar',
            'required' => array( $prefix. '_layout', '!=', 'full-width' ),
        ),
        array(
            'id'       => $prefix. '_padding_top',
            'type'     => 'text',
            'title'    => esc_html__( 'Content Padding Top', 'barta' ),
            'validate'  => 'numeric',
            'default' => '70',
        ),
        array(
            'id'       => $prefix. '_padding_bottom',
            'type'     => 'text',
            'title'    => esc_html__( 'Content Padding Bottom', 'barta' ),
            'validate'  => 'numeric',
            'default' => '70'
        ),
        array(
            'id'       => $prefix. '_banner_ticker',
            'type'     => 'switch',
            'title'    => esc_html__( 'Banner Ticker', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),
        array(
            'id'       => $prefix. '_banner_info',
            'type'     => 'switch',
            'title'    => esc_html__( 'Banner Info', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => false,
        ),
        array(
            'id'       => $prefix. '_banner',
            'type'     => 'switch',
            'title'    => esc_html__( 'Banner', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => $prefix. '_breadcrumb',
            'type'     => 'switch',
            'title'    => esc_html__( 'Breadcrumb', 'barta' ),
            'on'       => esc_html__( 'Enabled', 'barta' ),
            'off'      => esc_html__( 'Disabled', 'barta' ),
            'default'  => true,
            'required' => array( $prefix. '_banner', 'equals', true )
        ),
        array(
            'id'       => $prefix. '_bgtype',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Banner Background Type', 'barta' ),
            'options'  => array(
                'bgimg'    => esc_html__( 'Background Image', 'barta' ),
                'bgcolor'  => esc_html__( 'Background Color', 'barta' ),
            ),
            'default' => 'bgimg',
            'required' => array( $prefix. '_banner', 'equals', true )
        ),
        array(
            'id'       => $prefix. '_bgimg',
            'type'     => 'media',
            'title'    => esc_html__( 'Banner Background Image', 'barta' ),
            'default'  => array(
                'url'=> BARTA_IMG_URL . 'banner.jpg'
            ),
            'required' => array( $prefix. '_bgtype', 'equals', 'bgimg' )
        ),
        array(
            'id'       => $prefix. '_bgcolor',
            'type'     => 'color',
            'title'    => esc_html__('Banner Background Color', 'barta'), 
            'validate' => 'color',
            'transparent' => false,
            'default' => '#606060',
            'required' => array( $prefix. '_bgtype', 'equals', 'bgcolor' )
        ),
        array(
            'id'       => $prefix. '_page_bgimg',
            'type'     => 'media',
            'title'    => esc_html__( 'Page/Post Background Image', 'barta' ),
            'default'  => array(
                'url'=> '',
            ),
        ),
        array(
            'id'       => $prefix. '_page_bgcolor',
            'type'     => 'color',
            'title'    => esc_html__('Page/Post Background Color', 'barta'), 
            'validate' => 'color',
            'transparent' => true,
            'default' => '#ffffff',
        ),
    );
}

Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Layout Defaults', 'barta' ),
    'id'               => 'layout_defaults',
    'icon'             => 'el el-th',
    ) );

// Page
$barta_page_fields = barta_redux_post_type_fields( 'page' );
$barta_page_fields[0]['default'] = 'full-width';
Redux::setSection( $opt_name, array(
	'title'            => esc_html__( 'Page', 'barta' ),
	'id'               => 'pages_section',
	'subsection' => true,
	'fields' => $barta_page_fields
	) );

//Post Archive
$barta_post_archive_fields = barta_redux_post_type_fields( 'blog' );
Redux::setSection( $opt_name, array(
	'title'      => esc_html__( 'Blog / Archive', 'barta' ),
	'id'         => 'blog_section',
	'subsection' => true,
	'fields' 	 => $barta_post_archive_fields
	) );

// Single Post
$barta_single_post_fields = barta_redux_post_type_fields( 'single_post' );
Redux::setSection( $opt_name, array(
	'title'      => esc_html__( 'Post Single', 'barta' ),
	'id'         => 'single_post_section',
	'subsection' => true,
	'fields' 	 => $barta_single_post_fields           
	) );


// Search
$barta_search_fields = barta_redux_post_type_fields( 'search' );

$excerpt_length = array (
	array(
		'id'       => 'search_excerpt_length',
		'type'     => 'text',
		'title'    => esc_html__( 'Search Excerpt Length', 'barta' ),
		'validate'  => 'numeric',
		'default' => '25',
	)       
);
$barta_search_field_2 = array_merge ( $barta_search_fields , $excerpt_length );
Redux::setSection( $opt_name, array(
	'title'      => esc_html__( 'Search Layout', 'barta' ),
	'id'         => 'search_section',
	'heading'    => '',
	'subsection' => true,
	'fields' 	 => $barta_search_field_2
));

// Error 404 Layout
$barta_error_fields = barta_redux_post_type_fields( 'error' );
unset($barta_error_fields[0]);
$barta_error_fields[2]['default'] = 'full-width';
$barta_error_fields[2]['default'] = '120';
$barta_error_fields[3]['default'] = '120';
Redux::setSection( $opt_name, array(
    'title'   	 => esc_html__( 'Error 404 Layout', 'barta' ),
    'id'      	 => 'error_section',
    'heading' 	 => '',
    'subsection' => true,
    'fields'  	 => $barta_error_fields           
) 
);

if ( class_exists( 'WooCommerce' ) ) {
    // Woocommerce Shop Archive
    $barta_shop_archive_fields = barta_redux_post_type_fields( 'shop' );
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Shop Archive', 'barta' ),
        'id'         => 'shop_section',
        'subsection' => true,
        'fields' 	 => $barta_shop_archive_fields
        ) );

    // Woocommerce Product
    $barta_product_fields = barta_redux_post_type_fields( 'product' );
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Product Single', 'barta' ),
        'id'         => 'product_section',
        'subsection' => true,
        'fields' 	 => $barta_product_fields
        ) );
}

// Blog Settings
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Blog Settings', 'barta' ),
    'id'               => 'blog_settings_section',
    'icon'             => 'el el-tags',
    'heading'          => '',
    'fields' => array(
        array(
            'id'       =>'blog_style',
            'type'     => 'image_select',
            'title'    => esc_html__( 'Blog/Archive Layout', 'barta' ),
            'default'  => 'style5',
            'options' => array(
                'style1' => array(
                    'title' => '<b>'. esc_html__( 'Layout 1', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'blog1.png',
                ),
                'style2' => array(
                    'title' => '<b>'. esc_html__( 'Layout 2', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'blog2.png',
                ),
                'style3' => array(
                    'title' => '<b>'. esc_html__( 'Layout 3', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'blog3.png',
                ),
                'style4' => array(
                    'title' => '<b>'. esc_html__( 'Layout 4(Masonry)', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'blog4.png',
                ),
                'style5' => array(
                    'title' => '<b>'. esc_html__( 'Layout 5(Masonry)', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'blog4.png',
                ),
            ),
        ),
		array(
			'id'       => 'post_banner_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Enter the Post Banner Title', 'barta' ),
			'default'  => esc_html__( '', 'barta' ),			
		),
		array(
			'id'       => 'post_content_limit',
			'type'     => 'text',
			'title'    => esc_html__( 'Post Content Limit', 'barta' ),
			'default'  => 20,
		),
        array(
            'id'       => 'blog_date',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Date', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'blog_author_name',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Author Name', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'blog_comment_num',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Comment Number', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => false,
        ),
        array(
            'id'       => 'blog_cats',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Categories', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,            
        ),		
		/*version 1.4 - load more pagination option*/
		array(
            'id'       => 'load_more_option',
            'type'     => 'select',
            'title'    => esc_html__( 'Show Pagination / Load More / Infinite', 'barta'), 
            'subtitle' => esc_html__( 'Select how the more post will show - Pagination / Load More / Infinite', 'barta' ),
            'options'  => array(
                'pagination' => esc_html__( 'Pagination', 'barta' ),
                'load_more' => esc_html__( 'Load More', 'barta' ),
                'infinity' => esc_html__( 'Infinity', 'barta' ),
            ),
            'default'  => 'pagination',
        ),
		array(
			'id'       => 'infinity_post_load_number',
			'type'     => 'text',
			'title'    => esc_html__( 'Infinity/Load More Post Number', 'barta' ),
			'validate'  => 'numeric',
			'default' => '5',
			'required' => array( 'load_more_option', 'equals', 'infinity' )
		),
    )
) 
);

// Post Settings
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Post Settings', 'barta' ),
    'id'               => 'post_settings_section',
    'icon'             => 'el el-file-edit',
    'heading'          => '',
    'fields' => array(
        array(
            'id'       => 'section-submenu-2',
            'type'     => 'section',
            'title'    => esc_html__( 'Single Post/news Layout Style', 'barta' ),
            'indent'   => true,
        ),	
        array(
            'id'       =>'post_style',
            'type'     => 'image_select',
            'title'    => esc_html__( 'Single Post Layout', 'barta' ),
            'default'  => 'style2',
            'options' => array(
                'style1' => array(
                    'title' => '<b>'. esc_html__( 'Layout 1', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'post-style-1.png',
                ),
                'style2' => array(
                    'title' => '<b>'. esc_html__( 'Layout 2', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'post-style-3.png',
                ),
                'style3' => array(
                    'title' => '<b>'. esc_html__( 'Layout 3', 'barta' ) . '</b>',
                    'img' => BARTA_IMG_URL . 'post-style-2.png',
                ),
            ),
        ),		
        array(
            'id'       => 'section-submenu-3',
            'type'     => 'section',
            'title'    => esc_html__( 'single Post info Settings', 'barta' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'post_featured_image',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Featured Image', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_author_name',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Author Name', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_author_social',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Author Social Links', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => false,
        ),
        array(
            'id'       => 'post_date',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Post Date', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_above_date',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Above Post Date', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,			
            'required' => array( 'post_style', 'equals', 'style1' )
        ),
        array(
            'id'       => 'time_format',
            'type'     => 'select',
            'title'    => esc_html__( 'Modern', 'barta'), 
            'subtitle' => esc_html__( 'Simple Date format', 'barta' ),
            'options'  => array(
                'modern' => esc_html__( 'Modern', 'barta' ),
                'none'   => esc_html__( 'None', 'barta' ),
            ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_comment_num',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Comment Number', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ), 
        array(
            'id'       => 'post_cats',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Categories', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_tags',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Tags', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_links',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Next Post / Previous post', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_author_bio',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Author Bio', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => false,
        ),
        array(
            'id'       => 'post_subtitle',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Post Subtitle', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_view',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show/hide Post View', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
			'subtitle' => esc_html__( 'Show or hide post views count number', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_length',
            'type'     => 'switch',
            'title'    => esc_html__( 'Post Reading Length Active', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'section_post_related',
            'type'     => 'section',
            'title'    => esc_html__( 'Related Post Settings', 'barta' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'show_related_post',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Related product', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
		array(
			'id'       => 'show_related_post_number',
			'type'     => 'text',
			'title'    => esc_html__( 'Show Related Post Number', 'barta' ),
			'default'  => esc_html__( '3', 'barta' ),
		),
        array(
            'id'       => 'blog_star_rating',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Star Rating in Comment', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,            
        ),
		array(
			'id'       => 'related_post_query',
			'type'     => 'radio',
			'title'    => esc_html__('Query Type', 'barta'), 
			'subtitle' => esc_html__('Post Query', 'barta'),		
			'options'  => array(
				'cat' => esc_html__( 'Posts in the same Categories', 'barta' ), 
				'tag' => esc_html__( 'Posts in the same Tags', 'barta' ), 
				'author' => esc_html__( 'Posts by the same Author', 'barta' ),
			),
			'default' => 'cat'
		),
		array(
			'id'       => 'related_post_sort',
			'type'     => 'radio',
			'title'    => esc_html__('Sort Order', 'barta'), 
			'subtitle' => esc_html__('Display post Order', 'barta'),
			'options'  => array(
				'recent' => esc_html__( 'Recent Posts', 'barta' ), 
				'rand' => esc_html__( 'Random Posts', 'barta' ), 
				'modified' => esc_html__( 'Last Modified Posts', 'barta' ),
				'popular' => esc_html__( 'Most Commented posts', 'barta' ),
				'views' => esc_html__( 'Most Viewed posts', 'barta' ),
			),
			'default' => 'recent'
		),
		array(
			'id'       => 'show_related_post_title_limit',
			'type'     => 'text',
			'title'    => esc_html__( 'Show Related Post Title Length', 'barta' ),
			'default'  => esc_html__( '8', 'barta' ),
		),		
		/*Share button - options*/	
        array(
            'id'       => 'section-submenu-5',
            'type'     => 'section',
            'title'    => esc_html__( 'single Post share button Settings', 'barta' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'post_share_display_top',
            'type'     => 'switch',
            'title'    => esc_html__( 'Share Button Show/hide in top', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_display_footer',
            'type'     => 'switch',
            'title'    => esc_html__( 'Share Button Show/hide in footer ', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'share_shortlink',
            'type'     => 'switch',
            'title'    => esc_html__( 'Use the post\'s Short Link', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => false,
        ),
		array(
            'id'       => 'section-submenu-6',
            'type'     => 'section',
            'title'    => esc_html__( 'Place of the Caption', 'barta' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'show_caption',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show caption', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => false,
        ),
		array(
			'id'       => 'show_caption_place',
			'type'     => 'radio',
			'title'    => esc_html__('Place of the Caption', 'barta'), 
			'subtitle' => esc_html__('Display Caption in Post', 'barta'),
			'options'  => array(
				'underimage' => esc_html__( 'Under Image', 'barta' ),
				'overimage' => esc_html__( 'Over Image', 'barta' ),
			),
			'default' => 'underimage',
			'required' => array( 'show_caption', 'equals', true )
		),
		array(
			'id'       => 'show_caption_align',
			'type'     => 'radio',
			'title'    => esc_html__('Caption alignment', 'barta'),
			'subtitle' => esc_html__('Alignment of the caption', 'barta'),
			'options'  => array(
				'cap_right' => esc_html__( 'Right', 'barta' ),
				'cap_left' => esc_html__( 'Left', 'barta' ),
				'cap_center' => esc_html__( 'Center', 'barta' ),
			),
			'default' => 'cap_right',
			'required' => array( 'show_caption', 'equals', true )
		),		
    ),
)
);

// Post Settings
Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Post Sharing Option', 'barta' ),
    'id'               => 'post_sharing_section',
    'icon'             => 'el el-file-edit',
    'heading'          => '',
    'fields' => array(	
        array(
            'id'       => 'section-submenu-3',
            'type'     => 'section',
            'title'    => esc_html__( 'Single Post/news Sharing Option', 'barta' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'post_share_facebook',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Facebook Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_twitter',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Twitter Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_google',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Google Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_linkedin',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Linkedin Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_whatsapp',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Whatsapp Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_stumbleupon',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Stumbleupon Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_tumblr',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Tumblr Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_pinterest',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Pinterest Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_reddit',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Reddit Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_email',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Email Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
        array(
            'id'       => 'post_share_print',
            'type'     => 'switch',
            'title'    => esc_html__( 'Show Print Share Button', 'barta' ),
            'on'       => esc_html__( 'On', 'barta' ),
            'off'      => esc_html__( 'Off', 'barta' ),
            'default'  => true,
        ),
    ),
)

);

// Error
$barta_fields2 = array(
    array(
        'id'       => 'error_title',
        'type'     => 'text',
        'title'    => esc_html__( 'Page Title', 'barta' ),
        'default'  => esc_html__( 'Error 404', 'barta' ),
    ),
    array(
        'id'       => 'error_bodybg',
        'type'     => 'color',
        'transparent' => false,
        'title'    => esc_html__( 'Body Background Color', 'barta' ),
        'default'  => '#e53935',
    ),
    array(
        'id'       => 'error_bodybanner',
        'type'     => 'media',
        'title'    => esc_html__( 'Body Banner', 'barta' ),
        'default'  => array(
            'url'=> BARTA_IMG_URL . '404.png'
        ),
    ),
    array(
        'id'       => 'error_text1',
        'type'     => 'text',
        'title'    => esc_html__( 'Body Text 1', 'barta' ),
        'default'  => esc_html__( 'Ooops... Page Not Found!', 'barta' ),
    ),
	array(
        'id'       => 'error_text2',
        'type'     => 'text',
        'title'    => esc_html__( 'Body Text 2', 'barta' ),
        'default'  => esc_html__( 'The page your are looking for is not available or has been removed. Try going to Home Page by using the buton below', 'barta' ),
    ),
    array(
        'id'       => 'error_text1_color',
        'type'     => 'color',
        'transparent' => false,
        'title'    => esc_html__( 'Body Text 1 Color', 'barta' ),
        'default'  => '#ffffff',
    ),
    array(
        'id'       => 'error_text2_color',
        'type'     => 'color',
        'transparent' => false,
        'title'    => esc_html__( 'Body Text 2 Color', 'barta' ),
        'default'  => '#ffffff',
    ),
    array(
        'id'       => 'error_buttontext',
        'type'     => 'text',
        'title'    => esc_html__( 'Button Text', 'barta' ),
        'default'  => esc_html__( 'GO TO HOME PAGE', 'barta' ),
    )
);
Redux::setSection( $opt_name, array(
    'title'   => esc_html__( 'Error Page Settings', 'barta' ),
    'id'      => 'error_srttings_section',
    'heading' => '',
    'icon'    => 'el el-error-alt',
    'fields'  => $barta_fields2           
) 
);

do_action( 'rt_after_redux_options_loaded','barta' );


if ( class_exists( 'WooCommerce' ) ) {
    // Woocommerce Settings
    Redux::setSection( $opt_name, array(
        'title'   => esc_html__( 'WooCommerce', 'barta' ),
        'id'      => 'woo_Settings_section',
        'heading' => '',
        'icon'    => 'el el-shopping-cart',
        'fields'  => array(
            array(
                'id'       => 'wc_sec_general',
                'type'     => 'section',
                'title'    => esc_html__( 'General', 'barta' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'wc_num_product',
                'type'     => 'text',
                'title'    => esc_html__( 'Number of Products Per Page', 'barta' ),
                'default'  => '9',
            ),
            array(
                'id'       => 'wc_product_hover',
                'type'     => 'switch',
                'title'    => esc_html__( 'Product Hover Effect', 'barta' ),
                'on'       => esc_html__( 'Enabled', 'barta' ),
                'off'      => esc_html__( 'Disabled', 'barta' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_wishlist_icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Product Add to Wishlist Icon', 'barta' ),
                'on'       => esc_html__( 'Enabled', 'barta' ),
                'off'      => esc_html__( 'Disabled', 'barta' ),
                'default'  => true,
                'required' => array( 'wc_product_hover', 'equals', true )
            ),
            array(
                'id'       => 'wc_quickview_icon',
                'type'     => 'switch',
                'title'    => esc_html__( 'Product Quickview Icon', 'barta' ),
                'on'       => esc_html__( 'Enabled', 'barta' ),
                'off'      => esc_html__( 'Disabled', 'barta' ),
                'default'  => true,
                'required' => array( 'wc_product_hover', 'equals', true )
            ),
            array(
                'id'       => 'wc_sec_product',
                'type'     => 'section',
                'title'    => esc_html__( 'Product Single Page', 'barta' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'wc_show_excerpt',
                'type'     => 'switch',
                'title'    => esc_html__( "Show excerpt when short description doesn't exist", 'barta' ),
                'on'       => esc_html__( 'Enabled', 'barta' ),
                'off'      => esc_html__( 'Disabled', 'barta' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_cats',
                'type'     => 'switch',
                'title'    => esc_html__( 'Categories', 'barta' ),
                'on'       => esc_html__( 'Show', 'barta' ),
                'off'      => esc_html__( 'Hide', 'barta' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_tags',
                'type'     => 'switch',
                'title'    => esc_html__( 'Tags', 'barta' ),
                'on'       => esc_html__( 'Show', 'barta' ),
                'off'      => esc_html__( 'Hide', 'barta' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_related',
                'type'     => 'switch',
                'title'    => esc_html__( 'Related Products', 'barta' ),
                'on'       => esc_html__( 'Show', 'barta' ),
                'off'      => esc_html__( 'Hide', 'barta' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_description',
                'type'     => 'switch',
                'title'    => esc_html__( 'Description Tab', 'barta' ),
                'on'       => esc_html__( 'Show', 'barta' ),
                'off'      => esc_html__( 'Hide', 'barta' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_reviews',
                'type'     => 'switch',
                'title'    => esc_html__( 'Reviews Tab', 'barta' ),
                'on'       => esc_html__( 'Show', 'barta' ),
                'off'      => esc_html__( 'Hide', 'barta' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_additional_info',
                'type'     => 'switch',
                'title'    => esc_html__( 'Additional Information Tab', 'barta' ),
                'on'       => esc_html__( 'Show', 'barta' ),
                'off'      => esc_html__( 'Hide', 'barta' ),
                'default'  => true,
            ),
            array(
                'id'       => 'wc_sec_cart',
                'type'     => 'section',
                'title'    => esc_html__( 'Cart Page', 'barta' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'wc_cross_sell',
                'type'     => 'switch',
                'title'    => esc_html__( 'Cross Sell Products', 'barta' ),
                'on'       => esc_html__( 'Show', 'barta' ),
                'off'      => esc_html__( 'Hide', 'barta' ),
                'default'  => true,
            ),
        )
	) 
);
}

// -> END Fields
