<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

use Elementor\Plugin; 

add_action( 'wp_enqueue_scripts', 'barta_register_scripts', 12 );
if ( !function_exists( 'barta_register_scripts' ) ) {
	function barta_register_scripts(){
		/*CSS*/
		// owl.carousel CSS
		wp_register_style( 'owl-carousel',       BARTA_CSS_URL . 'owl.carousel.min.css', array(), BARTA_VERSION );
		wp_register_style( 'owl-theme-default',  BARTA_CSS_URL . 'owl.theme.default.min.css', array(), BARTA_VERSION );		
		wp_register_style( 'magnific-popup',     BARTA_CSS_URL . 'magnific-popup.css', array(), BARTA_VERSION );
		/*Slick Slider CSS*/
		wp_register_style( 'slick',     		 BARTA_CSS_URL . 'slick.css', array(), BARTA_VERSION );
		// Slider
		wp_register_style( 'nivo-slider',        BARTA_CSS_URL . 'nivo-slider.min.css', array(), BARTA_VERSION );
		wp_register_style( 'rt-ticker',        BARTA_CSS_URL . 'rt-ticker.css', array(), BARTA_VERSION );
		/*JS*/
		// owl.carousel.min js
		wp_register_script( 'owl-carousel',      BARTA_JS_URL . 'owl.carousel.min.js', array( 'jquery' ), BARTA_VERSION, true );
		// Slider
		wp_register_script( 'nivo-slider',       BARTA_JS_URL . 'jquery.nivo.slider.min.js', array( 'jquery' ), BARTA_VERSION, true );
		wp_register_script( 'rt-ticker',         BARTA_JS_URL . 'rt-ticker.min.js', array( 'jquery' ), BARTA_VERSION, true );
		// counter js
		wp_register_script( 'rt-waypoints',      BARTA_JS_URL . 'waypoints.min.js', array( 'jquery' ), BARTA_VERSION, true );
		wp_register_script( 'counterup',         BARTA_JS_URL . 'jquery.counterup.min.js', array( 'jquery' ), BARTA_VERSION, true );		
		// magnific popup
		wp_register_script( 'magnific-popup',    BARTA_JS_URL . 'jquery.magnific-popup.min.js', array( 'jquery' ), BARTA_VERSION, true );
		/*Slick Slider JS*/
		wp_register_script( 'slick',    BARTA_JS_URL . 'slick.min.js', array( 'jquery' ), BARTA_VERSION, true );		
	}
}

add_action( 'wp_enqueue_scripts', 'barta_enqueue_scripts', 15 );
if ( !function_exists( 'barta_enqueue_scripts' ) ) {
	function barta_enqueue_scripts() {
		$dep = array( 'jquery' , 'rt-ticker' );
		/*CSS*/
		// Google fonts
		wp_enqueue_style( 'barta-gfonts', 	BartaTheme_Helper::fonts_url(), array(), BARTA_VERSION );
		// Bootstrap CSS  //@rtl
		wp_enqueue_style( 'bootstrap', 		BartaTheme_Helper::maybe_rtl( 'bootstrap.min.css' ), array(), BARTA_VERSION );
		
		elementor_scripts();
		wp_dequeue_style( 'fontawesome-css' );
		wp_enqueue_style( 'nivo-slider' );
		// font-awesome CSS
		wp_enqueue_style( 'font-awesome',       BARTA_CSS_URL . 'font-awesome.min.css', array(), BARTA_VERSION );
		wp_enqueue_style( 'slick-theme',        BARTA_CSS_URL . 'slick-theme.css', array(), BARTA_VERSION );
		// Select 2 CSS
		wp_enqueue_style( 'select2',            BARTA_CSS_URL . 'select2.min.css', array(), BARTA_VERSION );		
		if ( BartaTheme::$has_banner_ticker == 1 || BartaTheme::$has_banner_ticker == 'on' ) {
			// ticker CSS
			wp_enqueue_style( 'ticker-style',   BartaTheme_Helper::maybe_rtl( 'ticker-style.css' ), array(), BARTA_VERSION );
		}
		// main CSS // @rtl
		wp_enqueue_style( 'barta-default',    BartaTheme_Helper::maybe_rtl( 'default.css' ), array(), BARTA_VERSION );
		// vc modules css
		wp_enqueue_style( 'barta-elementor',     	BartaTheme_Helper::maybe_rtl( 'elementor.css' ), array(), BARTA_VERSION );		
		//temporary styles
		wp_enqueue_style( 'barta-grid',         BartaTheme_Helper::maybe_rtl( 'barta-grid.css'), array(), BARTA_VERSION );
		wp_enqueue_style( 'barta-box',          BartaTheme_Helper::maybe_rtl( 'barta-box.css'), array(), BARTA_VERSION ); 
		wp_enqueue_style( 'barta-tab',          BartaTheme_Helper::maybe_rtl( 'barta-tab.css'), array(), BARTA_VERSION ); 
		wp_enqueue_style( 'barta-list',         BartaTheme_Helper::maybe_rtl( 'barta-list.css'), array(), BARTA_VERSION );		
		// Style CSS
		wp_enqueue_style( 'barta-style',     	BartaTheme_Helper::maybe_rtl( 'style.css' ), array(), BARTA_VERSION );
		
		// Template Style
		wp_add_inline_style( 'barta-style',   barta_template_style() );

		/*JS*/
		// bootstrap js
		wp_enqueue_script( 'popper',            BARTA_JS_URL . 'popper.js', array( 'jquery' ), BARTA_VERSION, true );
		// bootstrap js
		wp_enqueue_script( 'bootstrap',            BARTA_JS_URL . 'bootstrap.min.js', array( 'jquery' ), BARTA_VERSION, true );		
		// Comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}		
		// Select2 js
		wp_enqueue_script( 'select2', BARTA_JS_URL . 'select2.min.js', array( 'jquery' ), BARTA_VERSION, true );		
		// Countdown
		wp_enqueue_script( 'countdown',      BARTA_JS_URL . 'jquery.countdown.min.js', array( 'jquery' ), BARTA_VERSION, true );
		// Cookie js
		wp_enqueue_script( 'cookie',       BARTA_JS_URL . 'js.cookie.min.js', array( 'jquery' ), BARTA_VERSION, true );
		wp_enqueue_script( 'nivo-slider' );
		wp_enqueue_script( 'news-ticker',     BARTA_JS_URL . 'jquery.ticker.js', array( 'jquery' ), BARTA_VERSION, true );
		if ( (BartaTheme::$options['blog_style'] == 'style4') || (BartaTheme::$options['blog_style'] == 'style5') ) {			
			wp_enqueue_script( array( 'imagesloaded','masonry' ) );
		}
		wp_enqueue_script( array( 'masonry' ) );		
		
		wp_enqueue_style( 'slick' );
		wp_enqueue_script( 'slick' );		
		wp_enqueue_style( 'rt-ticker' );
		wp_enqueue_script( 'rt-ticker' );
		
		wp_enqueue_script( 'barta-main',    BARTA_JS_URL . 'main.js', $dep , BARTA_VERSION, true );
		
		if ( !empty( BartaTheme::$options['logo']['url'] ) ) {
			$logo = '<img class="logo-small" src="'. esc_url( empty( BartaTheme::$options['logo']['url'] ) ? BARTA_IMG_URL . 'logo.png' : BartaTheme::$options['logo']['url'] ).'" />';
		} else {
			$logo = esc_attr( get_bloginfo( 'title' ) );
		}
				
		// localize script
		$barta_localize_data = array(
			'stickyMenu' 	=> BartaTheme::$options['sticky_menu'],
			'meanWidth'  	=> BartaTheme::$options['resmenu_width'],		
			'day'	     => esc_html__('Day' ,'barta'),
			'hour'	     => esc_html__('Hour','barta'),
			'minute'     => esc_html__('Minute','barta'),
			'second'     => esc_html__('Second','barta'),
			'extraOffset' => BartaTheme::$options['sticky_menu'] ? 70 : 0,
			'extraOffsetMobile' => BartaTheme::$options['sticky_menu'] ? 52 : 0,
			//ticker control
			'tickerSpeed' => BartaTheme::$options['ticker_speed'] ? BartaTheme::$options['ticker_speed'] : .10,
			'tickerControl' => BartaTheme::$options['ticker_control'] ? BartaTheme::$options['ticker_control'] : false ,
			'tickerTitleText' => BartaTheme::$options['ticker_title_text'] ? BartaTheme::$options['ticker_title_text'] : 'Top Stories',
			'tickerStyle' => BartaTheme::$options['ticker_style'] ? BartaTheme::$options['ticker_style'] : 'reveal',
			'tickerDirection' => BartaTheme::$options['ticker_direction'] ? BartaTheme::$options['ticker_direction'] : 'ltr',
			'tickerDelay' => BartaTheme::$options['ticker_delay'] ? BartaTheme::$options['ticker_delay'] : 4000,
			'rtl' => is_rtl() ? 'yes' : 'no', //@rtl
					
			// Ajax
			'ajaxURL' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce( 'barta-nonce' )
		);
		wp_localize_script( 'barta-main', 'ThemeObj', $barta_localize_data );
	}	
}

function elementor_scripts() {
	
	if ( !did_action( 'elementor/loaded' ) ) {
		return;
	}
	
	if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
		 // do stuff for preview
		wp_enqueue_style(  'owl-carousel' );
		wp_enqueue_style(  'owl-theme-default' );
		wp_enqueue_style( 'nivo-slider' );
		wp_enqueue_style( 'rt-ticker' );
		wp_enqueue_script( 'nivo-slider' );
		wp_enqueue_script( 'owl-carousel' );
		wp_enqueue_script( 'rt-ticker' );
	} 
}

add_action( 'wp_enqueue_scripts', 'barta_high_priority_scripts', 1500 );
if ( !function_exists( 'barta_high_priority_scripts' ) ) {
	function barta_high_priority_scripts() {
		// Dynamic style
		BartaTheme_Helper::dynamic_internal_style();
	}
}

function barta_template_style(){
	ob_start();
	?>
	.entry-banner {
		<?php if ( BartaTheme::$bgtype == 'bgcolor' ): ?>
			background-color: <?php echo esc_html( BartaTheme::$bgcolor );?>;
		<?php else: ?>
			background: url(<?php echo esc_url( BartaTheme::$bgimg );?>) no-repeat scroll center center / cover;
		<?php endif; ?>
	}
	.content-area {
		padding-top: <?php echo esc_html( BartaTheme::$padding_top );?>px; 
		padding-bottom: <?php echo esc_html( BartaTheme::$padding_bottom );?>px;
	}
	<?php if ( BartaTheme::$pagebgcolor != "#ffffff" ){ ?>
	.post-detail-style2 #page .content-area {
		background-image: url( <?php echo BartaTheme::$pagebgimg; ?> );
		background-color: <?php echo BartaTheme::$pagebgcolor; ?>;
	}
	<?php } ?>
	#page {
		background-image: url( <?php echo BartaTheme::$pagebgimg; ?> );
		background-color: <?php echo BartaTheme::$pagebgcolor; ?>;
	}
	<?php
	return ob_get_clean();
}

function load_custom_wp_admin_script_gutenberg() {
	wp_enqueue_style( 'barta-gfonts', BartaTheme_Helper::fonts_url(), array(), BARTA_VERSION );
	// font-awesome CSS
	wp_enqueue_style( 'font-awesome', BARTA_CSS_URL . 'font-awesome.min.css', array(), BARTA_VERSION );
}
add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_script_gutenberg', 1 );

function load_custom_wp_admin_script() {
	if( null !== ( $screen = get_current_screen() ) && 'edit-category' !== $screen->id ) {
        return;
    }
	wp_register_script( 'barta-admin-js', BARTA_JS_URL . 'rt-widget-color.js', false, BARTA_VERSION, true );
	wp_register_style( 'barta-admin-css', BARTA_CSS_URL . 'admin-style.css', false, BARTA_VERSION, true );
	wp_enqueue_style( 'barta-admin-css' );
	wp_enqueue_script( 'barta-admin-js' );
}
add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_script', 20 );