<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

/*-------------------------------------
INDEX
=======================================
#. Container
#. Top Bar
#. Header
#. Typography
#. Banner
#. Footer
#. Widgets
#. Inner Contents
#. Error 404
#. comment
#. Buttons
#. Single Content
#. Archive Contents
#. Pagination
#. Contact Form 7
#. Single Team
#. WooCommerce
#. Miscellaneous
-------------------------------------*/

$primary_color         = BartaTheme::$options['primary_color']; // #e53935
$secondery_color       = '#797979';
$primary_rgb           = BartaTheme_Helper::hex2rgb( $primary_color ); // 0, 33, 71

$container_width	   = BartaTheme::$options['container_width']; // Grid Container width

$menu_typo             = BartaTheme::$options['menu_typo'];
$menu_color            = BartaTheme::$options['menu_color'];
$menu_color_tr         = BartaTheme::$options['menu_color_tr'];
$menu_hover_color      = BartaTheme::$options['menu_hover_color'];
$submenu_typo          = BartaTheme::$options['submenu_typo'];
$submenu_color         = BartaTheme::$options['submenu_color'];
$submenu_bgcolor       = BartaTheme::$options['submenu_bgcolor'];
$submenu_hover_color   = BartaTheme::$options['submenu_hover_color'];
$submenu_hover_bgcolor = BartaTheme::$options['submenu_hover_bgcolor'];
$resmenu_typo          = BartaTheme::$options['resmenu_typo'];

$barta_typo_body     = BartaTheme::$options['typo_body'];
$barta_typo_h1       = BartaTheme::$options['typo_h1'];
$barta_typo_h2       = BartaTheme::$options['typo_h2'];
$barta_typo_h3       = BartaTheme::$options['typo_h3'];
$barta_typo_h4       = BartaTheme::$options['typo_h4'];
$barta_typo_h5       = BartaTheme::$options['typo_h5'];
$barta_typo_h6       = BartaTheme::$options['typo_h6'];

$ticker_title_bgcolor  = BartaTheme::$options['ticker_title_bgcolor'];

?>
<?php
/*-------------------------------------
#. Container
---------------------------------------*/
?>
@media ( min-width:1200px ) {
	.container {
		max-width: <?php echo esc_html( $container_width ); ?>px;
	}
}
<?php
/*-------------------------------------
#. Top Bar
---------------------------------------*/
?>
#tophead .tophead-contact .fa,
#tophead .tophead-address .fa {
	color: <?php echo esc_html( $primary_color ); ?>;
}
#tophead {
    background-color: <?php echo esc_html( BartaTheme::$options['top_bar_bgcolor'] ); ?>;
}
#tophead,
#tophead a {
    color: <?php echo esc_html( BartaTheme::$options['top_bar_color'] ); ?>;
}
.topbar-style-5 #tophead .tophead-social li a {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.trheader #tophead,
.trheader #tophead a,
.trheader #tophead .tophead-social li a {
	color: <?php echo esc_html( BartaTheme::$options['top_bar_color_tr'] ); ?>;
}
.barta-primary-color{
	color:<?php echo esc_html( $primary_color ); ?>;
}
.barta-primary-bgcolor,
.topbar-style-3 #tophead .tophead-social li a:hover {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.topbar-style-4 #tophead .tophead-contact .fa,
.topbar-style-4 #tophead .tophead-address .fa {
    color: <?php echo esc_html( $primary_color ); ?>;
}
<?php
/*-------------------------------------
#. Header
---------------------------------------*/
?>
<?php // Main Menu ?>
.site-header .main-navigation nav ul li a {
	font-family: <?php echo esc_html( $menu_typo['font-family'] ); ?>, sans-serif;
	font-size : <?php echo esc_html( $menu_typo['font-size'] ); ?>;
	font-weight : <?php echo esc_html( $menu_typo['font-weight'] ); ?>;
	line-height : <?php echo esc_html( $menu_typo['line-height'] ); ?>;
	color: <?php echo esc_html( $menu_color ); ?>;
	text-transform : <?php echo esc_html( $menu_typo['text-transform'] ); ?>;
	font-style: <?php echo empty( $menu_typo['font-style'] ) ? 'normal' : $menu_typo['font-style']; ?>;
}
.site-header .main-navigation ul.menu > li > a:hover,
.site-header .main-navigation ul.menu > li.current-menu-item > a,
.site-header .main-navigation ul.menu > li.current > a {
	color: <?php echo esc_html( $menu_hover_color ); ?>;
}
.site-header .main-navigation nav ul li a.active {
	color: <?php echo esc_html( $menu_hover_color );?> !important;
}
.header-style-5.trheader .site-header .main-navigation nav > ul > li > a {
	color: <?php echo esc_html( $menu_color ); ?>;
}
.header-style-5.trheader .site-header .main-navigation nav > ul > li > a:hover,
.header-style-5.trheader .site-header .main-navigation nav > ul > li.current-menu-item > a:hover,
.header-style-5.trheader .site-header .main-navigation nav > ul > li a.active,
.header-style-5.trheader .site-header .main-navigation nav > ul > li.current > a,
.header-style-1 .site-header .main-navigation ul.menu > li > a:hover,
.header-style-1 .site-header .main-navigation ul.menu > li.current > a:hover,
.header-style-1 .site-header .main-navigation ul.menu > li.current-menu-item > a:hover,
.header-style-1 .site-header .main-navigation  ul li a.active,
.header-style-1 .site-header .main-navigation ul.menu > li.current-menu-item > a,
.header-style-1 .site-header .main-navigation ul.menu > li.current > a  {
	color: <?php echo esc_html( $menu_hover_color );?> !important;
}
.trheader.non-stick .site-header .main-navigation ul.menu > li > a,
.trheader.non-stick .site-header .search-box .search-button i,
.trheader.non-stick .header-icon-seperator,
.trheader.non-stick .header-icon-area .cart-icon-area > a, 
.trheader.non-stick .additional-menu-area a.side-menu-trigger {
	color: <?php echo esc_html( $menu_color_tr ); ?>;
}
<?php // Submenu ?>
.site-header .main-navigation ul li ul li {
	background-color: <?php echo esc_html( $submenu_bgcolor ); ?>;
}
.site-header .main-navigation ul li ul li:hover {
	background-color: <?php echo esc_html( $submenu_hover_bgcolor ); ?>;
}
.site-header .main-navigation ul li ul li a {
	font-family: <?php echo esc_html( $submenu_typo['font-family'] ); ?>, sans-serif;
	font-size : <?php echo esc_html( $submenu_typo['font-size'] ); ?>;
	font-weight : <?php echo esc_html( $submenu_typo['font-weight'] ); ?>;
	line-height : <?php echo esc_html( $submenu_typo['line-height'] ); ?>;
	color: <?php echo esc_html( $submenu_color ); ?>;
	text-transform : <?php echo esc_html( $submenu_typo['text-transform'] ); ?>;
	font-style: <?php echo empty( $submenu_typo['font-style'] ) ? 'normal' : $submenu_typo['font-style']; ?>;
}
.site-header .main-navigation ul li ul li:hover > a {
	color: <?php echo esc_html( $submenu_hover_color ); ?>;
}

<?php // Sticky Menu ?>
.stick .site-header {
	border-color: <?php echo esc_html( $primary_color ); ?>
}

<?php // Multi Column Menu ?>
.site-header .main-navigation ul li.mega-menu > ul.sub-menu {
	background-color: <?php echo esc_html( $submenu_bgcolor ); ?>
}
.site-header .main-navigation ul li.mega-menu ul.sub-menu li a {
	color: <?php echo esc_html( $submenu_color ); ?>
}
.site-header .main-navigation ul li.mega-menu ul.sub-menu li a:hover {
	background-color: <?php echo esc_html( $submenu_hover_bgcolor ); ?>;
	color: <?php echo esc_html( $submenu_hover_color ); ?>;
}
<?php // Mean Menu ?>
.mean-container a.meanmenu-reveal,
.mean-container .mean-nav ul li a.mean-expand {
	color: <?php echo esc_html( $primary_color ); ?>;
}
#header-9 .mean-container a.meanmenu-reveal,
#header-9 .mean-container .mean-nav ul li a.mean-expand {
	color: #222;
}
.mean-container a.meanmenu-reveal span {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
#header-9 .mean-container a.meanmenu-reveal span {
	background-color: #ffffff;
}
@media (max-width:414px) {	
	#header-9 .mean-container a.meanmenu-reveal span {
		background-color: <?php echo esc_html( $primary_color ); ?>;
	}
}
.header-style-9 .header-search-box .form-inline .btn-search {
	background-color: #e53935;
}
.mean-container .mean-bar {	
	border-color: <?php echo esc_html( $primary_color ); ?>;
}
.mean-container .mean-nav ul li a {
	font-family: <?php echo esc_html( $resmenu_typo['font-family'] ); ?>, sans-serif;
	font-size : <?php echo esc_html( $resmenu_typo['font-size'] ); ?>;
	font-weight : <?php echo esc_html( $resmenu_typo['font-weight'] ); ?>;
	line-height : <?php echo esc_html( $resmenu_typo['line-height'] ); ?>;
	color: <?php echo esc_html( $menu_color ); ?>;
	text-transform : <?php echo esc_html( $resmenu_typo['text-transform'] ); ?>;
	font-style: <?php echo empty( $resmenu_typo['font-style'] ) ? 'normal' : $resmenu_typo['font-style']; ?>;
}
.mean-container .mean-nav ul li a:hover,
.mean-container .mean-nav > ul > li.current-menu-item > a {
	color: <?php echo esc_html( $menu_hover_color ); ?>;
}
<?php // Header icons ?>
.header-icon-area .cart-icon-area .cart-icon-num {
	background-color: <?php echo esc_html( $primary_color );?>;
}
.additional-menu-area a.side-menu-trigger:hover,
.trheader.non-stick .additional-menu-area a.side-menu-trigger:hover {
	color: <?php echo esc_html( $menu_hover_color );?>;
}
.site-header .search-box .search-text {
	border-color: <?php echo esc_html( $primary_color );?>;
}

<?php // Header Layout 3 ?>
.header-style-3 .header-contact .fa,
.header-style-3 .header-social li a:hover,
.header-style-3.trheader .header-social li a:hover {
	color: <?php echo esc_html( $menu_hover_color );?>;
}
.header-style-3.trheader .header-contact li a,
.header-style-3.trheader .header-social li a {
	color: <?php echo esc_html( $menu_color_tr ); ?>;
}

<?php // Header Layout 4 ?>
.header-style-4 .header-contact .fa,
.header-style-4 .header-social li a:hover,
.header-style-4.trheader .header-social li a:hover {
	color: <?php echo esc_html( $menu_hover_color );?>;
}
.header-style-4.trheader .header-contact li a,
.header-style-4.trheader .header-social li a {
	color: <?php echo esc_html( $menu_color_tr ); ?>;
}

<?php // Header Layout 5 ?>
.header-style-5 .header-menu-btn {
	background-color: <?php echo esc_html( $primary_color );?>;
}
.trheader.non-stick.header-style-5 .header-menu-btn {
	color: <?php echo esc_html( $menu_color_tr ); ?>;
}

<?php
/*-------------------------------------
#. Typography
---------------------------------------*/
?>
body {
	font-family: <?php echo esc_html( $barta_typo_body['font-family'] ); ?>, sans-serif;
	font-size: <?php echo esc_html( $barta_typo_body['font-size'] ); ?>;
	line-height: <?php echo esc_html( $barta_typo_body['line-height'] ); ?>;
	font-weight: <?php echo esc_html( $barta_typo_body['font-weight'] ); ?>;
}
h1 {
	font-family: <?php echo esc_html( $barta_typo_h1['font-family'] ); ?>;
	font-size: <?php echo esc_html( $barta_typo_h1['font-size'] ); ?>;
	line-height: <?php echo esc_html( $barta_typo_h1['line-height'] ); ?>;
	font-weight: <?php echo esc_html( $barta_typo_h1['font-weight'] ); ?>;
}
h2 {
	font-family: <?php echo esc_html( $barta_typo_h2['font-family'] ); ?>, sans-serif;
	font-size: <?php echo esc_html( $barta_typo_h2['font-size'] ); ?>;
	line-height: <?php echo esc_html( $barta_typo_h2['line-height'] ); ?>;
	font-weight: <?php echo esc_html( $barta_typo_h2['font-weight'] ); ?>;
}
h3 {
	font-family: <?php echo esc_html( $barta_typo_h3['font-family'] ); ?>, sans-serif;
	font-size: <?php echo esc_html( $barta_typo_h3['font-size'] ); ?>;
	line-height: <?php echo esc_html( $barta_typo_h3['line-height'] ); ?>;
	font-weight: <?php echo esc_html( $barta_typo_h3['font-weight'] ); ?>;
}
h4 {
	font-family: <?php echo esc_html( $barta_typo_h4['font-family'] ); ?>, sans-serif;
	font-size: <?php echo esc_html( $barta_typo_h4['font-size'] ); ?>;
	line-height: <?php echo esc_html( $barta_typo_h4['line-height'] ); ?>;
	font-weight: <?php echo esc_html( $barta_typo_h4['font-weight'] ); ?>;
}
h5 {
	font-family: <?php echo esc_html( $barta_typo_h5['font-family'] ); ?>, sans-serif;
	font-size: <?php echo esc_html( $barta_typo_h5['font-size'] ); ?>;
	line-height: <?php echo esc_html( $barta_typo_h5['line-height'] ); ?>;
	font-weight: <?php echo esc_html( $barta_typo_h5['font-weight'] ); ?>;
}
h6 {
	font-family: <?php echo esc_html( $barta_typo_h6['font-family'] ); ?>, sans-serif;
	font-size: <?php echo esc_html( $barta_typo_h6['font-size'] ); ?>;
	line-height: <?php echo esc_html( $barta_typo_h6['line-height'] ); ?>;
	font-weight: <?php echo esc_html( $barta_typo_h6['font-weight'] ); ?>;
}
<?php
/*-------------------------------------
#. Banner
---------------------------------------*/
?>
.entry-banner .entry-banner-content h1 {
	color: <?php echo esc_html( BartaTheme::$options['banner_heading_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb span a {
	color: <?php echo esc_html( BartaTheme::$options['breadcrumb_link_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb span a:hover {
	color: <?php echo esc_html( BartaTheme::$options['breadcrumb_link_hover_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb .breadcrumb-seperator {
	color: <?php echo esc_html( BartaTheme::$options['breadcrumb_seperator_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb > span:last-child {
	color: <?php echo esc_html( BartaTheme::$options['breadcrumb_active_color'] );?>;
}
.entry-banner:after {
    background: rgba(0, 0, 0 , <?php  echo esc_html( BartaTheme::$options['banner_bg_opacity'] ); ?>);
}
.post-detail-holder .breadcrumb-area .entry-breadcrumb span a:hover {
	color: <?php echo esc_html( BartaTheme::$options['breadcrumb_link_hover_color'] );?>;
}
<?php
/*-------------------------------------
#. Footer
---------------------------------------*/
?>
.scrollToTop {
	background-color: <?php echo esc_html( $primary_color ); ?>;
	border: 2px solid rgb(<?php echo esc_html( $primary_rgb );?> , 1);
}
.footer-top-area {
	background-color: <?php echo esc_html( BartaTheme::$options['footer_bgcolor'] ); ?>;
}
.footer-top-area .widget h3 {
	color: <?php echo esc_html( BartaTheme::$options['footer_title_color'] ); ?>;
}
.footer-top-area .widget {
	color: <?php echo esc_html( BartaTheme::$options['footer_color'] ); ?>;
}
.footer-top-area a:link,
.footer-top-area a:visited {
	color: <?php echo esc_html( BartaTheme::$options['footer_link_color'] ); ?>;
}
.footer-top-area a:hover,
.footer-top-area a:active {
	color: <?php echo esc_html( BartaTheme::$options['footer_link_hover_color'] ); ?>;
}
.footer-bottom-area {
	background-color: <?php echo esc_html( BartaTheme::$options['copyright_bgcolor'] ); ?>;
}
.footer-bottom-area .footer-bottom-left {
	color: <?php echo esc_html( BartaTheme::$options['copyright_color'] ); ?>;
}
.footer-top-area .widget_archive li {
	border-bottom: 1px dotted <?php echo esc_html( $primary_color ); ?>;
}
.rt-box-title-1 span {
	border-top-color: <?php echo esc_html( $primary_color ); ?>;
}
<?php
/*-------------------------------------
#. Widgets
---------------------------------------*/
?>
.search-form .input.search-submit {
	background-color: <?php echo esc_html( $primary_color ); ?>;
	border-color: <?php echo esc_html( $primary_color ); ?>;
}
.search-form .input.search-submit a:hover {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.search-no-results .custom-search-input .btn{
	 background-color: <?php echo esc_html( $primary_color ); ?>;
}
.widget ul li a:hover {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .widget h3.widgettitle:after {
  background: <?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .widget .rt-slider-sidebar .rt-single-slide .testimo-info .testimo-title h3,
.sidebar-widget-area .rt_widget_recent_entries_with_image .media-body .posted-date a,
.sidebar-widget-area .widget ul li a:before,
.sidebar-widget-area .widget ul li a:hover,
.sidebar-widget-area .widget ul li.active a,
.sidebar-widget-area .widget ul li.active a:before,
.sidebar-widget-area .widget_recent_comments ul li.recentcomments > span:before,
.footer-top-area .search-form input.search-submit,
.footer-top-area ul li:before,
.footer-top-area ul li a:before {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.footer-top-area .corporate-address li i ,
.footer-top-area .search-form input.search-submit,
.footer-top-area ul li a:before,
.footer-top-area .stylish-input-group .input-group-addon button i,
.footer-top-area .widget_archive li a:before {
  color: <?php echo esc_html( $primary_color ); ?>;
}
.footer-top-area .stylish-input-group .input-group-addon button:hover {
	background: <?php echo esc_html( $primary_color ); ?>;
}
.rt-box-title-1,
.footer-top-area .search-form button {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.footer-topbar ,
.footer-topbar .emergrncy-content-holder,
.footer-top-area .widgettitle:after {
	background: <?php echo esc_html( $primary_color ); ?>;
}
.footer-topbar .emergrncy-content-holder:before {
	border-color: transparent <?php echo esc_html( $primary_color ); ?>;
}
<?php
/*-------------------------------------
#. Inner Contents
---------------------------------------*/
?>
a:link,
a:visited,
.entry-footer .about-author .media-body .author-title,
.entry-title h1 a{
	color: <?php echo esc_html( $primary_color );?>;
}
.entry-content a {
    color:<?php echo esc_html( $primary_color );?>;
}
.entry-footer .tags a:hover,
.entry-title h1 a:hover {
	color: <?php echo esc_html( $secondery_color );?>;
}
.comments-area .main-comments .replay-area a {
	background-color: <?php echo esc_html( $primary_color );?>;
}
#respond form .btn-send {
	background-color: <?php echo esc_html( $primary_color );?>;
	border-color: <?php echo esc_html( $primary_color );?>;
}
.blog-style-2 .readmore-btn:hover {
	background-color: <?php echo esc_html( $primary_color );?>;
	color: #ffffff;
}
blockquote p:before{	
	color: <?php echo esc_html( $primary_color );?>;
}
.sticky .blog-box {
  border-bottom: 2px solid <?php echo esc_html( $primary_color );?>;
}
.blog-box .blog-img-holder:after {
  background: <?php echo esc_html( $primary_color );?>;
}
.blog-box .blog-img-holder .blog-content-holder {
  background: <?php echo esc_html( $primary_color );?>;
}
.blog-box .blog-bottom-content-holder h3 a:hover ,
.blog-box .blog-bottom-content-holder ul li i ,
.blog-box .blog-bottom-content-holder ul li a:hover {
  color: <?php echo esc_html( $primary_color );?>;
}
.blog-box .blog-bottom-content-holder a.blog-button {
  border: 1px solid <?php echo esc_html( $primary_color );?>;
  color: <?php echo esc_html( $primary_color );?>;
}
.blog-box .blog-bottom-content-holder a.blog-button:hover {
  background-color: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-------------------------------------
#. Error 404
---------------------------------------*/
?>
.error-page-area {
   background-color: <?php echo esc_html( BartaTheme::$options['error_bodybg'] );?>;
}
.error-page-area .error-page-content p {	
	color: <?php echo esc_html( BartaTheme::$options['error_text2_color'] );?>;
}
.error-page-area .error-page p {
	color: <?php echo esc_html( BartaTheme::$options['error_text1_color'] );?>;
}
.error-page-area .error-page-content .go-home a {
	background-color: <?php echo esc_html( $primary_color );?>;
}

<?php
/*-------------------------------------
#. Comment
---------------------------------------*/
?>
.comments-area h3:before{
	background: <?php echo esc_html( $secondery_color );?>;
}
#respond form .btn-send:hover {
  color: <?php echo esc_html( $primary_color );?>;
}
.item-comments .item-comments-list ul.comments-list li .comment-reply {
  background-color: <?php echo esc_html( $primary_color );?>;
}
.item-comments .item-comments-form .comments-form .form-group .form-control {
  background-color: <?php echo esc_html( $secondery_color );?>;
}
.title-bar35:after {
	background: <?php echo esc_html( $primary_color );?>;
}
<?php
/*------------------------------------
#. Buttons
------------------------------------*/
?>
.barta-button-1,
.entry-content a.grid-fill-btn:hover:after,
.entry-content .rt-grid-fill-btn a.grid-fill-btn:hover:after {
	color: <?php echo esc_html( $primary_color );?>;	
}
.barta-button-1:hover {
	background: <?php echo esc_html( $primary_color );?>;
}
.barta-button-2 {
	background: <?php echo esc_html( $primary_color );?>;
}
.barta-button-2:hover {
	color: <?php echo esc_html( $primary_color );?>;
}
.barta-primary-color {
	color: <?php echo esc_html( $primary_color );?>;
}
.btn-read-more-h-b {
	border: 1px solid <?php echo esc_html( $primary_color );?>;
}
.con-home-6 .btn-send-message {
	background: <?php echo esc_html( $primary_color );?>;
	border: 2px solid <?php echo esc_html( $primary_color );?>;
}
.con-home-6 .btn-send-message:hover,
.dark-button:after,
.btn-square-transparent:hover,
.entry-content .btn-square-transparent.more:hover {
	background: <?php echo esc_html( $primary_color );?>;
}
.dark-button:hover,
.btn-square-transparent {
	border-color: <?php echo esc_html( $primary_color );?>;
}
.btn-square-transparent {
	color: <?php echo esc_html( $primary_color );?>;
}
.entry-content .btn-square-transparent.more {
	color: <?php echo esc_html( $primary_color );?>;
}
.btn-slider-fill {
	background: <?php echo esc_html( $primary_color );?>;
	border: 2px solid <?php echo esc_html( $primary_color );?> !important;
}
.dark-button:before {
    background: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-------------------------------------
#. Single Content
---------------------------------------*/
?>
.entry-header .entry-meta ul li a:hover ,
.entry-footer ul.item-tags li a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}
.ui-cat-tag {
    background: <?php echo esc_html( $primary_color );?>;
}
.entry-footer .item-tags span {
    border: 1px solid <?php echo esc_html( $primary_color );?>;
    background: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-------------------------------------
#. Archive Contents
---------------------------------------*/
?>
.blog-layout-1 .entry-header .entry-thumbnail-area .post-date1 {
	background: <?php echo esc_html( $primary_color );?>;
}
.blog-layout-1 .entry-header .entry-content h3 a:hover {
  color: <?php echo esc_html( $primary_color );?>;
}
.blog-layout-1 .entry-header .entry-content .barta-button-7 {
  background: <?php echo esc_html( $primary_color );?>;
}
.custom-search-input .btn {
  background-color: <?php echo esc_html( $primary_color );?>;
}
.search-no-results .custom-search-input .btn {
  background-color: <?php echo esc_html( $primary_color );?>;
}
.rt-blog-layout .entry-thumbnail-area ul li i {
  color: <?php echo esc_html( $primary_color );?>;
}
.rt-blog-layout .entry-thumbnail-area ul li a:hover {
  color: <?php echo esc_html( $primary_color );?>;
}
.rt-blog-layout .entry-thumbnail-area ul .active {
  background: <?php echo esc_html( $primary_color );?>;
}
.rt-blog-layout .entry-content h3 a:hover {
  color: <?php echo esc_html( $primary_color );?>;
}
.blog-box .blog-social li a:hover i {
  color: <?php echo esc_html( $primary_color );?>;
}
<?php /*blog style 2*/ ?>
.blog-box .blog-img-holder .blog-content-holder {
  background: <?php echo esc_html( $primary_color );?>;
}
.blog-box .blog-bottom-content-holder h3 a:hover,
.blog-box .blog-bottom-content-holder ul li i,
.blog-box .blog-bottom-content-holder ul li a:hover {
  color: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-------------------------------------
#. Pagination
---------------------------------------*/
?>
.pagination-area li.active a:hover,
.pagination-area ul li.active a,
.pagination-area ul li a:hover,
.pagination-area ul li span.current{
	background-color: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-------------------------------------
#. Contact Form 7
---------------------------------------*/
?>
.rt-contact-info ul li a:hover {
  color: <?php echo esc_html( $primary_color );?>;	
}
.cf7-quote-submit input {
  border: 2px solid <?php echo esc_html( $secondery_color );?>;
}
.cf7-quote-submit input:hover {
  background-color: <?php echo esc_html( $secondery_color );?> !important;
}
.contact-form h2:after {
  background: <?php echo esc_html( $primary_color );?>;
}
.contact-form legend {
  color: <?php echo esc_html( $secondery_color );?>;
}
.rt-request-call-four .request-form-wrapper .request-form .request-form-input .form-group.margin-bottom-none .default-big-btn ,
.rt-request-call-four .request-form-wrapper .request-form .form-heading ,
.contact-form .wpcf7-submit.contact-submit,
.contact-slider .contact-header {
  background: <?php echo esc_html( $primary_color );?>;
}
.contact-form .wpcf7-submit.contact-submit:hover  {
  background: <?php echo esc_html( $secondery_color );?>;
}
.contact-slider .contact-header:after {
	border-top: 22px solid <?php echo esc_html( $primary_color );?>;
}
@media (max-width:1170px) {
	.contact-slider .contact-header:after {
		border-top: 22px solid <?php echo esc_html( $primary_color );?>;
	}
}
.contact-slider .input-form input[type="submit"] {
    background: <?php echo esc_html( $primary_color );?>;	
}
<?php
/*-------------------------------------
#. Feature Image Caption
---------------------------------------*/
?>
.entry-thumbnail-area.overimage .featured-image-caption.text-right,
.post-detail-style2 .overimage .featured-image-caption.text-right {
	background: -moz-linear-gradient(left, rgba(30,87,153,0) 0%, rgba(30,87,153,0.05) 1%, rgba(<?php echo esc_html( $primary_rgb );?>,1) 20%); /* FF3.6-15 */
	background: -webkit-linear-gradient(left, rgba(30,87,153,0) 0%,rgba(30,87,153,0.05) 1%,rgba(<?php echo esc_html( $primary_rgb );?>,1) 20%); /* Chrome10-25,Safari5.1-6 */
	background: linear-gradient(to right, rgba(30,87,153,0) 0%,rgba(30,87,153,0.05) 1%,rgba(<?php echo esc_html( $primary_rgb );?>,1) 20%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#001e5799', endColorstr='<?php echo esc_html( $primary_color );?>',GradientType=1 ); /* IE6-9 */
}
.entry-thumbnail-area.overimage .featured-image-caption.text-left,
.post-detail-style2 .overimage .featured-image-caption.text-left {
	background: -moz-linear-gradient(left, rgba(<?php echo esc_html( $primary_rgb );?>,1) 80%, rgba(30,87,153,0.05) 99%, rgba(30,87,153,0) 100%); /* FF3.6-15 */
	background: -webkit-linear-gradient(left, rgba(<?php echo esc_html( $primary_rgb );?>,1) 80%,rgba(30,87,153,0.05) 99%,rgba(30,87,153,0) 100%); /* Chrome10-25,Safari5.1-6 */
	background: linear-gradient(to right, rgba(<?php echo esc_html( $primary_rgb );?>,1) 80%,rgba(30,87,153,0.05) 99%,rgba(30,87,153,0) 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='<?php echo esc_html( $primary_color );?>', endColorstr='#001e5799',GradientType=1 ); /* IE6-9 */
}
.entry-thumbnail-area.overimage .featured-image-caption.text-center,
.post-detail-style2 .overimage .featured-image-caption.text-center {
	background: -moz-linear-gradient(left, rgba(<?php echo esc_html( $primary_rgb );?>,0) 0%, rgba(<?php echo esc_html( $primary_rgb );?>,0.8) 10%, rgba(<?php echo esc_html( $primary_rgb );?>,1) 19%, rgba(<?php echo esc_html( $primary_rgb );?>,1) 20%, rgba(<?php echo esc_html( $primary_rgb );?>,1) 81%, rgba(<?php echo esc_html( $primary_rgb );?>,0.8) 89%, rgba(<?php echo esc_html( $primary_rgb );?>,0) 100%); /* FF3.6-15 */
	background: -webkit-linear-gradient(left, rgba(<?php echo esc_html( $primary_rgb );?>,0) 0%,rgba(<?php echo esc_html( $primary_rgb );?>,0.8) 10%,rgba(<?php echo esc_html( $primary_rgb );?>,1) 19%,rgba(<?php echo esc_html( $primary_rgb );?>,1) 20%,rgba(<?php echo esc_html( $primary_rgb );?>,1) 81%,rgba(<?php echo esc_html( $primary_rgb );?>,0.8) 89%,rgba(<?php echo esc_html( $primary_rgb );?>,0) 100%); /* Chrome10-25,Safari5.1-6 */
	background: linear-gradient(to right, rgba(<?php echo esc_html( $primary_rgb );?>,0) 0%,rgba(<?php echo esc_html( $primary_rgb );?>,0.8) 10%,rgba(<?php echo esc_html( $primary_rgb );?>,1) 19%,rgba(<?php echo esc_html( $primary_rgb );?>,1) 20%,rgba(<?php echo esc_html( $primary_rgb );?>,1) 81%,rgba(<?php echo esc_html( $primary_rgb );?>,0.8) 89%,rgba(<?php echo esc_html( $primary_rgb );?>,0) 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#00e53935', endColorstr='#00e53935',GradientType=1 ); /* IE6-9 */
}
<?php
/*-------------------------------------
#. WooCommerce
---------------------------------------*/
?>
.woocommerce .widget_price_filter .ui-slider .ui-slider-range,
.woocommerce .widget_price_filter .ui-slider .ui-slider-handle,
.rt-woo-nav .owl-custom-nav-title::after,
.rt-woo-nav .owl-custom-nav .owl-prev:hover,
.rt-woo-nav .owl-custom-nav .owl-next:hover,
.woocommerce ul.products li.product .onsale,
.woocommerce span.onsale,
.woocommerce a.added_to_cart,
.woocommerce div.product form.cart .button,
.woocommerce #respond input#submit,
.woocommerce a.button,
.woocommerce button.button,
.woocommerce input.button,
p.demo_store,
.woocommerce-info::before,
.woocommerce #respond input#submit.disabled:hover,
.woocommerce #respond input#submit:disabled:hover,
.woocommerce #respond input#submit[disabled]:disabled:hover,
.woocommerce a.button.disabled:hover,
.woocommerce a.button:disabled:hover,
.woocommerce a.button[disabled]:disabled:hover,
.woocommerce button.button.disabled:hover,
.woocommerce button.button:disabled:hover,
.woocommerce button.button[disabled]:disabled:hover,
.woocommerce input.button.disabled:hover,
.woocommerce input.button:disabled:hover,
.woocommerce input.button[disabled]:disabled:hover,
.woocommerce #respond input#submit.alt,
.woocommerce a.button.alt,
.woocommerce button.button.alt,
.woocommerce input.button.alt,
.woocommerce-account .woocommerce .woocommerce-MyAccount-navigation ul li a {
	background-color: <?php echo esc_html( $primary_color );?>;
}
.woocommerce-message::before,
.woo-shop-top .view-mode ul li:first-child .fa,
.woo-shop-top .view-mode ul li:last-child .fa,
.woocommerce ul.products li.product h3 a:hover,
.woocommerce ul.products li.product .price,
.woocommerce .product-thumb-area .product-info ul li a:hover .fa,
.woocommerce div.product p.price,
.woocommerce div.product span.price,
.woocommerce div.product .product-meta a:hover,
.woocommerce div.product .woocommerce-tabs ul.tabs li.active a,
.woocommerce a.woocommerce-review-link:hover {
	color: <?php echo esc_html( $primary_color );?>;
}
.woocommerce-message,
.woocommerce-info {
	border-color: <?php echo esc_html( $primary_color );?>;
}
.woocommerce .product-thumb-area .overlay {
	background-color: rgba(<?php echo esc_html( $primary_rgb );?>, 0.8);
}
.header-style-1 .header-icon-area .cart-icon-area .cart-icon-num {
	background-color: <?php echo esc_html( $primary_color );?>;
}
<?php
/*----------------------
#. Miscellaneous
----------------------*/
?>
.post-navigation .next-article i,
.post-navigation .next-article:hover,
.post-navigation .prev-article i,
.post-navigation .prev-article:hover,
.post-navigation .post-nav-title a:hover,
.rt-drop ,
.post-detail-style3 .breadcrumbs-area2 .breadcrumbs-content ul li,
.post-detail-style3 .breadcrumbs-area2 .breadcrumbs-content ul li a, 
.post-detail-style3 .breadcrumbs-area2 .breadcrumbs-content ul li a:hover,
.breadcrumbs-area2 .breadcrumbs-content h3 a:hover,
.post-detail-style3 .post-3-no-img-meta ul.post-info-light li a:hover,
.post-detail-style3 .entry-meta li a:hover,
.sidebar-widget-area .widget .corporate-address li i,
.sidebar-widget-area .widget .corporate-address li i.fa-map-marker,
.rt-news-box .post-cat span a:hover,
.rt-news-box .topic-box .post-date1 span a:hover,
.rt_widget_recent_entries_with_image .topic-box .post-date1 span a:hover,
.sidebar-widget-area .widget.title-style-1 h3.widgettitle,
.rt_widget_recent_entries_with_image .topic-box .widget-recent-post-title a:hover,
.search-form input.search-submit,
.header-style-5.trheader .header-social li a:hover,
.header-style-5 .header-social li a:hover,
.header-style-5 .header-contact .fa,
.header-style-4.trheader .header-social li a:hover,
.header-style-4 .header-social li a:hover,
.header-style-4 .header-contact .fa,
.header-style-3.trheader .header-social li a:hover,
.header-style-3.trheader.non-stickh .header-social li a:hover ,
.header-style-3 .header-social li a:hover,
.header-style-3 .header-contact .fa,
.header-style-2.trheader .header-social li a:hover,
.header-style-2.trheader.non-stickh .header-social li a:hover,
blockquote p:before,
ul.news-info-list li i,
.post-navigation .prev-article i,
.post-navigation .next-article i,
.about-author .media-body .author-title a:hover,
.non-stickh .site-header .rt-sticky-menu .main-navigation nav > ul > li > a:hover,
.header-style-2 .header-contact .fa,
.header-style-2 .header-social li a:hover,
.search-form input.search-submit:hover,
.sidebar-widget-area .rt-news-tab .entry-title a:hover,
.rt-cat-list-widget li:hover a ,
.footer-top-area .corporate-address li i,
.elementor-widget-wp-widget-categories ul li:hover a,
.footer-top-area .widget_archive li a:before,
.footer-top-area .rt_footer_social_widget .footer-social li:hover i ,
.footer-top-area .widget_tag_cloud a:hover,
.footer-top-area .search-form input.search-submit,
.entry-header .entry-meta ul li a:hover,
.ui-cat-tag a:hover,
.entry-post-meta .post-author a:hover,
.news-details-layout2 .post-info-light ul li a:hover,
.news-details-layout2 .entry-meta li a:hover,
.about-author ul.author-box-social a,
.rt-related-post-info .post-title a:hover,
.entry-title a:hover, 
.custom-search-input .btn,
.comments-area .main-comments .comment-meta .comment-author-name a:hover,
.rt-blog-layout .entry-thumbnail-area ul li i,
.rt-blog-layout .entry-thumbnail-area ul li a:hover,
.rt-blog-layout .entry-content h3 a:hover,
.blog-layout-1 .entry-content h3 a:hover,
.blog-layout-1 .entry-meta ul li a:hover,
.blog-layout-2 .blog-bottom-content-holder ul li a:hover,
.blog-layout-2 .blog-bottom-content-holder h3 a:hover,
.blog-layout-3 .entry-content h3 a:hover,
.blog-layout-3 .entry-meta ul li a:hover,
.blog-box .blog-bottom-content-holder h3 a:hover,
.blog-box .blog-bottom-content-holder ul li i,
.blog-box .blog-bottom-content-holder ul li a:hover,
.error-page-area .error-page-content .go-home a:hover,
.footer-top-area .rt-news-box .dark .rt-news-box-widget .media-body a:hover
 {
	color: <?php echo esc_html( $primary_color );?>;
}
.rt-box-title-2,.blog-box .blog-img-holder .blog-content-holder, .blog-box .blog-bottom-content-holder a.blog-button:hover,
button, input[type="button"], input[type="reset"], input[type="submit"], #tophead .tophead-social li a:hover, .topbar-style-2 #tophead .tophead-social li a:hover, .additional-menu-area .sidenav ul li a:hover, .sidebar-widget-area .widget.title-style-1 h3.widgettitle, .sidebar-widget-area .widget_recent_entries ul li:before, .sidebar-widget-area .widget_archive ul li:before, .sidebar-widget-area .widget_meta ul li:before, .mc4wp-form, .rt-cat-list-widget li:before, .elementor-widget-wp-widget-categories ul li:before, .footer-top-area .widgettitle:after, .cat-holder-text , .comments-area .main-comments .replay-area a, .search-no-results .custom-search-input .btn, .rt-blog-layout .entry-thumbnail-area ul .active, .blog-layout-2 .blog-img-holder:after,.blog-box .blog-img-holder:after, .woocommerce nav.woocommerce-pagination ul li a:hover, .pagination-area ul li a:hover, 
.woocommerce nav.woocommerce-pagination ul li .current, .pagination-area ul li .current, .woocommerce nav.woocommerce-pagination ul li.active a, .pagination-area ul li.active a, .footer-bottom-social ul li a:hover, .sidebar-widget-area .widget_search form button:hover {
    background-color: <?php echo esc_html( $primary_color );?>;
}
.news-details-layout2 .cat-holder:before {
    border-top: 8px solid <?php echo esc_html( $primary_color );?>;
}
.about-author ul.author-box-social li:hover,
.footer-top-area .widget_tag_cloud a:hover, .sidebar-widget-area .rt-news-tab .btn-tab .active {
	background-color: <?php echo esc_html( $primary_color );?> !important;
	border: 1px solid <?php echo esc_html( $primary_color );?> !important;
}
.entry-content .wpb_layerslider_element a.layerslider-button, .comments-area h3.comment-num:after {	background: <?php echo esc_html( $primary_color );?>; }
.entry-content .btn-read-more-h-b, .woocommerce nav.woocommerce-pagination ul li span, .pagination-area ul li span 
.header-style-10.trheader #tophead .tophead-social li a:hover {
    border: 1px solid <?php echo esc_html( $primary_color );?>;
}
.footer-top-area .widget_archive li {
	border-bottom: 1px dotted <?php echo esc_html( $primary_color );?>;
}
.bottomBorder {
    border-bottom: 2px solid <?php echo esc_html( $primary_color ); ?>;
}
blockquote {
	border-color: <?php echo esc_html( $primary_color ); ?>;
}
.search-form input.search-field, #respond form textarea:focus {
	border-color: <?php echo esc_html( $primary_color ); ?>;
}
.search-form input.search-submit, #respond form .btn-send  {
	background-color: <?php echo esc_html( $primary_color ); ?>;
	border: 2px solid <?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .widget.title-style-1 h3.widgettitle span {
	border-top: 10px solid <?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .widget_tag_cloud a:hover {
	background-color: <?php echo esc_html( $primary_color ); ?>;
	border: 1px solid <?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .rt-news-tab .btn-tab .active , .contact-form input[type="submit"] {
    border: 1px solid <?php echo esc_html( $primary_color ); ?>!important;
    background-color: <?php echo esc_html( $primary_color ); ?>!important;
}
.pagination-area ul li.active a, .pagination-area ul li a:hover {
    background-color: <?php echo esc_html( $primary_color ); ?>!important;
}
.cat-holder:before {
    border-top: 8px solid <?php echo esc_html( $primary_color ); ?>;
}
.contact-form .form-group .wpcf7-submit:hover {
	background-color: transparent !important;
    color: <?php echo esc_html( $primary_color ); ?> !important;
}

<?php
/*----------------------
#. ticker
----------------------*/
if( !empty ( $ticker_title_bgcolor ) ) {
	$t_bg_color = $ticker_title_bgcolor;
} else {
	$t_bg_color = $primary_color;
}
?>
.ticker-title {
    background: <?php echo esc_html( $t_bg_color ); ?>;
}
.ticker-title .boltu-right {
	border-top: 8px solid <?php echo esc_html( $t_bg_color ); ?>;
}
.ticker-content a:hover {
	color: <?php echo esc_html( $primary_color ); ?> !important;
}
<?php
/*-------------------
#. Scroll Indicator
-------------------*/
?>
.single .barta-progress-container {
	height: <?php echo BartaTheme::$options['scroll_indicator_height']; ?>px;
	background: <?php echo BartaTheme::$options['scroll_indicator_bgcolor']; ?>;
	position: fixed;
	top: 0px;
}
<?php if ( BartaTheme::$options['scroll_indicator_position'] == 'top' ) { ?>
.single.admin-bar.scroll_indicator_on .rt-sticky-menu {
	top: <?php echo BartaTheme::$options['scroll_indicator_height'] + 32; ?>px;
}
<?php } else { ?>
.single.admin-bar.scroll_indicator_on .rt-sticky-menu {
	top: 32px;
}
<?php } ?>
.single.admin-bar .barta-progress-container.bottom {
    bottom: 0 !important;
    top: initial !important;
}
.single .barta-progress-bar {
	height: <?php echo BartaTheme::$options['scroll_indicator_height']; ?>px;
	background: <?php echo BartaTheme::$options['scroll_indicator_active_bgcolor']; ?>; 
	width: 0%;
}