<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
// Layout class
if ( BartaTheme::$layout == 'full-width' ) {
	$barta_layout_class = 'col-lg-12 col-xs-12';
}
else{
	$barta_layout_class = 'col-lg-9 col-md-12';
}
?>
<?php get_header(); ?>
<div id="primary" class="content-area">
	<div class="container">
		<div class="row">
			<?php
			if ( BartaTheme::$layout == 'left-sidebar' ) {
				get_sidebar();
			}
			?>
			<div class="<?php echo esc_attr( $barta_layout_class );?>">
				<main id="main" class="site-main">
					<div class="rt-search-post">
						<ul class="search-item-holder">
							<?php if ( have_posts() ) :?>
									<?php while ( have_posts() ) : the_post();
										$excerpt_length = BartaTheme::$options['search_excerpt_length'];
										get_template_part( 'template-parts/content', 'search' );
									?>
									<?php endwhile; ?>
								<?php BartaTheme_Helper::pagination();?>
							<?php else:?>
								<?php get_template_part( 'template-parts/content', 'none' );?>
							<?php endif;?>
						</ul>
					</div>
				</main>					
			</div>
			<?php
			if ( BartaTheme::$layout == 'right-sidebar' ) {
				get_sidebar();
			}
			?>
		</div>
	</div>
</div>
<?php get_footer(); ?>