<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$barta_has_entry_meta  = ( ( !has_post_thumbnail() && BartaTheme::$options['blog_date'] ) || BartaTheme::$options['blog_author_name'] || BartaTheme::$options['blog_comment_num'] || BartaTheme::$options['blog_cats'] ) ? true : false;
$thumb_size = 'barta-size8';
$barta_comments_number = number_format_i18n( get_comments_number() );
$barta_comments_html = $barta_comments_number < 2 ? esc_html__( 'Comment' , 'barta' ) : esc_html__( 'Comments' , 'barta' );
$barta_comments_html = '('. $barta_comments_number . ') ' . $barta_comments_html;

$thumbnail = false;
$post_image = '';
$post_layout_class = '';
if ( !( has_post_thumbnail() ) && BartaTheme::$options['display_no_preview_image'] == 'off' ) {	
	$post_layout_class = 'col-lg-12 col-md-12';	
} else {
	$post_layout_class = 'col-lg-7 col-md-12';	
}
if ( BartaTheme::$layout != 'full-width' ) {	
	$post_image = 'col-lg-5 col-md-12 col-sm-12 col-xs-12';	
} else {
	$post_image = 'col-lg-5 col-md-5 col-sm-4 col-xs-12';
}
	$id = get_the_ID();
	$content = get_the_content();
	$content = apply_filters( 'the_content', $content );
	$content = wp_trim_words( $content, BartaTheme::$options['post_content_limit'] );				
?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'row entry-header blog-layout-1 kk' ); ?>>
	<?php if ( has_post_thumbnail() || BartaTheme::$options['display_no_preview_image'] == '1'  ) { ?>
		<div class="<?php echo esc_attr( $post_image ); ?>">
			<div class="entry-thumbnail-area">
				<a href="<?php the_permalink(); ?>" class="img-opacity-hover img-overlay-70"><?php if ( has_post_thumbnail() ) { ?>
					<?php the_post_thumbnail( 'barta-size8', ['class' => 'img-responsive'] );?>
				<?php } else {
					if ( BartaTheme::$options['display_no_preview_image'] == '1' ) {
						if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
							$thumbnail = wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size );						
						}
						elseif ( empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
							$thumbnail = '<img class="attachment-barta-size5 size-barta-size5 wp-post-image" src="'.BARTA_IMG_URL.'noimage-560x404.jpg" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
						}
						echo wp_kses_post( $thumbnail );				
					}
				}
				?></a>
				<?php if ( BartaTheme::$options['blog_cats'] ) { ?><?php echo barta_category_prepare(); ?><?php } ?>
			</div>
		</div>
	<?php } ?>
	<div class="<?php echo esc_attr( $post_layout_class ); ?>">
	<?php if ( $barta_has_entry_meta ) { ?>
		<div class="entry-meta">
			<ul>
				<?php if ( BartaTheme::$options['blog_author_name'] ) { ?>
					<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link();?></li>
				<?php } ?>
				<?php if ( BartaTheme::$options['blog_date'] ) { ?>
					<li><i class="fa fa-clock-o" aria-hidden="true"></i><?php echo get_the_time( get_option( 'date_format' ) ); ?></li>
				<?php } ?>
				<?php if ( BartaTheme::$options['blog_comment_num'] ) { ?>
					<li><i class="fa fa-comment-o" aria-hidden="true"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo esc_html( $barta_comments_html );?></a></li>
				<?php } ?>
			</ul>
		</div>
	<?php } ?>
		<div class="entry-content">
			<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
			<div class="blog-text"><?php echo wp_kses_post( $content ); ?></div>
		</div>
	</div>	
</div>