<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$barta_has_entry_meta  = ( ( !has_post_thumbnail() && BartaTheme::$options['blog_date'] ) || BartaTheme::$options['blog_author_name'] || BartaTheme::$options['blog_comment_num'] || BartaTheme::$options['blog_cats'] ) ? true : false;
$barta_time_html       = sprintf( '%s<span>%s</span><span>%s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );
$barta_time_html       = apply_filters( 'barta_single_time', $barta_time_html );
$barta_time_html_2     = apply_filters( 'barta_single_time_no_thumb', get_the_time( get_option( 'date_format' ) ) );

$barta_comments_number = number_format_i18n( get_comments_number() );
$barta_comments_html = $barta_comments_number < 2 ? esc_html__( 'Comment' , 'barta' ) : esc_html__( 'Comments' , 'barta' );
$barta_comments_html = '('. $barta_comments_number . ') ' . $barta_comments_html;
?>
<div id="post-<?php the_ID(); ?>" <?php post_class('blog-layout-3 blog-layout'); ?> data-layout="<?php echo esc_attr( BartaTheme::$layout ); ?>">
	<div class="entry-header">
		<?php if ( has_post_thumbnail() ) { ?>
			<div class="entry-thumbnail-area">
				<a href="<?php the_permalink(); ?>" class="img-opacity-hover"><?php if ( has_post_thumbnail() ) { ?>
					<?php the_post_thumbnail( 'barta-size1', ['class' => 'img-responsive'] );?>
				<?php } else {
					if ( BartaTheme::$options['display_no_preview_image'] == '1' ) {
						if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
							$thumbnail = wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size );
						}
						elseif ( empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
							$thumbnail = '<img class="attachment-barta-size1 size-barta-size1 wp-post-image" src="'.BARTA_IMG_URL.'noimage.jpg" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
						}
						echo wp_kses_post( $thumbnail );
					}
				}
				?></a>
				<?php if ( BartaTheme::$options['blog_cats'] ) { ?><?php echo barta_category_prepare(); ?><?php } ?>
			</div>
		<?php } ?>
		<div class="entry-content">		
			<?php if ( $barta_has_entry_meta ) { ?>
				<div class="entry-meta">
					<ul>
						<?php if ( BartaTheme::$options['blog_author_name'] ) { ?>
							<li><span><i class="fa fa-user" aria-hidden="true"></i></span><?php the_author_posts_link();?></li>
						<?php } ?>
						<?php if ( BartaTheme::$options['blog_date'] ) { ?>
							<li><i class="fa fa-clock-o" aria-hidden="true"></i><?php echo get_the_time( get_option( 'date_format' ) ); ?></li>
						<?php } ?>
						<?php if ( BartaTheme::$options['blog_comment_num'] ) { ?>
							<li><i class="fa fa-comment-o" aria-hidden="true"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo esc_html( $barta_comments_html );?></a></li>
						<?php } ?>
					</ul>
				</div>
			<?php } ?>
			<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
			<?php the_excerpt();?>
			<a class="dark-button" href="<?php the_permalink(); ?>"><span><?php esc_html_e( 'Read More', 'barta' ); ?></span></a>			
		</div>
	</div>
</div>
