<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;
?>
<div class="rt-el-counter rtin-<?php echo esc_attr( $data['theme'] );?>">
	<div class="rtin-item clearfix">
		<div class="rtin-left">
			<?php if ( $data['icontype'] == 'image' ): ?>
				<?php
				if ( !empty( $data['image']['id'] ) ) {
					echo wp_get_attachment_image( $data['image']['id'], 'full', true );
				}
				?>
			<?php else: ?>
				<i class="<?php echo esc_attr( $data['icon'] );?>" aria-hidden="true"></i>
			<?php endif; ?>
		</div>
		<div class="rtin-right">
			<div class="rtin-counter" style="color:<?php echo esc_attr( $data['number_color'] );?>"><span class="rt-counter-num" data-num="<?php echo esc_attr( $data['number'] );?>" data-rtspeed="<?php echo esc_attr( $data['speed'] );?>" data-rtsteps="<?php echo esc_attr( $data['steps'] );?>"><?php echo esc_html( $data['number'] );?></span><?php echo esc_html( $data['suffix'] );?></div>
			<div class="rtin-title" style="color:<?php echo esc_attr( $data['title_color'] );?>"><?php echo esc_html( $data['title'] );?></div>
		</div>	
	</div>
</div>