<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $attr . '>' . $data['title'] . '</a>';
	
}
else {
	$title = $data['title'];
}

if ( !empty( $data['buttontext'] ) ) {
	$btn = '<a class="read-more-arrow" ' . $attr . '>' . $data['buttontext'] . '</a>';
}

if ( $data['image'] ) {
	$size = BARTA_CORE_THEME_PREFIX . '-size2';
	if ( $attr ) {
		$img = '<a ' . $attr . '>' . wp_get_attachment_image( $data['image']['id'], $size ) . '</a>';
	}
	else {
		$img = wp_get_attachment_image( $data['image']['id'], $size );
	}
}



?>
<div class="rt-el-image-content">
	<div class="image-content-wrap rtin-<?php echo esc_attr( $data['position'] );?>">
	
		<?php if ( $data['position'] == 'image-top') { ?>
			<?php if ( !empty ( $data['image'] ) ) { ?>
			<div class="rtin-media">
				<?php echo $img;?>
			</div>
			<?php } ?>
			<div class="rtin-content">
				<div class="color-accent">
					<?php if ( !empty( $data['title'] ) ) { ?>
					<h3 class="rtin-title"><?php echo wp_kses_post( $title );?></h3>
					<?php } ?>
					<?php if ( !empty( $data['content'] ) ) { ?>
					<p class="rtin-text"><?php echo wp_kses_post( $data['content'] );?></p>
					<?php } ?>
					<?php if ( !empty( $data['buttontext'] )) { ?>
					<?php if ( $btn ): ?>
						<div class="rtin-button"><?php echo wp_kses_post( $btn );?></div>		
					<?php endif; ?>
					<?php } ?>
				</div>
			</div>
		<?php } ?>
		
		<?php if ( $data['position'] == 'image-left') { ?>
			<div class="row align-position">
				<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
					<?php if ( !empty ( $data['image'] ) ) { ?>
					<div class="rtin-media">
						<?php echo $img;?>
					</div>
					<?php } ?>
				</div>
				<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
					<div class="rtin-content">
						<div class="color-accent">
							<?php if ( !empty( $data['title'] ) ) { ?>
							<h3 class="rtin-title"><?php echo wp_kses_post( $title );?></h3>
							<?php } ?>
							<?php if ( !empty( $data['content'] ) ) { ?>
							<p class="rtin-text"><?php echo wp_kses_post( $data['content'] );?></p>
							<?php } ?>
							<?php if ( !empty( $data['buttontext'] )) { ?>
							<?php if ( $btn ): ?>
								<div class="rtin-button"><?php echo wp_kses_post( $btn );?></div>		
							<?php endif; ?>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		<?php } ?>
		
		<?php if ( $data['position'] == 'image-right') { ?>
			<div class="row align-position">
				<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
					<div class="rtin-content">
						<div class="color-accent">
							<?php if ( !empty( $data['title'] ) ) { ?>
							<h3 class="rtin-title"><?php echo wp_kses_post( $title );?></h3>
							<?php } ?>
							<?php if ( !empty( $data['content'] ) ) { ?>
							<p class="rtin-text"><?php echo wp_kses_post( $data['content'] );?></p>
							<?php } ?>
							<?php if ( !empty( $data['buttontext'] )) { ?>
							<?php if ( $btn ): ?>
								<div class="rtin-button"><?php echo wp_kses_post( $btn );?></div>		
							<?php endif; ?>
							<?php } ?>
						</div>
					</div>
				</div>
				<div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
					<?php if ( !empty ( $data['image'] ) ) { ?>
					<div class="rtin-media">
						<?php echo $img;?>
					</div>
					<?php } ?>
				</div>
			</div>
		<?php } ?>
		
		<?php if ( $data['position'] == 'image-bottom' ) { ?>
			<?php if ( !empty ( $data['image'] ) ) { ?>
			<div class="rtin-media mobile-show">
				<?php echo $img;?>
			</div>
			<?php } ?>
			<div class="rtin-content">
				<div class="color-accent">
					<?php if ( !empty( $data['title'] ) ) { ?>
					<h3 class="rtin-title"><?php echo wp_kses_post( $title );?></h3>
					<?php } ?>
					<?php if ( !empty( $data['content'] ) ) { ?>
					<p class="rtin-text"><?php echo wp_kses_post( $data['content'] );?></p>
					<?php } ?>
					<?php if ( !empty( $data['buttontext'] )) { ?>
					<?php if ( $btn ): ?>
						<div class="rtin-button"><?php echo wp_kses_post( $btn );?></div>		
					<?php endif; ?>
					<?php } ?>
				</div>
			</div>
			<?php if ( !empty ( $data['image'] ) ) { ?>
			<div class="rtin-media desktop-show">
				<?php echo $img;?>
			</div>
			<?php } ?>
		<?php } ?>
			
	</div>
</div>












