<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use \WP_Query;
use radiustheme\Barta\BartaTheme;
use radiustheme\Barta\Helper;

$prefix      = BARTA_CORE_THEME_PREFIX;
$cpt         = BARTA_CORE_CPT_PREFIX;
$thumb_size  = "{$prefix}-size2";

$args = array(
	'posts_per_page' => $data['number'],
	'cat'            => (int) $data['cat'],
	'orderby'        => $data['orderby'],
	'posts_per_page' => $data['itemlimit'],
);


switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}


$query = new WP_Query( $args );

$temp = Helper::wp_set_temp_query( $query );

$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-xs-{$data['col_xs']}";
?>
<div class="post-grid-3">
	<div class="row">
	<?php if ( $query->have_posts() ) :?>
		<?php while ( $query->have_posts() ) : $query->the_post();?>
			<?php
			$content = Helper::get_current_post_content();
			$content = wp_trim_words( $content, $data['count'] );
			$content = "<p>$content</p>";

			$comments_number = number_format_i18n( get_comments_number() );
			$comments_html   = $comments_number < 2 ? __( 'Comment' , 'barta-core' ) : __( 'Comments' , 'barta-core' );
			$comments_html  .= ': '. $comments_number;
			?>

				<div class="<?php echo esc_attr( $col_class );?>">
					<div class="rtin-single-post">
						<div class="rtin-img">
							<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( $thumb_size );
								}
								else {
									if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size );
									}
									else {
										echo '<img class="wp-post-image" src="' . Helper::get_img( 'noimage_492x330.jpg' ) . '" alt="'.get_the_title().'">';
									}
								}
							?>
						</div>
						<div class="rtin-content">
							<span class="rtin-date"><?php echo the_time('d F, Y'); ?></span>
							<h3 class="rtin-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
							<?php echo wp_kses_post( $content );?>
							<a class="barta-button-3" href="<?php the_permalink();?>"><?php esc_html_e( 'Read More' , 'barta-core'); ?></a>
						</div>
					</div>
				</div>

		<?php endwhile;?>
	</div>
	<?php endif;?>
	<?php Helper::wp_reset_temp_query( $temp );?>
</div>






