<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class Image_Content extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Image Content', 'barta-core' );
		$this->rt_base = 'rt-image-content';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => __( 'General', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'position',
				'label'   => __( 'Position', 'barta-core' ),
				'options' => array(
					'image-left' => __( 'Image Left', 'barta-core' ),
					'image-right' => __( 'Image Right', 'barta-core' ),
					'image-top' => __( 'Image Top', 'barta-core' ),
					'image-bottom' => __( 'Image Bottom', 'barta-core' ),
				),
				'default' => 'image-left',
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'image',
				'label'   => __( 'Image', 'barta-core' ),
				'description' => __( 'Recommended image size is 67x67 px', 'barta-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => __( 'Title', 'barta-core' ),
				'default' => 'Lorem Ipsum',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'content',
				'label'   => __( 'Content', 'barta-core' ),
				'default' => 'Lorem Ipsum hasbeen standard daand scrambled. Rimply dummy text of the printing and typesetting industry',
			),
			array(
				'type'  => Controls_Manager::URL,
				'id'    => 'url',
				'label' => __( 'Link (Optional)', 'barta-core' ),
				'placeholder' => 'https://your-link.com',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'buttontext',
				'label'   => __( 'Button Text', 'barta-core' ),
				'default' => 'Read More',
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template = 'image-content';

		return $this->rt_template( $template, $data );
	}
}