<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $attr . '>' . $data['title'] . '</a>';
	
}
else {
	$title = $data['title'];
}

if ( !empty( $data['buttontext'] ) ) {
	$btn = '<a class="barta-button-3" ' . $attr . '>' . $data['buttontext'] . '</a>';
}

// Style 3,4
if ( $data['style'] == 'style3' || $data['style'] == 'style4' || $data['style'] == 'style7' ) {
	$size = BARTA_CORE_THEME_PREFIX . '-size2';
	if ( $attr ) {
		$img = '<a ' . $attr . '>' . wp_get_attachment_image( $data['image-alt']['id'], $size ) . '</a>';
	}
	else {
		$img = wp_get_attachment_image( $data['image-alt']['id'], $size );
	}
}

// icon , image
if ( $data['icontype'] == 'icon' || $data['icontype'] == 'image' ) {
	$size = BARTA_CORE_THEME_PREFIX . '-size2';
	if ( $attr ) {
		$img = '<a ' . $attr . '>' . wp_get_attachment_image( $data['image-alt']['id'], $size ) . '</a>';
	}
	else {
		$img = wp_get_attachment_image( $data['image-alt']['id'], $size );
	}
}



?>
<div class="rt-el-info-box clearfix media rtin-<?php echo esc_attr( $data['style'] );?>">
	<div class="rtin-<?php echo esc_attr( $data['icontype'] );?>">
		<div class="rtin-media">
			<span>
			<?php if ( $data['style'] == 'style3' || $data['style'] == 'style4' || $data['style'] == 'style7' ): ?>
				<?php echo $img;?>
			<?php else: ?>
				<?php if ( $data['icontype'] == 'image' ): ?>
					<?php echo wp_get_attachment_image( $data['image']['id'] );?>
				<?php else: ?>
					<i class="<?php echo esc_attr( $data['icon'] );?>" aria-hidden="true"></i>
				<?php endif; ?>
			<?php endif; ?>
			</span>
		</div>
		<div class="media-body rtin-content">
			<?php if ( !empty( $data['interest'] ) ) { ?>
			<p class="interest"><?php echo wp_kses_post ( $data['interest'] );?></p>
			<?php } ?>
			<?php if ( !empty( $data['title'] ) ) { ?>
			<h3 class="media-heading rtin-title"><?php echo wp_kses_post( $title );?></h3>
			<?php } ?>
			<?php if ( !empty( $data['content'] ) ) { ?>
			<p class="rtin-text"><?php echo wp_kses_post( $data['content'] );?></p>
			<?php } ?>
			<?php if ( $data['style'] == 'style5' ) { ?>
				<?php if ( !empty( $data['moreurl'] ) ) { ?>
					<a class="rtin-more" href="<?php echo esc_attr ( $data['moreurl']['url'] );?>" ><i class="fa fa-angle-right" aria-hidden="true"></i></a>
				<?php } ?>
			<?php } ?>
			<?php if ( $data['style'] == 'style7' ) { ?>
			<?php if ( $btn ): ?>
				<div class="rtin-button"><?php echo wp_kses_post( $btn );?></div>		
			<?php endif; ?>
			<?php } ?>
		</div>
	</div>
</div>