<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Barta_Core;

use \WP_Query;
use radiustheme\Barta\BartaTheme;
use radiustheme\Barta\Helper;

$thumb_size_small = BARTA_CORE_THEME_PREFIX . '-size7';
$thumb_size_big = BARTA_CORE_THEME_PREFIX . '-size8';

$args = array(
	'posts_per_page' => $data['number'],
	'cat'            => (int) $data['cat'],
	'orderby'        => $data['orderby'],
	'posts_per_page' => $data['itemlimit'],
);


switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );

$temp = Helper::wp_set_temp_query( $query );

$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-xs-{$data['col_xs']}";
?>
<div class="post-grid-2">
	<div class="row">
		<?php if ( $query->have_posts() ) :?>
			
			<?php
			$content = Helper::get_current_post_content();
			$content = wp_trim_words( $content, $data['count'] );
			$content = "<p>$content</p>";

			$comments_number = number_format_i18n( get_comments_number() );
			$comments_html   = $comments_number < 2 ? __( 'Comment' , 'barta-core' ) : __( 'Comments' , 'barta-core' );
			$comments_html  .= ': '. $comments_number;
			$count = 1;
			
			$bigOne = $small = null;
			while ( $query->have_posts() ) {  $query->the_post();
				$thumb_size = $thumb_size_small;
				$content = wp_trim_words(get_the_excerpt(), $data['count']);
				if($count == 1){
					$thumb_size = $thumb_size_big;
					$content = wp_trim_words(get_the_content(), 30, '');
				}
				ob_start();
				?>
				
					<div class="rtin-single-post">
						<div class="rtin-img">
							<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( $thumb_size );
								}
								else {
									if ( !empty( BartaTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( BartaTheme::$options['no_preview_image']['id'], $thumb_size );
									}
									else {
										echo '<img class="wp-post-image" src="' . Helper::get_img( 'noimage_542x340.jpg' ) . '" alt="'.get_the_title().'">';
									}
								}
							?>
							<div class="rtin-date">
								<?php the_time ('d'); ?><br />
								<?php the_time ('M'); ?>
							</div>
						</div>
						<div class="rtin-content media-body">
							<h3 class="rtin-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
							<?php echo $content;?>
						</div>
					</div>
				<?php
				$html = ob_get_clean();
				
				if($count == 1){
					$bigOne = $html;
				}else{
					$small .= $html;
				}
				
				$count++;
			}
			
			printf('<div class="bigone col-lg-6 col-md-6 col-sm-12 col-xs-12">%s</div>', $bigOne);
			printf('<div class="small-more col-lg-6 col-md-6 col-sm-12 col-xs-12">%s</div>', $small);
			?>
			

			
		<?php endif;?>
		<?php Helper::wp_reset_temp_query( $temp );?>
	</div>
</div>